#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"

#define NORMAL 1
#define EXERCISE 2
#define SLEEP 3
#define MANUAL 4

#define LRI_const 1
#define URI_const 2
#define AVI_const 3
#define VRP_const 4
#define PVAB_const 5
#define PVARP_const 6

DigitalOut vpaceLED(LED1);
DigitalOut apaceLED(LED2);
DigitalOut vsenseLED(LED3);
DigitalOut asenseLED(LED4);
DigitalOut buzzer(p21);
DigitalOut aPace(p23);
DigitalOut vPace(p24);
InterruptIn ASignal(p25);
InterruptIn VSignal(p26);
DigitalOut Dynamic_AVI(p27);
Serial pc(USBTX, USBRX);

int32_t signal1 = 0x01;
int32_t signal2 = 0x02;
int32_t signal3 = 0x03;
int32_t signal4 = 0x04;
int32_t signal5 = 0x05;

bool waitASignal;
bool waitVSignal;
bool APace = false;
bool waitVPace = true;
bool ASenseReceived = true;
bool VPaceNotReceived = false;
bool alarmPrinted = false;
bool TimeConstTimerOn = false;
bool changePacemakerMode = false;

int heartRate = 0;
float avgHeartRate = 0;
int pacemakerIntervalInMs = 10000;
int pacemakerInterval = 10;
int pacemakerMode = NORMAL;
int timeConstraint;

char char_read;

const int normalModeLRI= 1500;
const int normalModeAVI = 60; //65
const int normalModePVARP = 150;
const int normalModeURI = 600;
const int normalModeVRP = 100;
const int normalModePVAB = 20;

const int sleepModeLRI= 2000;
const int sleepModeAVI = 60; //65
const int sleepModePVARP = 150;
const int sleepModeURI = 1000;
const int sleepModeVRP = 100;
const int sleepModePVAB = 20;

const int exerciseModeLRI=1000;
const int exerciseModeAVI = 60; //65
const int exerciseModePVARP = 150;
const int exerciseModeURI = 400;
const int exerciseModeVRP = 100;
const int exerciseModePVAB = 20;

int LRI;
int VRP;
int PVARP;
int AVI;
int URI;
int PVAB;

int AVI_MAX=70;
int AVISTEP=1;

Mutex displayMutex;
Mutex AMutex;
Mutex VMutex;
Mutex timeConstraintMutex;
Mutex heartRateMutex;
Mutex observationMutex;

Thread *P_PacemakerKeyboard;
Thread *P_PacemakerSend;
Thread *P_PacemakerModeSwitch;
Thread *P_PacemakerReceive;
Thread *P_PacemakerAlarm;

Timer globalTimer;
Timer displayTimer;

RtosTimer *TimeConstTimer;
RtosTimer *AtrialEventTimer;