#include "mbed.h"
#include "rtos.h"
#include "state_type.h"
#include "pacemaker_Param.h"
#include "transition.h"
#include <map>
using namespace std;

Serial pc (USBTX, USBRX);

/* Transition Table and Status */
TRANS_T TRANS[100];
map<Sync, long> SyncStatus;

/* Init Transition Table */
void initTrans(){
    TRANS[0] = TRANS_T(true, AMACHINE_INITIAL, AMACHINE_V, ASENSE);
    TRANS[1] = TRANS_T(true, AMACHINE_INITIAL, AMACHINE_INITIAL, VPACE);
    TRANS[2] = TRANS_T(true, AMACHINE_INITIAL, AMACHINE_INITIAL, VSENSE);
    TRANS[3] = TRANS_T(false, AMACHINE_V, AMACHINE_INITIAL, VPACE);
    TRANS[4] = TRANS_T(false, AMACHINE_V, AMACHINE_INITIAL, VSENSE);
    TRANS[10] = TRANS_T(true, VMACHINE_INITIAL, VMACHINE_INITIAL, VSENSE);
    TRANS[11] = TRANS_T(true, VMACHINE_INITIAL, VMACHINE_AEVENT, ASENSE);
    TRANS[12] = TRANS_T(true, VMACHINE_INITIAL, VMACHINE_AEVENT, APACE);
    TRANS[13] = TRANS_T(false, VMACHINE_AEVENT, VMACHINE_INITIAL, VSENSE);
    TRANS[14] = TRANS_T(false, VMACHINE_AEVENT, VMACHINE_INTER, NONE);
    TRANS[15] = TRANS_T(false, VMACHINE_INTER, VMACHINE_INITIAL, VSENSE);
    TRANS[16] = TRANS_T(false, VMACHINE_INTER, VMACHINE_AEVENT, ASENSE);
    TRANS[20] = TRANS_T(true, VRP_INITIAL, VRP_WAIT, VPACE);
    TRANS[21] = TRANS_T(true, VRP_INITIAL, VRP_VSENSE, VSIGNAL);
    TRANS[22] = TRANS_T(false, VRP_WAIT, VRP_INITIAL, NONE);
    TRANS[30] = TRANS_T(true, PVARP_INITIAL, PVARP_INTER, VPACE);
    TRANS[31] = TRANS_T(true, PVARP_INITIAL, PVARP_INTER, VSENSE);
    TRANS[32] = TRANS_T(false, PVARP_INTER, PVARP_AEVENT, NONE);
    TRANS[33] = TRANS_T(false, PVARP_AEVENT, PVARP_ASENSE, ASIGNAL);
    TRANS[34] = TRANS_T(false, PVARP_AEVENT, PVARP_INITIAL, APACE);
    
    SyncStatus[APACE] = -1000;
    SyncStatus[ASENSE] = -1000;
    SyncStatus[ASIGNAL] = -1000;
    SyncStatus[VPACE] = -1000;
    SyncStatus[VSENSE] = -1000;
    SyncStatus[VSIGNAL] = -1000;
}

/* Global Timer */
long global_time = 0;
long agre_time = 0;
void tick_timer(void const *n)
{
    global_time++;
    agre_time++;
}

/* AMachine Timer */
long AMachine_clock = 0;
void AMachine_timer(void const *n)
{
    AMachine_clock++;
}

/* VMachine Timer */
long VMachine_clock = 0;
void VMachine_timer(void const *n)
{
    VMachine_clock++;
}

/* VRP Timer */
long VRP_clock = 0;
void VRP_timer(void const *n)
{
    VRP_clock++;
}

/* PVARP Timer */
long PVARP_clock = 0;
void PVARP_timer(void const *n)
{
    PVARP_clock++;
}

/* Evaluate Guard */
bool EVAL_GUARD(int trn)
{
    switch(trn) {
        case 0:
            return AMachine_clock >= CURRENT_LRI-AVI;
        case 1:
            return true;
        case 2:
        case 3:
        case 4:
        case 5:
            return true;
        case 10:
        case 11:
        case 12:
        case 13:
            return true;
        case 14:
            return (VMachine_clock >= AVI && global_time < CURRENT_URI);
        case 15:
        case 16:
            return true;
        case 20:
        case 21:
            return true;
        case 22:
            return global_time >= VRP_TIME;
        case 30:
        case 31:
            return true;
        case 32:
            return PVARP_clock >= PVARP_TIME;
    }
    return false;
}

/* Implement Update*/
void ASSIGN(int trn)
{
    switch(trn) {
        case 0:
            break; // Lighten LED
        case 1:
        case 2:
        case 3:
        case 4:
            AMachine_clock = 0;
            break;
        case 10:
        case 13:
        case 15:
            global_time = 0; 
            break;
        case 11:
        case 12:
        case 16:
            VMachine_clock = 0;
            break;
        case 14:
            break;
        case 20:
        case 21:
            VRP_clock = 0;
            break;
        case 22:
        case 32:
            break;
        case 30:
        case 31:
        case 33:
        case 34:
            PVARP_clock = 0;
            break;
    }
}