#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
 
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2);
Serial pc (USBTX, USBRX);
DigitalOut myled(LED1);
 
 
// global vars 
int mm [] = {0, 0};
int ss [] = {0, 0};
int MM [] = {0, 0};
 
// functions
void update_display(void const *args);
void update_mm(void const *args);
void update_ss(void const *args);
void update_MM(void const *args);
 
int main() {
    
    Thread thread_display(update_display);
    Thread * mmptr;
    Thread * ssptr; 
    Thread * MMptr;    
 
    char input = 'z';
    int run_status = 0;
    
    while(1) {
        
        if ( input == 's') { 
            if (run_status==0) {
                mmptr = new Thread(update_mm);
                ssptr = new Thread(update_ss);
                MMptr = new Thread(update_MM);
                run_status = 1;
            }
        }
        if ( input == 'p') {
            if (run_status==1) {
                delete mmptr;
                delete ssptr;
                delete MMptr;
                run_status = 0;
            }
        }
        if ( input == 'r') {
            if (run_status == 0) {
                mm[0] = mm[1] = 0;
                ss[0] = ss[1] = 0;
                MM[0] = MM[1] = 0;
            }
        }
        
        input = pc.getc();

    }
    
}
 
void update_display(void const *args) {
    while (1) {
        lcd.printf("%d%d:%d%d:%d%d\n\n", MM[1], MM[0],ss[1],ss[0],mm[1],mm[0]);
        Thread::wait(10);
    }
}
 
void update_mm(void const *args) {
    while (1) {
        Thread::wait(10);
        mm[0]++;
        if (mm[0] >= 10) {
            mm[0] = 0;
            mm[1]++;
        }
        if (mm[1] >= 10) {
            mm[0] = 0;
            mm[1] = 0;
        }
    }
}
 
void update_ss(void const *args) {
    while (1) {
        Thread::wait(1000);
        ss[0]++;
        if (ss[0] >= 10) {
            ss[0] = 0;
            ss[1]++;
        }
        if (ss[1] >= 6) {
            ss[0] = 0;
            ss[1] = 0;
        }
    }
}
 
void update_MM(void const *args) {
    while (1) {
        Thread::wait(60000);
        MM[0]++;
        if (MM[0] >= 10) {
            MM[0] = 0;
            MM[1]++;
        }
        if (MM[1] >= 6) {
            MM[0] = 0;
            MM[1] = 0;
        }
    }
}
 