#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"

#define RUN 0x1 
#define STOP 0x0

TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2);
Serial pc (USBTX, USBRX);
DigitalOut myled(LED1);

 

// global vars 
int mm [] = {0, 0};
int ss [] = {0, 0};
int MM [] = {0, 0};
int mm_stop [] = {0, 0};
int ss_stop [] = {0, 0};
int MM_stop [] = {0, 0};

int run_status = STOP;

// functions
void update_display(void const *args);
void update_mm(void const *args);
void update_ss(void const *args);
void update_MM(void const *args);

int main() {
    
    Thread thread_display(update_display);
    Thread thread_mm(update_mm);
    Thread thread_ss(update_ss);
    Thread thread_MM(update_MM);
    char input = 'z';

    while(1) {
        if ( input == 's') { 
            if (run_status==STOP) {
                run_status = RUN;
                thread_mm.signal_set(RUN);
                thread_ss.signal_set(RUN);
                thread_MM.signal_set(RUN);
                thread_display.signal_set(RUN);

            }
        }
        if ( input == 'p') {
            if (run_status==RUN) {
                run_status = STOP;
            }
        }
        if ( input == 'r') {
            if (run_status == STOP) {
                mm[0] = mm[1] = 0;
                ss[0] = ss[1] = 0;
                MM[0] = MM[1] = 0;
                mm_stop[0] = mm_stop[1] = 0;
                ss_stop[0] = ss_stop[1] = 0;
                MM_stop[0] = MM_stop[1] = 0;
                thread_display.signal_set(RUN);
            }
        }
        
        input = pc.getc();
    }

}

void update_display(void const *args) {
    while (1) {
        lcd.printf("%d%d:%d%d:%d%d\n\n", MM[1], MM[0],ss[1],ss[0],mm[1],mm[0]);
        Thread::signal_wait(RUN);
        while (run_status) {        
            lcd.printf("%d%d:%d%d:%d%d\n\n", MM[1], MM[0],ss[1],ss[0],mm[1],mm[0]);
            Thread::wait(10);
        }
    }
}

void update_mm(void const *args) {
    while(1){
        Thread::signal_wait(RUN);
        Thread::wait(10-mm_stop[0]);
        mm[0]++;
        if (mm[0] >= 10) {
            mm[0] = 0;
            mm[1]++;
        }
        if (mm[1] >= 10) {
            mm[0] = 0;
            mm[1] = 0;
        }   
        while (run_status) {
            Thread::wait(10);
            mm[0]++;
            if (mm[0] >= 10) {
                mm[0] = 0;
                mm[1]++;
            }
            if (mm[1] >= 10) {
                mm[0] = 0;
                mm[1] = 0;
            }   
        }
        mm_stop[1] = mm[1];
        mm_stop[0] = mm[0];
    }
}

void update_ss(void const *args) {
     while(1) {
        Thread::signal_wait(RUN);
        Thread::wait(1000-100*mm_stop[1]-10*mm_stop[0]);
        ss[0]++;
        if (ss[0] >= 10) {
            ss[0] = 0;
            ss[1]++;
        }
        if (ss[1] >= 6) {
            ss[0] = 0;
            ss[1] = 0;
        }
        while (run_status) {
            Thread::wait(1000);
            ss[0]++;
            if (ss[0] >= 10) {
                ss[0] = 0;
                ss[1]++;
            }
            if (ss[1] >= 6) {
                ss[0] = 0;
                ss[1] = 0;
            }
        }
        ss_stop[1] = ss[1];
        ss_stop[0] = ss[0];
    }
}

void update_MM(void const *args) {
     while(1) {
        Thread::signal_wait(RUN);
        Thread::wait(60000-10000*ss_stop[1]-1000*ss_stop[0]-100*mm_stop[1]-10*mm_stop[0]);
        MM[0]++;
        if (MM[0] >= 10) {
            MM[0] = 0;
            MM[1]++;
        }
        if (MM[1] >= 6) {
            MM[0] = 0;
            MM[1] = 0;
        }
        while (run_status) {
            Thread::wait(60000);
            MM[0]++;
            if (MM[0] >= 10) {
                MM[0] = 0;
                MM[1]++;
            }
            if (MM[1] >= 6) {
                MM[0] = 0;
                MM[1] = 0;
            }
        }
        MM_stop[1] = MM[1];
        MM_stop[0] = MM[0];
    }
}
