#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <time.h>
#include "mbed.h"
#include "cmsis_os.h"
#include "MMA7455.h"
#include "SWSPI.h"
#include "game_board.h" //duck soup
// need to configure uart to 115200 for game shot placement  using uart;
//SPI 2 is use// SPI0 is use
using namespace std;
game_board battle;
RawSerial pc(USBTX, USBRX); // uart //not conflit
RawSerial xbee(P4_22, P4_23); // uart //not conflit
MMA7455 accSensor (P0_27, P0_28); //acceleronmeter i2c // no conflit
SPI LEDs(p5, NC, p7); // LEDs driver spi used
//SPISlave test(p18,p19,p20,p17);
//SPI between board
DigitalOut cs (p30); //no conflict 
//SWSPI Sender(p17,p18,p19); // p11,p12,p13
//DigitalOut b_cs (p20);
//SPI SLAVE to receive;
//SPISlave Receiver(p11,p12,p13,p14);

AnalogIn trimpot(p15);//might need to change the trimpot location if conflict with spi
//SPI (PinName mosi, PinName miso, PinName sclk, PinName ssel=NC) //check mapping for pin
//SPISlave (mosi, miso, sclk, ssel) //check mapping for pin

//joystick
DigitalIn Up(p32);
DigitalIn Down(p38);
DigitalIn Left(p39);
DigitalIn Right(p37);
DigitalIn Center(p31);
//joystick done

//RGB LED
DigitalOut led1(p25); //red
DigitalOut led2(p26);//green
DigitalOut led3(p28);//blue
//RGB LED
int initlize = 0;
//declare your input pin and output pin here:
//DigitalOut led1(p25);
//DigitalOut led2(p26);
//DigitalOut led3(p28);
//
// declare you globle variable here:
unsigned char my_X_coor = 1, my_Y_coor = 1;
uint8_t my_LEDs = 0x1A;
uint8_t SPI_X_send = 0x01,SPI_Y_send = 0x01;
unsigned char other_X_coor = 0, other_Y_coor = 0;
int friendly [6][6]; // array to determine friendly location
int winner; 
int A_x_old = 0,A_y_old = 0,A_z_old = 0;
int send_check = 0;
int update_game_look = 0;
int turns = 0;
//X_coor is x coordinate from 0 to 6
//Y_coor is y coordinate form A to F
//
//
//
void LEDsoutput(uint8_t value) {
    cs.write(0);
    LEDs.write(value);
    cs.write(1);
}
// this thread is your SPI communication between 2 board
void SPI_communication(void const *args) {
    //send my_X_coor and my_Y_coor if the center button is hit
    //receive other board x_coor and y_coor
    //spi code here
    //turn 1 :friendly
    //       player1 send shooting location
    //       player1 get shooting location and whether it hit or miss
    //turn 1 :enemy
    //       get enemy shooting location
    //       check wheather is it a hit or miss
    //       echo enemy shooting location and hit/miss flag
    //send out winner status 
    //       0 = still no winner
    //       1 = i am lose
    //       so if you receive a 1 that mean you win
    //SPI implementation could not get it to work due to run out out spi
    //port for design purpose software spi does not compatible
    //while (true) {
        //if (send_check == 1) {
        //    int message = 0;
        //    int Echo = 0;
        //    message = (SPI_X_send << 4)|SPI_Y_send;
        //    pc.printf ("send message %d\n\r",message);
        //    //b_cs.write(0);
        //    //Echo = Sender.write(0x12);
        //    //osDelay (10);
        //    b_cs.write(1);
        //    pc.printf("get from echo 1 %d\n\r",Echo);
        //    b_cs.write(0);
        //    Echo = Sender.write (0x1FF);
        //    b_cs.write(1);
        //    pc.printf("get from echo 2 %d\n\r",Echo);
        //    bool stat = (Echo &0x100)>>8;
        //    int x_coor = (Echo & 0x0F0)>>4;
        //    int y_coor = (Echo & 0x00F);
        //    battle.place_hit_miss_enemy(x_coor,y_coor,stat);
        //    update_game_look = 1;
        //    send_check = 0;
        //}
        //if (//Receiver.receive()) {
        //    bool status = 0;
        //    int R_message = Receiver.read();
        //    pc.printf("receive message = %d\n\r",R_message);
        //    if ((R_message & 0x200) !=  0) {
        //        winner = 1;
        //    }
        //    else if (R_message != 0x1FF) {
        //        int Y_coor = R_message & 0x00F;
        //        int X_coor = (R_message & 0x0F0) >> 4;
        //        status = battle.place_hit_miss_friendly (X_coor,Y_coor);
        //        int E_message = (status << 8)|R_message;
        //        Receiver.reply(E_message);
        //        pc.printf("echo message = %d",E_message);
        //        update_game_look = 1;
        //    }
        //}
        //osDelay (30);
        
    //}
    //uart xbee impletation it is/
    while(true)
    {
        char R_message [5] = {0,0,0,0,0};
        int got_mess = 0;//temp
        int i = 0;
        
        if(send_check == 1)
        {
            xbee.printf ("S00%d%dE",SPI_X_send,SPI_Y_send);
            send_check = 0;
        }
        
        while(xbee.readable())
        { 
            char temp;
            temp = xbee.getc();
            R_message[i] = temp;
            i = i+1;  
            got_mess = 1;
            osDelay(10);
        }
        if (R_message[0] == 'S')
        {
            int x_coor,y_coor;
            int hit_miss;
            x_coor = (int)R_message[3] - 48;
            y_coor = (int)R_message[4] - 48;
            hit_miss = battle.place_hit_miss_friendly(y_coor,x_coor);
            xbee.printf ("E0%d%d%dE",hit_miss,x_coor,y_coor);
            //pc.printf ("x=%d y=%d\n\r",x_coor,y_coor);
            update_game_look = 1;
        }
        else if (R_message[0] == 'E')
        {
            int x_coor,y_coor;
            int hit_miss;
            hit_miss = (int)R_message[2] - 48;
            x_coor = (int)R_message[3] - 48;
            y_coor = (int)R_message[4] - 48;
            battle.place_hit_miss_enemy(y_coor,x_coor,(bool)hit_miss);
            update_game_look = 1;
        }
        else if (R_message[0] == 'W')
        {
            winner = 1;
        }
        //osDelay(30);
    }
}

// joystick update x_coor and y_coor here
void joy_stick_read(void const *args) { //might be an interrupt thread here for interrupt read of joystick
    // joy stick to update global val of x_coor and y_coor;
    // convert y coor to hex offset
    // update the 8 LEDs here
    while (true) {
        //pc.printf ("in joystick");
        if (Up.read() == 0) {
            my_Y_coor = my_Y_coor + 1;
            if (my_Y_coor == 7) {
                my_Y_coor = 1;
            }
        } else if (Down.read() == 0) {
            my_Y_coor = my_Y_coor - 1;
            if (my_Y_coor == 0) {
                my_Y_coor = 6;
            }
        } else if (Left.read() == 0) {
            my_X_coor = my_X_coor + 1 ;
            if (my_X_coor == 7) {
                my_X_coor = 1;
            }
            //my_LEDs = my_X_coor;
        } else if (Right.read() == 0) {
            my_X_coor = my_X_coor - 1;
            if (my_X_coor == 0) {
                my_X_coor = 6;
            }
        }
        //my_LEDs = my_X_coor;
        else if (Center.read() == 0) {
            //pc.printf ("got middle\n\r");
            SPI_X_send = my_X_coor;
            SPI_Y_send = my_Y_coor;
            //pc.printf ("spi x = %d\n\r",SPI_X_send);
            //pc.printf ("spi y = %d\n\r",SPI_Y_send);
            send_check = 1;
        } else {
            my_X_coor = my_X_coor;
            my_Y_coor = my_Y_coor;
        }
        my_LEDs = (my_X_coor << 5)|(0x0F-(my_Y_coor-1));
        LEDsoutput (my_LEDs);
        osDelay (170);
    }
    //joystick is done and over with DO NOT touch
     
}

// this thread use to update the game board
void game_view_update (void const *args) {
    // board of this game will be a class this update and get info to and from the class
    // update the by led game update
    // Uart runing at 921600 max speed; hopefully print 1 line and out;
    // using an interger then cycle through the get string function to put it inti the printf function
    
    // * = hit
    // o = miss
    // > = your ship ship
    
    // 1) check for a hit
    // 2) update the game board
    
    // BLANK game Board
    // F _ _ _ _ _ _   F _ _ _ _ _ _ 
    // E _ _ _ _ _ _   E _ _ _ _ _ _ 
    // D _ _ _ _ _ _   D _ _ _ _ _ _ 
    // C _ _ _ _ _ _   C _ _ _ _ _ _ 
    // B _ _ _ _ _ _   B _ _ _ _ _ _ 
    // A _ _ _ _ _ _   A _ _ _ _ _ _ 
    //   1 2 3 4 5 6     1 2 3 4 5 6
    // Friendly        Enemy
    
    // Example of running game
    // F _ O _ > _ _   F _ O _ _ _ _ 
    // E > _ O _ > _   E _ _ * _ _ _ 
    // D _ _ > _ _ _   D _ _ _ O _ _ 
    // C O _ _ _ _ _   C _ O _ _ _ _ 
    // B _ * _ O _ _   B _ _ _ * _ _   //X on friendly mean your ship got destroy 
    // A _ _ _ > _ _   A _ _ _ _ _ _ 
    //   1 2 3 4 5 6     1 2 3 4 5 6
    // Friendly        Enemy
    // Turn 1 = miss at 2F
    // Turn 2 = We sink an enemy battle ship at 3E
    // Turn 3 = miss at 4D
    // Turn 4 = miss at 2C
    // Tunr 5 = We sink an enemy battle ship at 4B
    while (true) {
        if (update_game_look == 1) {
            turns = turns + 1;
            update_game_look = 0;
            int i;
            pc.printf ("\fTurn :%d\n\r",turns);
            for (i = 1; i < 9; i++) {
                string a;
                a = battle.get1row(i);
                pc.printf ("%s", a);
            }
        }
        osDelay (30);
    }
           
}

// code here to check for winer and turn on the RGB
void winnercheck (void const *args)
{
    //check for winner by destroy all enemy ship;
    while (true) {
        bool gamelost = 0;
        gamelost = battle.looser();
        //winner = 1;
        if (gamelost == 1) {
            led1 = 1;
            led2 = 1;
            led3 = 1;
            xbee.printf("W0000E");
            while(winner == 0)
            {
                osDelay(30);
            }
            //this board is loser
            //send a message of 0x200 to the winner
        } else if (winner == 1) { //spi message is the winner)
            pc.printf("Spectacular Battle commander\n\r");
            while (winner == 1) {
                //pc.printf ("%d \n\r",rand()%2);
                led1 = (rand()%2);
                led2 = (rand()%2);
                led3 = (rand()%2);
                osDelay(30);
            }
        }
        else {
            led1 = 1;
            led2 = 1;
            led3 = 1;
        }

    }
}

//read the accele
void checkreset (void const *args)
{

    //read the acceleron meter and compare against the previous value to
    //determine if the board have been shake the reset the game board;
    //the determinant is the x axis
    while (true) {

        int Ax,Ay,Az;
        int x_old = 0, y_old = 0;
        int x, y;
        int i;
        int seed = trimpot.read()*1000;
        
        srand (seed);
        if(! accSensor.read(Ax,Ay,Az)) {};
        if (abs(Ax-A_x_old) > 20) {
            winner = 0;
            turns = 0;
            pc.printf ("\fNew Game: Battle Ship Θ\n\r");
            battle.new_game_board();
            //randomize ship position 6 ship total
            for (i = 0; i < 7; i++) {
                x = (rand()%6 +1);
                while (x == x_old) {
                    x = (rand()%6 +1);
                }
                x_old = x;
                y = (rand()%5 +1);
                while (y == y_old) { 
                    y = (rand()%5 +1);
                }
                y_old = y;
                battle.place_ship(x,y);
            }
            //pc.printf ("\f");
            for (i = 1; i < 9; i++) {
                string a;
                a = battle.get1row(i);
                pc.printf ("%s", a);
            }
            Ax = 0;
            A_x_old = 0;
        } else
            A_x_old = Ax;
        osDelay(500);
    }
    //reset is done and working do not touch
}


osThreadDef(SPI_communication, osPriorityNormal, DEFAULT_STACK_SIZE); //comm between 2 board define thread
osThreadDef(joy_stick_read, osPriorityNormal, DEFAULT_STACK_SIZE);//might be an interrupt define thread
osThreadDef(game_view_update, osPriorityNormal, DEFAULT_STACK_SIZE);//update game view write to the fifo uart buffer define thread
osThreadDef(winnercheck, osPriorityNormal, DEFAULT_STACK_SIZE); //check for winner define thread
osThreadDef(checkreset, osPriorityNormal, DEFAULT_STACK_SIZE); //check for reset define thread

int main() {
    osThreadCreate(osThread(SPI_communication), NULL);//done but now is uart
    osThreadCreate(osThread(joy_stick_read), NULL); //done
    osThreadCreate(osThread(game_view_update), NULL);//done
    osThreadCreate(osThread(winnercheck), NULL);//buggy
    osThreadCreate(osThread(checkreset), NULL);//done
    
    if (initlize == 0)
    {
        int x_old = 0, y_old = 0;
        int x, y;
        int i;
        int seed = trimpot.read()*1000;
        winner = 0;
        srand (seed);
        pc.baud(921600);
        xbee.baud(115200);
        
        pc.printf("Battle Ship by Andy, Adam, Loc, Ivan\n\r");
        while(!accSensor.setMode(MMA7455::ModeMeasurement)) {
           pc.printf("Unable to set measurement mode.\n\r");
        }
        while(!accSensor.setRange(MMA7455::Range_8g)) {
           pc.printf("Unable to set the range.\n\r");
        }
        while(!accSensor.calibrate()) {
           pc.printf("Unable to calibrate\n\r");
        }
       battle.new_game_board();
       for (i = 1; i < 9; i++){
            string a;
            a = battle.get1row(i);
            pc.printf ("%s", a);
            
        }
        //randomize ship position 6 ship total
        for (i = 0; i < 7; i++) {
            x = (rand()%6 +1);
            while (x == x_old) 
            {
                x = (rand()%6 +1);
            }
            x_old = x;
            y = (rand()%5 +1);
            while (y == y_old) 
            {
                y = (rand()%5 +1);
            }
            y_old = y;
            battle.place_ship(x,y);
        }
        pc.printf("\fBattle Ship by Andy, Adam, Loc, Ivan\n\r");
        for (i = 1; i < 9; i++){
            string a;
            a = battle.get1row(i);
            pc.printf ("%s", a);
        }
        initlize = 1;
        
    }
    //Main Thread
    while (true) {
        osDelay (30); 
    }
}
