#include "mbed.h"
#include "cmsis_os.h"
#include <iostream>
#include <string>

/*
Slave firmware
Description: Baud rate - 115200

*/
//RawSerial object_name(PinName tx, PinName rx)
RawSerial uart4(p37, p31);

PwmOut slave_pwmout(p27);

string received; 
string sent;
bool GD = false; //global boolean variable for device dimming 
bool GP = false; //global boolean variable for device power ON/OFF
int convert_val;
float dim_percent = 0.0;

int i = 0; //intialize
int j = 0;

int main ()
{
    //Receive message - Slave light receiving message from Master
    while (uart4.readable() != 0) //determines if there is a character to read
    {
        char buf; 
        buf = uart4.getc(); //reads a char from the serial port and places into temp mailbox
        received[i] = buf; //stores the read char
        i++; //traverse through array
        osStatus.wait(0.5); //Check this value ~ 0.5 ms
    
    } //Note: May have to reset counter to 0
    
     
    
    // --------------------------- G-Code -----------------------------------------
    
    
    if (received[0:1] == "GD") // if there is a dimming request: G -start character, D - dim
    {
           convert_val = atoi(received[2:4]);
           GD = true;
    }
    
    
    else GD = false;
    
    if (received[0:1] == "GP")
    {
        if (received[2:4] == "000") // Slave light OFF
        {
            convert_val = atoi(received[2:4]);
            break;
            //break and jump to action thread
        }   
        
        else if (received[2:4] == "100") // Slave light FULL ON
        {
            convert_val = atoi(received[2:4]);
            break;   
            //break and jump to action thread
        }
        
        else GP = false;
        
    }
    //action thread here
    if (GD == true || GP == true)
    {
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        slave_pwmout(dim_percent); //output to PWM
        //printf("GED%i", +convert_val);   
        
         //Send confirmation - Slave to Master light------------------------------------
         //Use putc() or printf
    
        while (uart4.writeable() != 0) // Maybe split up the cases here?
        {
            char buf_confirm;
            buf_confirm = uart4.putc(received[j]);
            sent[j] = received[j]; //optional store for printing later
            j++   
        
        }
                
    }

   
    
   
     
}