#include "mbed.h"
#include "cmsis_os.h"
#include <iostream>
#include <string>

/*
Master firmware
Description: Baud rate - 115200

Priority: (1)Master requests
          (2)Send data to slave
          (3)Confirmation data from slave

*/
//RawSerial object_name(PinName tx, PinName rx)
RawSerial master_uart4(p37, p31);

PwmOut master_pwmout(p27);

string received; //from slave 
string sent; //to slave
bool GD = false; //global boolean variable for master dimming 
bool GP = false; //global boolean variable for master power ON/OFF
bool RDS = false; //global boolean variable for request to slave dimming
bool RPS = false; //global boolean variable for request to slave power ON/OFF
bool CDS = false; //global boolean variable for confirmation from slave dimming
bool CPS = false; //global boolean variable for confirmation from slave power ON/OFF
int convert_val = 0;
int s_dim_amt = 0;
float dim_percent = 0.0;

int i = 0; //intialize
int j = 0;
char box;

int main ()
{    
    //Receive message - Slave light receiving message from Master
    while (master_uart4.readable() != 0) //determines if there is a character to read
    {
        char buf; 
        buf = master_uart4.getc(); //reads a char from the serial port and places into temp mailbox
        received[i] = buf; //stores the read char
        i++; //traverse through array
        osStatus.wait(0.5); //Check this value ~ 0.5 ms
    
    } //Note: May have to reset counter to 0
    
     
    
    // --------------------------- G-Code -----------------------------------------
    
    switch (received [0:1])
    {
     case (GD): // Master DIM
        convert_val = atoi(received[2:4]);
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        master_pwmout(dim_percent); //output to PWM
        break;
     
     case (GP): // Master Power ON/OFF
        convert_val = atoi(received[2:4]);
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        master_pwmout(dim_percent); //output to PWM
        break;
        
     default:   
        
    }
    
    switch (received [0:2]) //use a flag to confirm each case?
    {
     case (RDS): //Request dimming of slave
        s_dim_amt = atoi(received[3:5]);
        while (master_uart4.writeable() != 0)
        {
            master_uart4.putc('G');
            master_uart4.putc('D');
            master_uart4.puts(received[3:5]); //string received parsed for dim amount
            //create a thread that waits for an event - namely confirmation from slave
        }
        break;
     
     case (RPS): //Request power ON/OFF of slave
        while (master_uart4.writeable() != 0)
        {    
            master_uart4.putc('G');
            master_uart4.putc('P');
            master_uart4.puts(received[3:5]); //string received parsed for power on/off
            //create a thread that waits for an event - namely confirmation from slave
        }
        break;
        
     case (CDS): //Confirmation of dimming of slave
        
        break;
     
     case (CPS): //Confirmation of ON/OFF of slave
        
        break;
        
     default:   
        
        
    }       
    if (received[0:1] == "GD") // if there is a dimming request: G -start character, D - dim
    {
           convert_val = atoi(received[2:4]);
           GD = true;
    }
    
    
    else GD = false;
    
    if (received[0:1] == "GP")
    {
        if (received[2:4] == "000") // Slave light OFF
        {
            convert_val = atoi(received[2:4]);
            break;
            //break and jump to action thread
        }   
        
        else if (received[2:4] == "100") // Slave light FULL ON
        {
            convert_val = atoi(received[2:4]);
            break;   
            //break and jump to action thread
        }
        
        else GP = false;
        
    }
    
    //action thread here
    if (GD == true || GP == true)
    {
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        master_pwmout(dim_percent); //output to PWM
        //printf("GED%i", +convert_val);   
        
         //Send request to Slave light ------------------------------------
         //Use putc() or printf
    
        while (uart4.writeable() != 0) // Maybe split up the cases here?
        {
            char buf_confirm;
            buf_confirm = uart4.putc(received[j]);
            sent[j] = received[j]; //optional store for printing later
            j++   
        
        }
                
    }

   
    
   
     
}