#include "mbed.h"
#include "cmsis_os.h"
#include <iostream>
#include <string>

/*
Master firmware
Description: Baud rate - 115200

Priority: (1)Master requests
          (2)Send data to slave
          (3)Confirmation data from slave

*/
//RawSerial object_name(PinName tx, PinName rx)
RawSerial master_uart4(p37, p31);

PwmOut master_pwmout(p27);

bool master_manual = false;
bool slave_manual = false;
string received = ""; //from slave 
string sent = ""; //to slave

string feather_receive = ""; //data recieved from Feather
string feather_sent = ""; //data sent to the Feather

int convert_val = 0;
int s_dim_amt = 0;
float dim_percent = 0.0;

int i = 0; //intialize
int j = 0;
char box;

void wifi_communication_action(void const *args)
{
    while(1){
        // Data frame[18]: G S | M A | 000 | 000 | S | A | 000 | 000 
        // 'GWDM' 0-100 Master Light Level, OR 'GWDS' 0-100 Slave Light Level
        char wifi_message [18] = {'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'};
        string message = ""; // Empty Message String
        int i = 0; // Iterator
        
        while(wifi.readable()) { // Receive Webapp Data from Adafruit Feather
            wifi_message[i] = wifi.getc(); // Get each character WiFi Message.
            i = i+1; // Iterate.
            osDelay(10); // Delay the OS 10ms WILL MOST LIKELY ADJUST TIMING FOR LAST 10% COMPLETION
        }
        
        message = wifi_message; // Save the character array as a string. USELESS
        pc.printf(wifi_message);
        i = 0; // Reset the iterator.
        // ------------------------------Data process --------------------------------------------------------
        if (wifi_message [3] == 0 ) // Check: Manual mode for Master
            master_manual = true;
        if (wifi_message [11] == 0) // Check: Manual mode for Slave
            slave_manual = true;
                    
        if (wifi_message [2] == 'D') { // if Dimming check if slave
            if(wifi_message[3] == 'S') { // if slave print message
                pc.printf(wifi_message);
            } else if (wifi_message[3] == 'M') { // else if master, parse message
                int temp1, temp2, temp3; // temp values convert char to int
                temp1 = (int)wifi_message[4] - 48;//100's place || CHAR '0' IS 48 IN DEC
                temp2 = (int)wifi_message[5] - 48;//10's place  || CHAR '0' IS 48 IN DEC
                temp3 = (int)wifi_message[6] - 48;//1's place   || CHAR '0' IS 48 IN DEC
                M_Dim = (temp1*100)+(temp2*10)+(temp3); // create int value || ABILITY TO GO OVER 100%???
                Dim_amount = (float)M_Dim/100; // get dim percentage
                Master_signal.write(Dim_amount); // write dim level to PWM
                //pc.printf("%0.3f dimval",Dim_amount);
            }
        }
    }
}

void wifi_data_parse (void const *args)

// Send WiFi Status
void wifi_status_send(void const *args)
{
    // Send Dim level message from GSM (General Status Master)
    while(1){
    wifi.printf("GSM%03d000S000000",M_Dim);
    // Delay the OS by 3 seconds
    osDelay(3000); // updating status every 3 seconds
    }
}

// Define OS Thread to handle Communication between the master and the slave.
osThreadDef(wifi_communication_action, osPriorityNormal, DEFAULT_STACK_SIZE);
// Define OS Thread for sending Status
osThreadDef(wifi_status_send, osPriorityNormal, DEFAULT_STACK_SIZE);

int main ()
{    
    //Receive message - Slave light receiving message from Master
    while (master_uart4.readable() != 0) //determines if there is a character to read
    {
        char buf; 
        buf = master_uart4.getc(); //reads a char from the serial port and places into temp mailbox
        received[i] = buf; //stores the read char
        i++; //traverse through array
        osStatus.wait(0.5); //Check this value ~ 0.5 ms
    
    } //Note: May have to reset counter to 0
    
     
    
    // --------------------------- G-Code -----------------------------------------
    
    switch (received [0:1])
    {
     case (GD): // Master DIM
        convert_val = atoi(received[2:4]);
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        master_pwmout(dim_percent); //output to PWM
        break;
     
     case (GP): // Master Power ON/OFF
        convert_val = atoi(received[2:4]);
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        master_pwmout(dim_percent); //output to PWM
        break;
        
     default:   
        
    }
    
    switch (received [0:2]) //use a flag to confirm each case?
    {
     case (RDS): //Request dimming of slave
        s_dim_amt = atoi(received[3:5]);
        while (master_uart4.writeable() != 0)
        {
            master_uart4.putc('G');
            master_uart4.putc('D');
            master_uart4.puts(received[3:5]); //string received parsed for dim amount
            //create a thread that waits for an event - namely confirmation from slave
        }
        break;
     
     case (RPS): //Request power ON/OFF of slave
        while (master_uart4.writeable() != 0)
        {    
            master_uart4.putc('G');
            master_uart4.putc('P');
            master_uart4.puts(received[3:5]); //string received parsed for power on/off
            //create a thread that waits for an event - namely confirmation from slave
        }
        break;
        
     case (CDS): //Confirmation of dimming of slave
        
        break;
     
     case (CPS): //Confirmation of ON/OFF of slave
        
        break;
        
     default:   
        
        
    }       
    if (received[0:1] == "GD") // if there is a dimming request: G -start character, D - dim
    {
           convert_val = atoi(received[2:4]);
           GD = true;
    }
    
    
    else GD = false;
    
    if (received[0:1] == "GP")
    {
        if (received[2:4] == "000") // Slave light OFF
        {
            convert_val = atoi(received[2:4]);
            break;
            //break and jump to action thread
        }   
        
        else if (received[2:4] == "100") // Slave light FULL ON
        {
            convert_val = atoi(received[2:4]);
            break;   
            //break and jump to action thread
        }
        
        else GP = false;
        
    }
    
    //action thread here
    if (GD == true || GP == true)
    {
        dim_percent = (convert_val)/100; //percentage range: [0.0-1.0]
        master_pwmout(dim_percent); //output to PWM
        //printf("GED%i", +convert_val);   
        
         //Send request to Slave light ------------------------------------
         //Use putc() or printf
    
        while (uart4.writeable() != 0) // Maybe split up the cases here?
        {
            char buf_confirm;
            buf_confirm = uart4.putc(received[j]);
            sent[j] = received[j]; //optional store for printing later
            j++   
        
        }
                
    }

   
    
   
     
}