#include "mbed.h"
#include "cmsis_os.h"
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <string>
#include <ctype.h>

RawSerial XBEE(p37, p31); //Master to slave communication

RawSerial pc(USBTX,USBRX); //UART monitor from pc
RawSerial wifi(p9, p10); // master to wifi UART

PwmOut pwm(p27);
AnalogIn pot(p15);

#define zero (float)0.01

float pot_value = 0.0;

bool master_manual = false;
bool slave_manual = false;

string masterMode = "";
string slaveMode = "";
string received = "";
string sent = "";
//string wifi_receive = ""; //data recieved from Feather
string wifi_sent = ""; //data sent to the Feather
string slave_status = "";


int sDimAmt = 0;
int mDimAmt = 0;
int sTemp = 0;
int mTemp = 0;
float dim_percent = 0.0;

int itterate = 0;

bool receiveComplete = false;
bool decodeComplete = false;
bool xbee_read_done = false;
bool xbee_decode_done = false;
bool xbee_status_send = false;
char wifi_message [16] = {'M','A','0','0','0','0','0','0','S','A','0','0','0','0','0','0'};
char xbee_buffer [8] = {};

//Thread for receiving data
void wifi_receive(void const *args) {
    while (1)
    {
        
        //pc.printf("in receive");
        while (pc.readable()){ //DEBUGGING purposes
            //pc.printf("in read mode");
            char temp = pc.getc();
            wifi_message[itterate] = temp; //DEBUGGING purposes
            itterate = itterate+1;
            //pc.printf("I counter = : %d\n\r",itterate); 
            //pc.printf("I counter = : %d",i);    
            osDelay(1); 
        }
        //pc.printf(wifi_message);
        
        if(itterate >= 15) //Done receiving
        {
            //pc.printf("I counter = : %d\n\r",itterate); 
            receiveComplete = true;
            itterate = 0; //reset iterator
            pc.printf(wifi_message);
        }
        //else if (itterate < 17)
        //{
        //    pc.printf("I counter = : %d\n\r",itterate);
        //}
        osDelay(45);
       
    } // END superloop
}// END wifi_receive thread
    
void wifi_decode(void const *args) {
    
    while (1) {
        if(receiveComplete )
        {
            receiveComplete = false;
            if(wifi_message[0] == 'M' && wifi_message[8] == 'S')
            {
                int data [12] = {};
                for (int i = 0; i < 6; i++)
                {
                    data[i] = (int)wifi_message [i+2]-48;
                    data[i+6] = (int)wifi_message[i+10]-48;   
                    
                }
                
                mDimAmt = (data[0]*100)+(data[1]*10)+(data[2]); //Data 0:2 is the 3 digit percentiloe for Master
                mTemp = (data[3]*100)+(data[4]*10)+(data[5]);
                sDimAmt = (data[6]*100)+(data[7]*10)+(data[8]); //Data 6:8 is the 3 digit percentile for Slave
                sTemp = (data[9]*100)+(data[10]*10)+(data[11]);
                pc.printf("%03d-%03d-%03d-%03d\n\r",mDimAmt,mTemp,sDimAmt,sTemp);
                //pc.printf("Master dim amount: %03d\n\r", mDimAmt);
                //pc.printf("Slave dim amount: %03d\n\r", sDimAmt);
                
                //SET mutex for wifi action HERE
                decodeComplete = true;
                xbee_status_send = true;
            }           
        }
        
     osDelay(45);  
    } //END superloop
} //END wifi_decode thread    

void wifi_action(void const *args) {

    while (1) {
        //if(decodeComplete)
        //{
            if(master_manual == false)
            {
                //pc.printf("in auto mode diming");
                float dimamount = (float)mDimAmt/100;
                pwm.write(dimamount); //send out dim value   
            }   
        //}
        osDelay(10);
    } //END superloop    
} //END wifi_action thread    

void light_status_update(void const *args) {
    while (1) {
        //pc.printf("MA000000SA000000");
        pot_value = pot.read();
        
        if(pot_value > zero )
        {
            master_manual = true;
            pwm.write(pot_value);
            masterMode = "M";   
        }
        else if (pot_value < zero)
        {
            master_manual = false;
            masterMode = "A";
        }
        if (decodeComplete == true)
        {
            pc.printf("GSM%s%03d%03d",masterMode,mDimAmt,mTemp);
            decodeComplete = false;
        }
        osDelay(300);
            
    } //END superloop
} //END thread light_status_update

void xbee_receive(void const *args) {
    while (1) {
        while (XBEE.readable())
        {
            int i = 0;
            char temp;
            temp = XBEE.getc();
            xbee_buffer [i] = temp;
            i = i + 1;
            osDelay(10);   
            
        }
        
        xbee_read_done = true;
        pc.printf(xbee_buffer); // DEBUGGING purposes
    
    } //END superloop    
} //END xbee_receive

void xbee_decode(void const *args) {
    while (1) {
        if(xbee_read_done)
        {
            xbee_read_done = false;
            slave_status = (string)xbee_buffer;
            xbee_decode_done = true;
        }
        osDelay(30);    
    } //END superloop
} //END xbee_decode

void xbee_action(void const *args)
{
    while (1) {
        if( xbee_status_send ) //FILL IN wifi message decode
        {
            XBEE.printf("SA%03d%03d",sDimAmt,sTemp);
            xbee_status_send = false;   
        }
        osDelay(30);
    }//END superloop    
} //END xbee_action

osThreadDef(wifi_receive, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(wifi_decode, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(wifi_action, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(light_status_update, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(xbee_receive, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(xbee_decode, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(xbee_action, osPriorityNormal, DEFAULT_STACK_SIZE);

int main ()
{
    osThreadCreate(osThread(wifi_receive),NULL);
    osThreadCreate(osThread(wifi_decode),NULL);
    osThreadCreate(osThread(wifi_action),NULL);
    osThreadCreate(osThread(light_status_update),NULL);
    osThreadCreate(osThread(xbee_receive),NULL);
    osThreadCreate(osThread(xbee_decode),NULL);
    osThreadCreate(osThread(xbee_action),NULL);
    pc.baud(115200);
    wifi.baud(115200);
    XBEE.baud(115200);
    while(1)
    {
        osDelay(30);
    }
}//END main



 