#include "mbed.h"
#include "cmsis_os.h"
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <string>

/*
Master firmware
Description: Baud rate - 115200

Priority: (1)Master requests
          (2)Send data to slave
          (3)Confirmation data from slave

*/
//RawSerial object_name(PinName tx, PinName rx)
RawSerial XBEE(p37, p31); //Master to slave communication

RawSerial pc(USBTX,USBRX); //UART monitor from pc
RawSerial wifi(p9, p10); // master to wifi UART

AnalogIn m_pot(p15);

float m_pot_val = 0.0;
float s_pot_val = 0.0;

PwmOut pwm(p27);

bool master_manual = false;
bool slave_manual = false;
string received = ""; //from slave 
string sent = ""; //to slave

string feather_receive = ""; //data recieved from Feather
string feather_sent = ""; //data sent to the Feather

int convert_val = 0;
int s_dim_amt = 0;
int m_dim_amt = 0;
int s_temp = 0;
int m_temp = 0;
float dim_percent = 0.0;

int i = 0; //intialize
int j = 0;
char box;

void wifi_communication_action(void const *args)
{
    while(1){
        // Data frame[18]: G S | M A | 000 | 000 | S | A | 000 | 000 
        // 'GWDM' 0-100 Master Light Level, OR 'GWDS' 0-100 Slave Light Level
        char wifi_message [18] = {'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'};
        string message = ""; // Empty Message String
        int i = 0; // Iterator
        
        while(wifi.readable()) { // Receive Webapp Data from Adafruit Feather
            wifi_message[i] = wifi.getc(); // Get each character WiFi Message.
            i = i+1; // Iterate
            osDelay(10); // Delay the OS 10ms WILL MOST LIKELY ADJUST TIMING FOR LAST 10% COMPLETION
        }
        
        //message = wifi_message; // Save the character array as a string. USELESS
        pc.printf(wifi_message); //Echo to terminal
        i = 0; // Reset the iterator
        // ------------------------------Data parsing --------------------------------------------------------
        
        if ( toupper(wifi_message [0]) == "G" && wifi_message [2] == "M" && wifi_message [10] == "S" )
        {
            m_dim_amt = atoi(wifi_message[4:6]);
            m_temp = atoi(wifi_message[7:9]);
            s_dim_amt = atoi(wifi_message[12:14]);
            s_temp = aoti(wifi_message[15:17]);
            
            if (wifi_message [1] == "S") //Print status
            {
                pc.printf(wifi_message); //Echo to terminal
            }
            
            else if (wifi_message [1] == "D") //Dim
            {
              m_dim_amt = atoi(wifi_message[4:6]);
              m_temp = atoi(wifi_message[7:9]);
              s_dim_amt = atoi(wifi_message[12:14]);
              s_temp = aoti(wifi_message[15:17]);
                    
            }           
                    
        }         
        
        // ----------------------------- Prioritize Wireless/Manual Mode -----------------------------------
        
        if ( m_pot.read() > 0.0 )
        {
            if (wifi_message [3] == "0" ) // Check: Manual mode for Master
            {
                master_manual = true;
                m_pot_val = m_pot.read(); //read in value from potentiometer
                pwm.write(m_pot_val); //output potentiometer value to pwm
            } 
        
            else if (wifi_message [3] == "1" ) //Check: Wireless for master
            {
                pwm.write((float)(m_dim_amt/100)); //Send out dim value from parsed data wirelessly    
            
            }
        }
          
        if ( s_pot.read() > 0.0)
        {  
            if (wifi_message [11] == "0") // Check: Manual mode for Slave
            {
                slave_manual = true;
                s_pot_val = s_pot.read();
                pwm.write(s_pot_val);
            }   
            else if (wifi_message [11] == "1" ) //Check: Wireless for slave
            {
                pwm.write((float)(s_dim_amt/100)); //Send out dim value from parsed data wirelessly    
                        
            }
        }            
        
        /*     
        if (wifi_message [2] == 'D') { // if Dimming check if slave
            if(wifi_message[3] == 'S') { // if slave print message
                pc.printf(wifi_message);
            } else if (wifi_message[3] == 'M') { // else if master, parse message
                int temp1, temp2, temp3; // temp values convert char to int
                temp1 = (int)wifi_message[4] - 48;//100's place || CHAR '0' IS 48 IN DEC
                temp2 = (int)wifi_message[5] - 48;//10's place  || CHAR '0' IS 48 IN DEC
                temp3 = (int)wifi_message[6] - 48;//1's place   || CHAR '0' IS 48 IN DEC
                M_Dim = (temp1*100)+(temp2*10)+(temp3); // create int value || ABILITY TO GO OVER 100%???
                Dim_amount = (float)M_Dim/100; // get dim percentage
                Master_signal.write(Dim_amount); // write dim level to PWM
                //pc.printf("%0.3f dimval",Dim_amount);
            }
        }
        */
    } //end superloop
}//end thread


// Send WiFi Status
void wifi_status_send(void const *args)
{
    // Send Dim level message from GSM (General Status Master)
    while(1){
    wifi.printf("GSM%03d000S000000",M_Dim);
    // Delay the OS by 3 seconds
    osDelay(3000); // updating status every 3 seconds
    }
}

// Define OS Thread to handle Communication between the master and the slave.
osThreadDef(wifi_communication_action, osPriorityNormal, DEFAULT_STACK_SIZE);
// Define OS Thread for sending Status
osThreadDef(wifi_status_send, osPriorityNormal, DEFAULT_STACK_SIZE);

int main ()
{    
    //Receive message - Slave light receiving message from Master
    while (master_uart4.readable() != 0) //determines if there is a character to read
    {
        char buf; 
        buf = master_uart4.getc(); //reads a char from the serial port and places into temp mailbox
        received[i] = buf; //stores the read char
        i++; //traverse through array
        osStatus.wait(0.5); //Check this value ~ 0.5 ms
    
    } //Note: May have to reset counter to 0
    
     
        
}