#include "mbed.h"
#include "cmsis_os.h"
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <string>
#include <ctype.h>

RawSerial pc(USBTX,USBRX);
RawSerial XBEE(p37,p31);
PwmOut pwm(p27);
AnalogIn pot(p15);

#define ZERO (float)0.01
#define BAUD_RATE (int)115200

float pot_value = 0.0;
bool slave_manual = false;
bool xbee_read_done = false;
bool xbee_decode_done = false;
//string received = ""; // May need to delete
string sent = "";
string slaveMode = "";
char xbeeBuffer [8] = {};
int sDimAmt = 0;
int sTemp = 0;
int data [6] = {};

// XBEE Receive thread
void xbee_receive(void const *args)
{
    while(1)
    {
        while(XBEE.readable())
        {
            int i = 0;
            char temp;
            temp = XBEE.getc();
            xbeeBuffer[i] = temp;
            i = i+1;
            osDelay(10);
        }
        xbee_read_done = true;
        pc.printf(xbeeBuffer); // DEBUG
    }
}

// XBEE Decode thread
void xbee_decode(void const *args)
{
    while(1)
    {
        if(xbee_read_done)
        {
            xbee_read_done = false; // Reset flag
            
            for (int i = 0; i < 6; i++)
            {
                data[i] = (int)xbeeBuffer[i+2]-48;
            }
            
            sDimAmt = (data[0]*100)+(data[1]*10)+(data[2]); //Data 0:2 is the 3 digit percentiloe for Master
            sTemp = (data[3]*100)+(data[4]*10)+(data[5]);
            pc.printf("SLave dim amount: %03d\n\r", sDimAmt);
            xbee_decode_done = true;
        }
        osDelay(10);
    }
}

// XBEE Action thread
void xbee_action(void const *args)
{
    while(1)
    {
        pot_value = pot.read();
        if(pot_value > ZERO)
        {
            slave_manual = true;
            pwm.write(pot_value);
            slaveMode = "M";
        }
        else if (pot_value < ZERO)
        {
            slave_manual = false;
            slaveMode = "A";
        }
        
        if(xbee_decode_done)
        {
            xbee_decode_done = false;
            sent = "S" + slaveMode;
            for(int i = 0; i < 6; i++)
            {
                sent += xbeeBuffer[i+2]-48;
            }
            pc.printf("%s", sent);
        }
        osDelay(10);
    }
}

osThreadDef(xbee_receive, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(xbee_decode, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(xbee_action, osPriorityNormal, DEFAULT_STACK_SIZE);

int main ()
{
    osThreadCreate(osThread(xbee_receive),NULL);
    osThreadCreate(osThread(xbee_decode),NULL);
    osThreadCreate(osThread(xbee_action),NULL);
    pc.baud(BAUD_RATE);
    XBEE.baud(BAUD_RATE);
    while(1)
    {
        osDelay(30);
    }
}

