#include "mbed.h"
#include "cmsis_os.h"
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <string>
#include <ctype.h>

/*
Master firmware
Description: Baud rate - 115200

Priority: (1)Master requests
          (2)Send data to slave
          (3)Confirmation data from slave

*/
//RawSerial object_name(PinName tx, PinName rx)
RawSerial XBEE(p37, p31); //Master to slave communication

RawSerial pc(USBTX,USBRX); //UART monitor from pc
RawSerial wifi(p9, p10); // master to wifi UART

AnalogIn mPot(p15);

float mPot_val = 0.0;
float sPot_val = 0.0;

PwmOut pwm(p27);

bool master_manual = false;
bool slave_manual = false;
string received = ""; //from slave 
string sent = ""; //to slave

string feather_receive = ""; //data recieved from Feather
string feather_sent = ""; //data sent to the Feather

string mDimStr = "";
string mTempStr = "";
string sTempStr = "";
string sDimStr = "";

int convert_val = 0;
int sDimAmt = 0;
int mDimAmt = 0;
int sTemp = 0;
int mTemp = 0;
float dim_percent = 0.0;

int i = 0; //intialize
int j = 0;
char box;

void wifi_communication_action(void const *args)
{
    while(1){
        // Data frame[18]: G S | M A | 000 | 000 | S | A | 000 | 000 
        // 'GWDM' 0-100 Master Light Level, OR 'GWDS' 0-100 Slave Light Level
        char wifi_message [18] = {};
        string message = ""; // Empty Message String
        int i = 0; // Iterator
        
        while(wifi.readable()) { // Receive Webapp Data from Adafruit Feather
            wifi_message[i] = wifi.getc(); // Get each character WiFi Message.
            i = i+1; // Iterate
            osDelay(10); // Delay the OS 10ms WILL MOST LIKELY ADJUST TIMING FOR LAST 10% COMPLETION
        }
        
        //message = wifi_message; // Save the character array as a string. USELESS
        pc.printf(wifi_message); //Echo to terminal
        i = 0; // Reset the iterator
        // ------------------------------Data parsing --------------------------------------------------------
        
        if ( toupper(wifi_message [0]) == 'G' && toupper(wifi_message[2]) == 'M' && toupper(wifi_message[10]) == 'S')
        {
            int data [12] = {};
            for(int i = 0; i < 7; i++) // Parsing master and slave dim and temp values as int array
            {
                data[i] = (int)wifi_message[i+4]-48; // first 6 values are in char, subtracting 48 gives raw int
                data[i+6] = (int)wifi_message[i+12]-48; // second 6 values are for slave values
            }
            for(int i = 0; i < 3; i++) // Convert integer array to string
            {
                mDimStr += data[i];
                mTempStr += data[i+3];
                sDimStr += data[i+6];
                sTempStr += data[i+9];
            }
            
            if(data[0] > 1 || data[6] > 1) // Logic check for dim amount for both master and slave
                wifi.printf("Somehow... you are dimming over 100%...");
            else
            {
                mDimAmt = (data[0]*100)+(data[1]*10)+(data[2]); // Data 0:2 is the 3 digit percentile for master
                sDimAmt = (data[6]*100)+(data[7]*10)+(data[8]); // data 6:8 is the 3 digit percentile for slave
            }
                       
            if (toupper(wifi_message [1]) == 'S') //Print status
            {
                wifi.printf("Master Dim: %s\n", mDimStr); // Print to terminal, NOTICE: weird warning
                wifi.printf("Master Temp: %s\n", mTempStr);
                wifi.printf("Slave Dim: %s\n", sDimStr);
                wifi.printf("Slave Temp: %s\n", sTempStr);
            }
            
            else if (toupper(wifi_message [1]) == 'D') //Dim
            {
                // ----------------------------- Prioritize Wireless/Manual Mode -----------------------------------
        
                if ( mPot.read() > 0.0 || wifi_message[3] == '0') // If the pot is at any value or in physical mode
                {
                    master_manual = true;
                    mPot_val = mPot.read(); //read in value from potentiometer
                    pwm.write(mPot_val); //output potentiometer value to pwm
                }
                
                else if (wifi_message[3] == '1' ) //Check: Wireless for master
                {
                    pwm.write((float)(mDimAmt/100)); //Send out dim value from parsed data wirelessly    
                
                }
                  
                if ( sPot.read() > 0.0 || wifi_message[11] == '0')
                {  
                    slave_manual = true;
                    sPot_val = sPot.read();
                    pwm.write(sPot_val);
                }   
                else if (wifi_message [11] == '1' ) //Check: Wireless for slave
                {
                    pwm.write((float)(sDimAmt/100)); //Send out dim value from parsed data wirelessly    
                            
                }
            }
            
            /* IGNORE THIS
            int md1, md2, md3, mt1, mt2, mt3; // Master dim and temp values
            int sd1, sd2, sd3, st1, st2, st3; // Slave dim and temp values
            md1 = (int)wifi_message[4]-48;
            md2 = (int)wifi_message[5]-48;
            md3 = (int)wifi_message[6]-48;
            mt1 = (int)wifi_message[7]-48;
            mt2 = (int)wifi_message[8]-48;
            mt3 = (int)wifi_message[9]-48;
            sd1 = (int)wifi_message[12]-48;
            sd2 = (int)wifi_message[13]-48;
            sd3 = (int)wifi_message[14]-48;
            st1 = (int)wifi_message[15]-48;
            st2 = (int)wifi_message[16]-48;
            st3 = (int)wifi_message[17]-48;
            */
            
        }         
        
                   
        
        /*     
        if (wifi_message [2] == 'D') { // if Dimming check if slave
            if(wifi_message[3] == 'S') { // if slave print message
                pc.printf(wifi_message);
            } else if (wifi_message[3] == 'M') { // else if master, parse message
                int temp1, temp2, temp3; // temp values convert char to int
                temp1 = (int)wifi_message[4] - 48;//100's place || CHAR '0' IS 48 IN DEC
                temp2 = (int)wifi_message[5] - 48;//10's place  || CHAR '0' IS 48 IN DEC
                temp3 = (int)wifi_message[6] - 48;//1's place   || CHAR '0' IS 48 IN DEC
                M_Dim = (temp1*100)+(temp2*10)+(temp3); // create int value || ABILITY TO GO OVER 100%???
                Dim_amount = (float)M_Dim/100; // get dim percentage
                Master_signal.write(Dim_amount); // write dim level to PWM
                //pc.printf("%0.3f dimval",Dim_amount);
            }
        }
        */
    } //end superloop
}//end thread


// Send WiFi Status
void wifi_status_send(void const *args)
{
    // Send Dim level message from GSM (General Status Master)
    while(1){
    wifi.printf("GSM%03d000S000000",mDimAmt);
    // Delay the OS by 3 seconds
    osDelay(3000); // updating status every 3 seconds
    }
}

// Define OS Thread to handle Communication between the master and the slave.
osThreadDef(wifi_communication_action, osPriorityNormal, DEFAULT_STACK_SIZE);
// Define OS Thread for sending Status
osThreadDef(wifi_status_send, osPriorityNormal, DEFAULT_STACK_SIZE);

int main ()
{    
    //Receive message - Slave light receiving message from Master
    while (master_uart4.readable() != 0) //determines if there is a character to read
    {
        char buf; 
        buf = master_uart4.getc(); //reads a char from the serial port and places into temp mailbox
        received[i] = buf; //stores the read char
        i++; //traverse through array
        osStatus.wait(0.5); //Check this value ~ 0.5 ms
    
    } //Note: May have to reset counter to 0
    
     
        
}