#include "LM75B.h" //Temperature header file
#include "MMA7455.h" // Accelerometer header file
#include "mbed.h"
#include <cmath>

Serial myUart (USBTX, USBRX);
LM75B tempsensor(P0_27, P0_28, LM75B::ADDRESS_1);
MMA7455 sensor(P0_27, P0_28);

int main() // +/- 60 on X or Y = angle over 90 degrees
{
    int temp_reading;
    int x, y, z;
    myUart.baud(19200); // setting the baud rate
    while(!sensor.setMode(MMA7455::ModeMeasurement));
    while(!sensor.calibrate());
     
    while(1) 
    {
        temp_reading = (int)tempsensor.temp();
        temp_reading *= 1.8;
        temp_reading += 32;
        myUart.printf("Current board temperature (Fahrenheit): %d.1\r", temp_reading);
        
        sensor.read(x,y,z);
        if (abs(x) > 60 || abs(y) > 60 || abs(z) > 40) //val +/- 60 = 90 degrees in all directions
            myUart.putc(0x07);
        
        wait(0.5); //Wait in seconds
    }     
}
