/**
 * @file rcc_backup_registers.h
 * @author Jake Greaves
 * @date 12 Feb 2018
 * @brief Interface functions for writing to back-up registers
 */
 
#ifndef __RCC_BACKUP_REGISTERS_H_
#define __RCC_BACKUP_REGISTERS_H_


#include "stm32f4xx_hal.h"

/**
 * @brief Read a variable from the RCC registers
 *
 * Read back a variable from a given register and return it.
 *
 * @param BackupRegister The register to read.
 *
 * @return Returns the value of the register.
 */
uint32_t Rcc_ReadBackupReg( uint32_t BackupRegister );

/**
 * @brief Parse the device info command.
 *
 * This function handles the device info command, responding to the PC
 * with the device name, battery voltage and firmware version.
 *
 * @return Returns 0 on success, 1 on error.
 */
void Rcc_WriteBackupReg( uint32_t BackupRegister, uint32_t data );


#endif

