/*
CONFIDENTIAL AND PROPRIETARY INFORMATION

Copyright (c) 2018 Emutex Ltd. All rights reserved.
This software and documentation contain confidential and
proprietary information that is the property of
Emutex Ltd. The software and documentation are
furnished under a license agreement and may be used
or copied only in accordance with the terms of the license
agreement. No part of the software and documentation
may be reproduced, transmitted, or translated, in any
form or by any means, electronic, mechanical, manual,
optical, or otherwise, without prior written permission
of Emutex Ltd., or as expressly provided by the license agreement.
Reverse engineering is prohibited, and reproduction,
disclosure or use without specific written authorization
of Emutex Ltd. is strictly forbidden.
*/

#ifndef __ADI_SENSE_1000_HOST_COMMS_H__
#define __ADI_SENSE_1000_HOST_COMMS_H__

#include "adi_sense_types.h"

/*
 * The host is expected to transfer a 16-bit command, followed by data bytes, in 2
 * separate transfers delineated by the CS signal and a short delay in between.
 *
 * The 16-bit command contains a right-justified 11-bit register address (offset),
 * and the remaining upper 5 bits are reserved as command bits assigned as follows:
 * [15:11] 10000b = write command, 01000b = read command, anything else is invalid
 * [10:0]  register address (0-2047)
 */

/* Register address space is limited to 2048 bytes (11 bit address) */
#define ADI_SENSE_1000_HOST_COMMS_CMD_MASK 0xF800
#define ADI_SENSE_1000_HOST_COMMS_ADR_MASK 0x07FF

/*
 * The following commands are currently supported, anything else is treated
 * as an error
 */
#define ADI_SENSE_1000_HOST_COMMS_WRITE_CMD 0x8000
#define ADI_SENSE_1000_HOST_COMMS_READ_CMD  0x4000

/*
 * The following bytes are sent back to the host when a command is recieved,
 * to be used by the host to verify that we were ready to receive the command.
 */
#define ADI_SENSE_1000_HOST_COMMS_CMD_RESP_0 0xF0
#define ADI_SENSE_1000_HOST_COMMS_CMD_RESP_1 0xE1

/*
 * The following minimum delay, in microseconds, must be inserted after each SPI
 * transfer to allow time for it to be processed by the device
 */
#define ADI_SENSE_1000_HOST_COMMS_XFER_DELAY (30)

/*! ADSNS1000 Sensor Result bit field structure */
typedef struct _ADI_SENSE_1000_Sensor_Result_t {
    union {
        struct {
            float32_t Sensor_Result;      /**< Linearized and compensated sensor result */
            uint32_t Channel_ID    :  4;  /**< Indicates which channel this result corresponds to */
            uint32_t Ch_Error      :  1;  /**< Indicates Error on channel */
            uint32_t Ch_Alert      :  1;  /**< Indicates Alert on channel */
            uint32_t Ch_Raw        :  1;  /**< Indicates if Raw sensor data field is valid */
            uint32_t Ch_Valid      :  1;  /**< Indicates if this Result structure is valid */
            uint32_t Raw_Sample    : 24;  /**< Raw sensor data value */
        };
        uint64_t VALUE64;
   };
} ADI_SENSE_1000_Sensor_Result_t;

#endif /* __ADI_SENSE_1000_HOST_COMMS_H__ */
