/*
 ******************************************************************************
 * file:   bootloader.c
 *-----------------------------------------------------------------------------
 */

#include "bootloader.h"
#include "rcc_backup_registers.h"


void (*SysMemBootJump)(void);

 
// Jump through software to the system bootloader
// This should only be called after a reset to ensure correct operation
void Bootloader_Init( void ) {
	
	// Base bootloader address, found within software manual
	volatile uint32_t bootLoaderAddr = 0x1FFF0000;
	
	// Clear backup register flag
	Rcc_WriteBackupReg(BOOTLOADER_FLAG_BACKUP_REG, 0);
	
	// Disable RCC clock
	HAL_RCC_DeInit();

	//disable systick timer and interrupts
	SysTick -> CTRL = 0;
	SysTick -> LOAD = 0;
	SysTick -> VAL = 0;
	
	//disable all configurable interrupts
	__disable_irq();
	
	//remap sys mem to 0x0000 0000 in address space. Different for each device
	__HAL_SYSCFG_REMAPMEMORY_SYSTEMFLASH();
	
	//map jump function
	SysMemBootJump =  (void (*)(void)) (*((uint32_t *)(bootLoaderAddr + 0x04)));
	
	//set main stack pointer
	__set_MSP(*(uint32_t *)bootLoaderAddr);
	
	//jump
	SysMemBootJump();
}
