/*
 * File: sample_lut_data.c
 * The following example illustrates how individual tables can be declared, and
 * later assembled into a complete LUT data structure using adi_sense_1000_AssembleLutData().
 * That LUT data structure can then be written to the ADI Sense 1000 device 
 * using adi_sense_1000_SetLutData().
 */

#include "adi_sense_1000_lut_data.h"
#include "adi_sense_1000_sensor_types.h"

/*
 * The following table provide linearisation data for a 4-wire bridge sensor
 * identified with the ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2
 * sensor type.  The Look-Up Table provided maps a range of input (X)
 * values to a corresponding range of output (Y) values.  In this example,
 * the bridge sensor input in millivolts is effectively translated to volts.
 */

ADI_SENSE_1000_LUT_DESCRIPTOR loadcell_1 = 
{
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_3_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};

ADI_SENSE_1000_LUT_1D_NES loadcell_1_data = 
{
    .nElements = 10,
    .lut = 
    {
        -3300.0f, /* x(min) || mV */
        -0.7556152f,
        -0.626709f,
        -0.5058594f,
        -0.3776855f,
        -0.1120605f,
        0.5334473f,
        1.1896973f,
        13.340413f,
        +3300.0f, /* x(max) || mV */
        -0.001f,    /* y(min) || kg */
        0.0f,
        0.1f,
        0.2f,
        0.3f,
        0.5f,
        1.0f,
        1.5f,
        10.0f,
        +100.0f,    /* y(max) || kg */
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR loadcell_2 = 
{
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};

ADI_SENSE_1000_LUT_1D_NES loadcell_2_data = 
{
    .nElements = 10,
    .lut = 
    {
        -3300.0f, /* x(min) || mV */
        0.2766113f,   
        0.4162598f,
        0.5400391f,
        0.6694336f,
        0.9326172f,
        1.5837402f,
        2.2387695f,
        12.25284823f,
        +3300.0f, /* x(max) || mV */
        -0.001f,    /* y(min) || kg */
        0.0f,
        0.1f,
        0.2f,
        0.3f,
        0.5f,
        1.0f,
        1.5f,
        10.0f,
        +100.0f,    /* y(max) || kg */
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR loadcell_3 = 
{
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};

ADI_SENSE_1000_LUT_1D_NES loadcell_3_data = 
{
    .nElements = 10,
    .lut = 
    {
        -3300.0f, /* x(min) || mV */
        0.2521973f,
        0.3740234f,
        0.5178223f,
        0.6574707f,
        0.9311523f,
        1.6118164f,
        2.3029785f,
        13.96175153f,
        +3300.0f, /* x(max) || mV */
        -0.001f,    /* y(min) || kg */
        0.0f,
        0.1f,
        0.2f,
        0.3f,
        0.5f,
        1.0f,
        1.5f,
        10.0f,
        +100.0f,    /* y(max) || kg */
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR loadcell_4 = 
{
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_4_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};

ADI_SENSE_1000_LUT_1D_NES loadcell_4_data = 
{
    .nElements = 10,
    .lut = 
    {
        -3300.0f, /* x(min) || mV */
        0.4609375f,
        0.5895996f,
        0.7226562f,
        0.857666f,
        1.1184082f,
        1.7749023f,
        2.432373f,
        13.60091103f,
        +3300.0f, /* x(max) || mV */
        -0.001f,    /* y(min) || kg */
        0.0f,
        0.1f,
        0.2f,
        0.3f,
        0.5f,
        1.0f,
        1.5f,
        10.0f,
        +100.0f,    /* y(max) || kg */
    },
};


/*
 * The following variables can be passed as parameters to
 * adi_sense_1000_AssembleLutData()
 */
ADI_SENSE_1000_LUT_DESCRIPTOR *sample_lut_desc_list[] = 
{
    &loadcell_1,
    &loadcell_2,
    &loadcell_3,
    &loadcell_4,
    
};

ADI_SENSE_1000_LUT_TABLE_DATA *sample_lut_data_list[] = 
{
    
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &loadcell_1_data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &loadcell_2_data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &loadcell_3_data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &loadcell_4_data,
    
};

unsigned sample_lut_num_tables =
    (sizeof(sample_lut_desc_list) / sizeof(sample_lut_desc_list[0]));

