/*
 * led.c - control functions for led indicator
 *
 * Author: Jake Greaves
 */
 
#include "led.h"

extern DigitalOut status_led;

Ticker led_ticker;

void Led_Blink( void ) {
	
    Led_On(!status_led);       
}

void Led_Boot( void ) {
	
	// Attach interrupt to blink led
	led_ticker.attach(Led_Blink, LED_BLINK_PERIOD);
}

void Led_Idle( void ) {
	
	// Set led to constantly on
	led_ticker.detach();
	Led_On(true);
}

void Led_On( bool_t state ) {
	
	// Set led state
	status_led = state;
}

