/* ================================================================================

     Project      :   ADISENSE1000_REGISTERS
     File         :   ADISENSE1000_REGISTERS_typedefs.h
     Description  :   C Register Structures

     Date         :   May 9, 2018

     Copyright (c) 2018 Analog Devices, Inc.  All Rights Reserved.
     This software is proprietary and confidential to Analog Devices, Inc. and
     its licensors.

     This file was auto-generated. Do not make local changes to this file.

   ================================================================================ */

#ifndef _ADISENSE1000_REGISTERS_TYPEDEFS_H
#define _ADISENSE1000_REGISTERS_TYPEDEFS_H

/* pickup integer types */
#if defined(_LANGUAGE_C) || (defined(__GNUC__) && !defined(__ASSEMBLER__))
#include <stdint.h>
#endif /* _LANGUAGE_C */

#if defined ( __CC_ARM   )
#pragma push
#pragma anon_unions
#endif

/** @defgroup Interface_Config_A Interface Configuration A (Interface_Config_A) Register
 *  Interface Configuration A (Interface_Config_A) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_Interface_Config_A_Addr_Ascension
 *! \brief  Determines Sequential Addressing Behavior (Addr_Ascension) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_INTERFACE_CONFIG_A_DESCEND = 0,  /**< Address accessed is decremented by one for each data byte when streaming */
  ADISENSE_SPI_INTERFACE_CONFIG_A_ASCEND  = 1   /**< Address accessed is incremented by one for each data byte when streaming */
} ADI_ADISENSE_SPI_Interface_Config_A_Addr_Ascension;


/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Interface_Config_A_Struct
 *! \brief  Interface Configuration A Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Interface_Config_A_t {
  union {
    struct {
      uint8_t SW_ResetX  :  1;  /**< Second  of Two of SW_RESET Bits. */
      uint8_t reserved1  :  3;
      uint8_t SDO_Enable :  1;  /**< SDO Pin Enable */
      uint8_t Addr_Ascension :  1;  /**< Determines Sequential Addressing Behavior */
      uint8_t reserved6      :  1;
      uint8_t SW_Reset       :  1;  /**< First of Two of SW_RESET Bits. */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Interface_Config_A_t;

/*@}*/

/** @defgroup Interface_Config_B Interface Configuration B (Interface_Config_B) Register
 *  Interface Configuration B (Interface_Config_B) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_Interface_Config_B_Single_Inst
 *! \brief  Select Streaming or Single Instruction Mode (Single_Inst) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_INTERFACE_CONFIG_B_STREAMING_MODE          = 0,  /**< Streaming mode is enabled          */
  ADISENSE_SPI_INTERFACE_CONFIG_B_SINGLE_INSTRUCTION_MODE = 1   /**< Single Instruction mode is enabled */
} ADI_ADISENSE_SPI_Interface_Config_B_Single_Inst;


/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Interface_Config_B_Struct
 *! \brief  Interface Configuration B Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Interface_Config_B_t {
  union {
    struct {
      uint8_t reserved0   :  7;
      uint8_t Single_Inst :  1;  /**< Select Streaming or Single Instruction Mode */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Interface_Config_B_t;

/*@}*/

/** @defgroup Device_Config Device Configuration (Device_Config) Register
 *  Device Configuration (Device_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_Device_Config_Operating_Modes
 *! \brief  Power Modes (Operating_Modes) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_DEVICE_CONFIG_NORMAL = 0,  /**< Normal Operating Mode */
  ADISENSE_SPI_DEVICE_CONFIG_SLEEP  = 3   /**< Low Power Mode        */
} ADI_ADISENSE_SPI_Device_Config_Operating_Modes;


/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Device_Config_Struct
 *! \brief  Device Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Device_Config_t {
  union {
    struct {
      uint8_t Operating_Modes :  2;  /**< Power Modes */
      uint8_t reserved2       :  6;
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Device_Config_t;

/*@}*/

/** @defgroup Chip_Type Chip Type (Chip_Type) Register
 *  Chip Type (Chip_Type) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Chip_Type_Struct
 *! \brief  Chip Type Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Chip_Type_t {
  union {
    struct {
      uint8_t Chip_Type  :  4;  /**< Precision ADC */
      uint8_t reserved4  :  4;
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Chip_Type_t;

/*@}*/

/** @defgroup Product_ID_L Product ID Low (Product_ID_L) Register
 *  Product ID Low (Product_ID_L) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Product_ID_L_Struct
 *! \brief  Product ID Low Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Product_ID_L_t {
  union {
    struct {
      uint8_t Product_ID :  8;  /**< Product_ID[7:0] This is Device Chip Type/Family */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Product_ID_L_t;

/*@}*/

/** @defgroup Product_ID_H Product ID High (Product_ID_H) Register
 *  Product ID High (Product_ID_H) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Product_ID_H_Struct
 *! \brief  Product ID High Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Product_ID_H_t {
  union {
    struct {
      uint8_t Product_ID :  8;  /**< Product_ID[15:8] This is Device Chip Type/Family */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Product_ID_H_t;

/*@}*/

/** @defgroup Chip_Grade Chip Grade (Chip_Grade) Register
 *  Chip Grade (Chip_Grade) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Chip_Grade_Struct
 *! \brief  Chip Grade Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Chip_Grade_t {
  union {
    struct {
      uint8_t Device_Revision :  4;  /**< This is the Device Hardware Revision */
      uint8_t Grade           :  4;  /**< This is the Device Performance Grade */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Chip_Grade_t;

/*@}*/

/** @defgroup Scratch_Pad Scratch Pad (Scratch_Pad) Register
 *  Scratch Pad (Scratch_Pad) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Scratch_Pad_Struct
 *! \brief  Scratch Pad Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Scratch_Pad_t {
  union {
    struct {
      uint8_t Scratch_Value :  8;  /**< Software Scratchpad */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Scratch_Pad_t;

/*@}*/

/** @defgroup SPI_Revision SPI Revision (SPI_Revision) Register
 *  SPI Revision (SPI_Revision) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_SPI_Revision_Version
 *! \brief  SPI Version (Version) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_SPI_REVISION_REV1_0 = 2   /**< Revision 1.0 */
} ADI_ADISENSE_SPI_SPI_Revision_Version;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_SPI_Revision_SPI_Type
 *! \brief  Always Reads as 0x2 (SPI_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_SPI_REVISION_ADI_SPI = 0,  /**<  */
  ADISENSE_SPI_SPI_REVISION_LPT_SPI = 2   /**<  */
} ADI_ADISENSE_SPI_SPI_Revision_SPI_Type;


/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_SPI_Revision_Struct
 *! \brief  SPI Revision Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_SPI_Revision_t {
  union {
    struct {
      uint8_t Version    :  6;  /**< SPI Version */
      uint8_t SPI_Type   :  2;  /**< Always Reads as 0x2 */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_SPI_Revision_t;

/*@}*/

/** @defgroup Vendor_L Vendor ID Low (Vendor_L) Register
 *  Vendor ID Low (Vendor_L) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Vendor_L_Struct
 *! \brief  Vendor ID Low Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Vendor_L_t {
  union {
    struct {
      uint8_t VID        :  8;  /**< VID[7:0] Analog Devices Vendor ID */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Vendor_L_t;

/*@}*/

/** @defgroup Vendor_H Vendor ID High (Vendor_H) Register
 *  Vendor ID High (Vendor_H) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Vendor_H_Struct
 *! \brief  Vendor ID High Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Vendor_H_t {
  union {
    struct {
      uint8_t VID        :  8;  /**< VID[15:8] Analog Devices Vendor ID */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Vendor_H_t;

/*@}*/

/** @defgroup Stream_Mode Stream Mode (Stream_Mode) Register
 *  Stream Mode (Stream_Mode) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Stream_Mode_Struct
 *! \brief  Stream Mode Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Stream_Mode_t {
  union {
    struct {
      uint8_t Loop_Count :  8;  /**< Sets the Data Byte Count Before Looping to Start Address */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Stream_Mode_t;

/*@}*/

/** @defgroup Transfer_Config Transfer Config (Transfer_Config) Register
 *  Transfer Config (Transfer_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_Transfer_Config_Stream_Mode
 *! \brief  When Streaming, Controls Master-Slave Transfer (Stream_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_TRANSFER_CONFIG_UPDATE_ON_WRITE        = 0,  /**< Transfers after each byte/mulit-byte register */
  ADISENSE_SPI_TRANSFER_CONFIG_UPDATE_ON_ADDRESS_LOOP = 1   /**< Transfers when address loops                  */
} ADI_ADISENSE_SPI_Transfer_Config_Stream_Mode;


/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Transfer_Config_Struct
 *! \brief  Transfer Config Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Transfer_Config_t {
  union {
    struct {
      uint8_t reserved0   :  1;
      uint8_t Stream_Mode :  1;  /**< When Streaming, Controls Master-Slave Transfer */
      uint8_t reserved2   :  6;
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Transfer_Config_t;

/*@}*/

/** @defgroup Interface_Config_C Interface Configuration C (Interface_Config_C) Register
 *  Interface Configuration C (Interface_Config_C) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_Interface_Config_C_Strict_Register_Access
 *! \brief  Multi-byte Registers Must Be Read/Written in Full (Strict_Register_Access) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_INTERFACE_CONFIG_C_NORMAL_ACCESS = 0,  /**< Normal mode, no access restrictions                              */
  ADISENSE_SPI_INTERFACE_CONFIG_C_STRICT_ACCESS = 1   /**< Strict mode, multi-byte registers require all bytes read/written */
} ADI_ADISENSE_SPI_Interface_Config_C_Strict_Register_Access;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_SPI_Interface_Config_C_CRC_Enable
 *! \brief  CRC Enable (CRC_Enable) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_SPI_INTERFACE_CONFIG_C_DISABLED = 0,  /**< CRC Disabled */
  ADISENSE_SPI_INTERFACE_CONFIG_C_ENABLED  = 1   /**< CRC Enabled  */
} ADI_ADISENSE_SPI_Interface_Config_C_CRC_Enable;


/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Interface_Config_C_Struct
 *! \brief  Interface Configuration C Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Interface_Config_C_t {
  union {
    struct {
      uint8_t CRC_EnableB :  2;  /**< Inverted CRC Enable */
      uint8_t reserved2   :  2;
      uint8_t Send_Status :  1;  /**< Enables Sending of Status in 4-wire Mode */
      uint8_t Strict_Register_Access :  1;  /**< Multi-byte Registers Must Be Read/Written in Full */
      uint8_t CRC_Enable             :  2;  /**< CRC Enable */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Interface_Config_C_t;

/*@}*/

/** @defgroup Interface_Status_A Interface Status A (Interface_Status_A) Register
 *  Interface Status A (Interface_Status_A) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_SPI_Interface_Status_A_Struct
 *! \brief  Interface Status A Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_SPI_Interface_Status_A_t {
  union {
    struct {
      uint8_t Address_Invalid_Error :  1;  /**< Attempt to Read/Write Non-existent Register Address */
      uint8_t Register_Partial_Access_Error :  1;  /**< Set When Fewer Than Expected Number of Bytes Read/Written */
      uint8_t Wr_To_Rd_Only_Reg_Error       :  1;  /**< Write to Read-Only Register Attempted */
      uint8_t CRC_Error                     :  1;  /**< Invalid/No CRC Received */
      uint8_t Clock_Count_Error             :  1;  /**< Incorrect Number of Clocks Detected in a Transaction */
      uint8_t reserved5                     :  2;
      uint8_t Not_Ready_Error               :  1;  /**< Device Not Ready for Transaction */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_SPI_Interface_Status_A_t;

/*@}*/

/** @defgroup Command Special Command (Command) Register
 *  Special Command (Command) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Command_Special_Command
 *! \brief  Special Command (Special_Command) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_COMMAND_NOP                  = 0,   /**< No Command                                                        */
  ADISENSE_CORE_COMMAND_CONVERT              = 1,   /**< Start ADC Conversions                                             */
  ADISENSE_CORE_COMMAND_CONVERT_WITH_RAW     = 2,   /**< Start Conversions with Added RAW ADC Data                         */
  ADISENSE_CORE_COMMAND_RUN_DIAGNOSTICS      = 3,   /**< Initiate a Diagnostics Cycle                                      */
  ADISENSE_CORE_COMMAND_SELF_CALIBRATION     = 4,   /**< Initiate a Self-Calibration Cycle                                 */
  ADISENSE_CORE_COMMAND_LATCH_CONFIG         = 7,   /**< Latch Configuration.                                              */
  ADISENSE_CORE_COMMAND_LOAD_LUT             = 8,   /**< Load LUT from FLASH                                               */
  ADISENSE_CORE_COMMAND_SAVE_LUT             = 9,   /**< Save LUT to FLASH                                                 */
  ADISENSE_CORE_COMMAND_SYSTEM_CHECK         = 10,  /**< Full Suite of Measurement Diagnostics                             */
  ADISENSE_CORE_COMMAND_CONVERT_FFT          = 11,  /**< Perform FFTs on Selected Channel(s)                               */
  ADISENSE_CORE_COMMAND_ERASE_EXTERNAL_FLASH = 16,  /**< Erase Contents of External Flash                                  */
  ADISENSE_CORE_COMMAND_POWER_DOWN           = 20,  /**< Enter Low Power State                                             */
  ADISENSE_CORE_COMMAND_LOAD_CONFIG_1        = 24,  /**< Load Registers with Configuration#1 from FLASH                    */
  ADISENSE_CORE_COMMAND_SAVE_CONFIG_1        = 25,  /**< Store Current Registers to FLASH Configuration#1                  */
  ADISENSE_CORE_COMMAND_LOAD_CONFIG_2        = 26,  /**< Load Registers with Configuration#2 from FLASH                    */
  ADISENSE_CORE_COMMAND_SAVE_CONFIG_2        = 27,  /**< Store Current Registers to FLASH Configuration#2                  */
  ADISENSE_CORE_COMMAND_LOAD_CONFIG_3        = 28,  /**< Load Registers with Configuration#3 from FLASH                    */
  ADISENSE_CORE_COMMAND_SAVE_CONFIG_3        = 29,  /**< Store Current Registers to FLASH Configuration#3                  */
  ADISENSE_CORE_COMMAND_LOAD_CONFIG_4        = 30,  /**< Load Registers with Configuration#4 from FLASH                    */
  ADISENSE_CORE_COMMAND_SAVE_CONFIG_4        = 31,  /**< Store Current Registers to FLASH Configuration#4                  */
  ADISENSE_CORE_COMMAND_CALIBRATE_DIGITAL    = 32   /**< Performs a Calibration of Digital Sensor, if Supported & Enabled. */
} ADI_ADISENSE_CORE_Command_Special_Command;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Command_Struct
 *! \brief  Special Command Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Command_t {
  union {
    struct {
      uint8_t Special_Command :  8;  /**< Special Command */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Command_t;

/*@}*/

/** @defgroup Mode Operating Mode and DRDY Control (Mode) Register
 *  Operating Mode and DRDY Control (Mode) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Mode_Conversion_Mode
 *! \brief  Conversion Mode (Conversion_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_MODE_SINGLECYCLE = 0,  /**< Single Cycle          */
  ADISENSE_CORE_MODE_MULTICYCLE  = 1,  /**< Multi Cycle           */
  ADISENSE_CORE_MODE_CONTINUOUS  = 2   /**< Continuous Conversion */
} ADI_ADISENSE_CORE_Mode_Conversion_Mode;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Mode_Drdy_Mode
 *! \brief  Indicates Behavior of DRDY with Respect to FIFO State (Drdy_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_MODE_DRDY_PER_CONVERSION = 0,  /**< Data Ready Per Conversion                    */
  ADISENSE_CORE_MODE_DRDY_PER_CYCLE      = 1,  /**< Data Ready Per Cycle                         */
  ADISENSE_CORE_MODE_DRDY_PER_FIFO_FILL  = 2   /**< Data Ready Per FIFO Fill / Multi-Cycle Burst */
} ADI_ADISENSE_CORE_Mode_Drdy_Mode;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Mode_Calibration_Method
 *! \brief  Indicates If Calibration is Required on 'Latch' Command (Calibration_Method) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_MODE_NO_CAL = 0,  /**< No Calibration Performed */
  ADISENSE_CORE_MODE_DO_CAL = 1   /**< Calibration Performed    */
} ADI_ADISENSE_CORE_Mode_Calibration_Method;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Mode_FFT_Mode
 *! \brief  Indicates Single or Multiple Sequence of FFTs (FFT_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_MODE_FFT_MODE_SINGLE     = 0,  /**< Perform Single Sequence of FFT(s) on Selected Channel(s)   */
  ADISENSE_CORE_MODE_FFT_MODE_CONTINUOUS = 1   /**< Perform Continuous Sequence of FFTs on Selected Channel(s) */
} ADI_ADISENSE_CORE_Mode_FFT_Mode;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Mode_Ext_Flash_Store
 *! \brief  Indicates If Measurement Data Should Be Stored in Flash (Ext_Flash_Store) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_MODE_EXT_FLASH_NOT_USED = 0,  /**< Do Not Use External Flash */
  ADISENSE_CORE_MODE_EXT_FLASH_USED     = 1   /**< Use External Flash        */
} ADI_ADISENSE_CORE_Mode_Ext_Flash_Store;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Mode_Struct
 *! \brief  Operating Mode and DRDY Control Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Mode_t {
  union {
    struct {
      uint8_t Conversion_Mode :  2;  /**< Conversion Mode */
      uint8_t Drdy_Mode       :  2;  /**< Indicates Behavior of DRDY with Respect to FIFO State */
      uint8_t Calibration_Method :  1;  /**< Indicates If Calibration is Required on 'Latch' Command */
      uint8_t FFT_Mode           :  1;  /**< Indicates Single or Multiple Sequence of FFTs */
      uint8_t reserved6          :  1;
      uint8_t Ext_Flash_Store    :  1;  /**< Indicates If Measurement Data Should Be Stored in Flash */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Mode_t;

/*@}*/

/** @defgroup Power_Config General Configuration (Power_Config) Register
 *  General Configuration (Power_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Power_Config_Power_Mode_ADC
 *! \brief  ADC Power Mode (Power_Mode_ADC) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_POWER_CONFIG_ADC_LOW_POWER  = 0,  /**< ADC Low Power Mode  */
  ADISENSE_CORE_POWER_CONFIG_ADC_MID_POWER  = 1,  /**< ADC Mid Power Mode  */
  ADISENSE_CORE_POWER_CONFIG_ADC_FULL_POWER = 2   /**< ADC Full Power Mode */
} ADI_ADISENSE_CORE_Power_Config_Power_Mode_ADC;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Power_Config_Struct
 *! \brief  General Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Power_Config_t {
  union {
    struct {
      uint8_t Power_Mode_ADC :  2;  /**< ADC Power Mode */
      uint8_t reserved2      :  6;
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Power_Config_t;

/*@}*/

/** @defgroup Cycle_Control Measurement Cycle (Cycle_Control) Register
 *  Measurement Cycle (Cycle_Control) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Cycle_Control_Cycle_Type
 *! \brief  Type of Measurement Cycle (Cycle_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_CYCLE_CONTROL_CYCLE_TYPE_SWITCH = 0,  /**< Switch Channels After Every Conversion                        */
  ADISENSE_CORE_CYCLE_CONTROL_CYCLE_TYPE_FULL   = 1   /**< Perform Full Number Of Conversions On A Channel Consecutively */
} ADI_ADISENSE_CORE_Cycle_Control_Cycle_Type;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Cycle_Control_Cycle_Time_Units
 *! \brief  Units for Cycle Time (Cycle_Time_Units) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_CYCLE_CONTROL_MICROSECONDS = 0,  /**< Micro-Seconds */
  ADISENSE_CORE_CYCLE_CONTROL_MILLISECONDS = 1,  /**< Milli-Seconds */
  ADISENSE_CORE_CYCLE_CONTROL_SECONDS      = 2   /**< Seconds       */
} ADI_ADISENSE_CORE_Cycle_Control_Cycle_Time_Units;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Cycle_Control_Struct
 *! \brief  Measurement Cycle Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Cycle_Control_t {
  union {
    struct {
      uint16_t Cycle_Time : 12;  /**< Duration of a Full Measurement Cycle */
      uint16_t Cycle_Type :  1;  /**< Type of Measurement Cycle */
      uint16_t reserved13       :  1;
      uint16_t Cycle_Time_Units :  2;  /**< Units for Cycle Time */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Cycle_Control_t;

/*@}*/

/** @defgroup Fifo_Num_Cycles Number of Measurement Cycles to Store in FIFO (Fifo_Num_Cycles) Register
 *  Number of Measurement Cycles to Store in FIFO (Fifo_Num_Cycles) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Fifo_Num_Cycles_Struct
 *! \brief  Number of Measurement Cycles to Store in FIFO Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Fifo_Num_Cycles_t {
  union {
    struct {
      uint8_t Fifo_Num_Cycles :  8;  /**< How Many Cycles to Fill FIFO */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Fifo_Num_Cycles_t;

/*@}*/

/** @defgroup Multi_Cycle_Repeat_Interval Time Between Repeats of Multi-Cycle Conversions.... (Multi_Cycle_Repeat_Interval) Register
 *  Time Between Repeats of Multi-Cycle Conversions.... (Multi_Cycle_Repeat_Interval) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Multi_Cycle_Repeat_Interval_Struct
 *! \brief  Time Between Repeats of Multi-Cycle Conversions.... Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Multi_Cycle_Repeat_Interval_t {
  union {
    struct {
      uint32_t Multi_Cycle_Repeat_Interval : 24;  /**< Defines Time Between Repetitions of Measurement Cycles. */
      uint32_t reserved24                  :  8;
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Multi_Cycle_Repeat_Interval_t;

/*@}*/

/** @defgroup Status General Status (Status) Register
 *  General Status (Status) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Status_Struct
 *! \brief  General Status Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Status_t {
  union {
    struct {
      uint8_t reserved0    :  1;
      uint8_t Alert_Active :  1;  /**< Indicates One or More Sensors Alerts are Active */
      uint8_t Error        :  1;  /**< Indicates an Error */
      uint8_t Drdy         :  1;  /**< Indicates a New Sensor Result is Available to Be Read */
      uint8_t Cmd_Running  :  1;  /**< Indicates a Special Command is Active */
      uint8_t FIFO_Error   :  1;  /**< Indicates Error with FIFO */
      uint8_t reserved6    :  2;
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Status_t;

/*@}*/

/** @defgroup Diagnostics_Status Diagnostics Status (Diagnostics_Status) Register
 *  Diagnostics Status (Diagnostics_Status) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Diagnostics_Status_Struct
 *! \brief  Diagnostics Status Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Diagnostics_Status_t {
  union {
    struct {
      uint16_t Diag_Checksum_Error :  1;  /**< Indicates Error on Internal Checksum Calculations */
      uint16_t Diag_Comms_Error    :  1;  /**< Indicates Error on Internal Device Communications */
      uint16_t Diag_Supply_Monitor_Error :  1;  /**< Indicates Low Voltage on Internal Supply Voltages */
      uint16_t Diag_Supply_Cap_Error     :  1;  /**< Indicates Fault on Internal Supply Regulator Capacitor */
      uint16_t reserved4                 :  8;
      uint16_t Diag_Conversion_Error     :  1;  /**< Indicates Error During Internal ADC Conversions */
      uint16_t Diag_Calibration_Error    :  1;  /**< Indicates Error During Internal Device Calibrations */
      uint16_t reserved14                :  2;
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Diagnostics_Status_t;

/*@}*/

/** @defgroup Channel_Alert_Status Alert Status Summary (Channel_Alert_Status) Register
 *  Alert Status Summary (Channel_Alert_Status) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Channel_Alert_Status_Struct
 *! \brief  Alert Status Summary Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Channel_Alert_Status_t {
  union {
    struct {
      uint16_t Alert_Ch0  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch1  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch2  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch3  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch4  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch5  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch6  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch7  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch8  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch9  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch10 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch11 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch12 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch13 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch14 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch15 :  1;  /**< Indicates Channel Alert is Active */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Channel_Alert_Status_t;

/*@}*/

/** @defgroup Alert_Status_2 Additional Alert Status Information (Alert_Status_2) Register
 *  Additional Alert Status Information (Alert_Status_2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Alert_Status_2_Struct
 *! \brief  Additional Alert Status Information Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Alert_Status_2_t {
  union {
    struct {
      uint16_t reserved0  :  1;
      uint16_t LUT_Error  :  1;  /**< Indicates Error with One or More Look-Up-Tables */
      uint16_t Configuration_Error :  1;  /**< Indicates Error with Programmed Configuration */
      uint16_t Temperature_Alert_Hi :  1;  /**< Indicates Device Temperature High Alert */
      uint16_t Temperature_Alert_Lo :  1;  /**< Indicates Device Temperature Low Alert */
      uint16_t Temperature_Alarm_Hi :  1;  /**< Indicates Device Temperature High Alarm */
      uint16_t Temperature_Alarm_Lo :  1;  /**< Indicates Device Temperature Low Alarm */
      uint16_t Ext_Flash_Error      :  1;  /**< Indicates Error with External Flash Memory */
      uint16_t reserved8            :  8;
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Alert_Status_2_t;

/*@}*/

/** @defgroup Alert_Detail_Ch Detailed Error Information (Alert_Detail_Ch) Register
 *  Detailed Error Information (Alert_Detail_Ch) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Alert_Detail_Ch_Struct
 *! \brief  Detailed Error Information Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Alert_Detail_Ch_t {
  union {
    struct {
      uint16_t Time_Out   :  1;  /**< Indicates Time-Out Error from Digital Sensor */
      uint16_t Under_Range :  1;  /**< Indicates Channel Under-Range */
      uint16_t Over_Range  :  1;  /**< Indicates Channel Over-Range */
      uint16_t Low_Limit   :  1;  /**< Indicates Sensor Result is Less Than Low Limit */
      uint16_t High_Limit  :  1;  /**< Indicates Sensor Result is Greater Than High Limit */
      uint16_t Sensor_Open :  1;  /**< Indicates Sensor Input is Open Circuit */
      uint16_t Ref_Detect  :  1;  /**< Indicates Whether ADC Reference is Valid */
      uint16_t Calibration_Invalid :  1;  /**< Indicates Problem During Calibration of Channel */
      uint16_t Config_Err          :  1;  /**< Indicates Configuration Error on Channel */
      uint16_t LUT_Error_Ch        :  1;  /**< Indicates Error with Channel Look-Up-Table */
      uint16_t Under_Voltage       :  1;  /**< Indicates Channel Under-Voltage */
      uint16_t Over_Voltage        :  1;  /**< Indicates Channel Over-Voltage */
      uint16_t Correction_UnderRange :  1;  /**< Indicates Result Less Than LUT/Equation Range */
      uint16_t Correction_OverRange  :  1;  /**< Indicates Result Larger Than LUT/Equation Range */
      uint16_t Sensor_Not_Ready      :  1;  /**< Indicates Digital Sensor Not Ready When Read */
      uint16_t Comp_Not_Ready        :  1;  /**< Indicates Compensation Channel Not Ready When Required */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Alert_Detail_Ch_t;

/*@}*/

/** @defgroup Error_Code Code Indicating Source of Error (Error_Code) Register
 *  Code Indicating Source of Error (Error_Code) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Error_Code_Struct
 *! \brief  Code Indicating Source of Error Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Error_Code_t {
  union {
    struct {
      uint16_t Error_Code : 16;  /**< Code Indicating Type of Error */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Error_Code_t;

/*@}*/

/** @defgroup Alert_Code Code Indicating Source of Alert (Alert_Code) Register
 *  Code Indicating Source of Alert (Alert_Code) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Alert_Code_Struct
 *! \brief  Code Indicating Source of Alert Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Alert_Code_t {
  union {
    struct {
      uint16_t Alert_Code : 16;  /**< Code Indicating Type of Alert */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Alert_Code_t;

/*@}*/

/** @defgroup External_Reference1 External Reference Information (External_Reference1) Register
 *  External Reference Information (External_Reference1) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_External_Reference1_Struct
 *! \brief  External Reference Information Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_External_Reference1_t {
  union {
    struct {
      float Ext_Refin1_Value;  /**< Refin1 Value */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_External_Reference1_t;

/*@}*/

/** @defgroup External_Reference2 External Reference Information (External_Reference2) Register
 *  External Reference Information (External_Reference2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_External_Reference2_Struct
 *! \brief  External Reference Information Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_External_Reference2_t {
  union {
    struct {
      float Ext_Refin2_Value;  /**< Refin2 Value */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_External_Reference2_t;

/*@}*/

/** @defgroup Diagnostics_Control Diagnostic Control (Diagnostics_Control) Register
 *  Diagnostic Control (Diagnostics_Control) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Diagnostics_Control_Diag_OSD_Freq
 *! \brief  Diagnostics Open Sensor Detect Frequency (Diag_OSD_Freq) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_OFF             = 0,  /**< No Open-Circuit Detection During Measurement                          */
  ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1_CYCLE     = 1,  /**< Open-Circuit Detection Performed Once Per Measurement Cycle           */
  ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_PER_100_CYCLES  = 2,  /**< Open-Circuit Detection Performed Once Per Hundred Measurement Cycles  */
  ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1000_CYCLES = 3   /**< Open-Circuit Detection Performed Once Per Thousand Measurement Cycles */
} ADI_ADISENSE_CORE_Diagnostics_Control_Diag_OSD_Freq;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Diagnostics_Control_Struct
 *! \brief  Diagnostic Control Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Diagnostics_Control_t {
  union {
    struct {
      uint16_t Diag_Global_En :  1;  /**< Diagnostics Global Enable */
      uint16_t Diag_Meas_En   :  1;  /**< Diagnostics Measure Enable */
      uint16_t Diag_OSD_Freq  :  2;  /**< Diagnostics Open Sensor Detect Frequency */
      uint16_t reserved4      : 12;
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Diagnostics_Control_t;

/*@}*/

/** @defgroup Data_FIFO FIFO Buffer of Sensor Results (Data_FIFO) Register
 *  FIFO Buffer of Sensor Results (Data_FIFO) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Data_FIFO_Struct
 *! \brief  FIFO Buffer of Sensor Results Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Data_FIFO_t {
  union {
    struct {
      uint8_t Data_Fifo  :  8;  /**< Fifo Buffer of Sensor Results */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Data_FIFO_t;

/*@}*/

/** @defgroup FFT_Config FFT Configuration (FFT_Config) Register
 *  FFT Configuration (FFT_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_FFT_Config_FFT_Num_Bins
 *! \brief  Indicates Number of Bins in FFT (FFT_Num_Bins) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_FFT_CONFIG_FFT_BINS_256  = 0,  /**< FFT Size 256  */
  ADISENSE_CORE_FFT_CONFIG_FFT_BINS_512  = 1,  /**< FFT Size 512  */
  ADISENSE_CORE_FFT_CONFIG_FFT_BINS_1024 = 2,  /**< FFT Size 1024 */
  ADISENSE_CORE_FFT_CONFIG_FFT_BINS_2048 = 3   /**< FFT Size 2048 */
} ADI_ADISENSE_CORE_FFT_Config_FFT_Num_Bins;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_FFT_Config_FFT_Window
 *! \brief  Indicates Window Type for FFT (FFT_Window) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_FFT_CONFIG_FFT_WINDOW_NONE             = 0,  /**< No Window                      */
  ADISENSE_CORE_FFT_CONFIG_FFT_WINDOW_HANN             = 1,  /**< Hann Window                    */
  ADISENSE_CORE_FFT_CONFIG_FFT_WINDOW_BLACKMANN_HARRIS = 2,  /**< Blackman-Harris-Nuttall Window */
  ADISENSE_CORE_FFT_CONFIG_FFT_WINDOW_TBD              = 3   /**< Reserved                       */
} ADI_ADISENSE_CORE_FFT_Config_FFT_Window;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_FFT_Config_FFT_Output
 *! \brief  Indicates FFT Output Format (FFT_Output) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_FFT_CONFIG_FFT_OUTPUT_FULL          = 0,  /**< N/2-Term Amplitude Response                                        */
  ADISENSE_CORE_FFT_CONFIG_FFT_OUTPUT_MAX16         = 1,  /**< Bin-Number and Amplitude of 16 Highest Peaks of Amplitude Response */
  ADISENSE_CORE_FFT_CONFIG_FFT_OUTPUT_FULL_WITH_RAW = 2   /**< N/2-Term Amplitude Response Plus N Raw ADC Samples                 */
} ADI_ADISENSE_CORE_FFT_Config_FFT_Output;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_FFT_Config_FFT_Num_Channels
 *! \brief  Indicates Number of Channels for FFT (FFT_Num_Channels) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_FFT_CONFIG_FFT_CHANS_1 = 0,  /**< One FFT Channel    */
  ADISENSE_CORE_FFT_CONFIG_FFT_CHANS_2 = 1,  /**< Two FFT Channels   */
  ADISENSE_CORE_FFT_CONFIG_FFT_CHANS_3 = 2,  /**< Three FFT Channels */
  ADISENSE_CORE_FFT_CONFIG_FFT_CHANS_4 = 3   /**< Four FFT Channels  */
} ADI_ADISENSE_CORE_FFT_Config_FFT_Num_Channels;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_FFT_Config_Struct
 *! \brief  FFT Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_FFT_Config_t {
  union {
    struct {
      uint32_t FFT_Num_Bins :  2;  /**< Indicates Number of Bins in FFT */
      uint32_t FFT_Window   :  2;  /**< Indicates Window Type for FFT */
      uint32_t FFT_Output   :  2;  /**< Indicates FFT Output Format */
      uint32_t FFT_Num_Channels :  2;  /**< Indicates Number of Channels for FFT */
      uint32_t reserved8        : 24;
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_FFT_Config_t;

/*@}*/

/** @defgroup Advanced_Sensor_Access Enables Access to Advanced Sensor Configuration (Advanced_Sensor_Access) Register
 *  Enables Access to Advanced Sensor Configuration (Advanced_Sensor_Access) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Advanced_Sensor_Access_Struct
 *! \brief  Enables Access to Advanced Sensor Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Advanced_Sensor_Access_t {
  union {
    struct {
      uint16_t Advanced_Sensor_Access : 16;  /**< Write Specific Key Value to Access Advanced Sensors */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Advanced_Sensor_Access_t;

/*@}*/

/** @defgroup LUT_Select Read/Write Strobe (LUT_Select) Register
 *  Read/Write Strobe (LUT_Select) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_LUT_Select_LUT_RW
 *! \brief  Read or Write LUT Data (LUT_RW) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_LUT_SELECT_LUT_READ  = 0,  /**< Read Addressed LUT Data  */
  ADISENSE_CORE_LUT_SELECT_LUT_WRITE = 1   /**< Write Addressed LUT Data */
} ADI_ADISENSE_CORE_LUT_Select_LUT_RW;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_LUT_Select_Struct
 *! \brief  Read/Write Strobe Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_LUT_Select_t {
  union {
    struct {
      uint8_t reserved0  :  7;
      uint8_t LUT_RW     :  1;  /**< Read or Write LUT Data */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_LUT_Select_t;

/*@}*/

/** @defgroup LUT_Offset Offset into Selected LUT (LUT_Offset) Register
 *  Offset into Selected LUT (LUT_Offset) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_LUT_Offset_Struct
 *! \brief  Offset into Selected LUT Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_LUT_Offset_t {
  union {
    struct {
      uint16_t LUT_Offset : 14;  /**< Offset into Look-Up-Table */
      uint16_t reserved14 :  2;
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_LUT_Offset_t;

/*@}*/

/** @defgroup LUT_Data Data to Read/Write from Addressed LUT Entry (LUT_Data) Register
 *  Data to Read/Write from Addressed LUT Entry (LUT_Data) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_LUT_Data_Struct
 *! \brief  Data to Read/Write from Addressed LUT Entry Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_LUT_Data_t {
  union {
    struct {
      uint8_t LUT_Data   :  8;  /**< Data Byte to Write to / Read from Look-Up-Table */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_LUT_Data_t;

/*@}*/

/** @defgroup Ext_Flash_Index Start Position (Sample No.) for Retrieval of Ext. Flash Data (Ext_Flash_Index) Register
 *  Start Position (Sample No.) for Retrieval of Ext. Flash Data (Ext_Flash_Index) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Ext_Flash_Index_Struct
 *! \brief  Start Position (Sample No.) for Retrieval of Ext. Flash Data Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Ext_Flash_Index_t {
  union {
    struct {
      uint32_t Ext_Flash_Index : 32;  /**< Start Position (Sample No.) for Retrieval of Ext. Flash Data */
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Ext_Flash_Index_t;

/*@}*/

/** @defgroup Ext_Flash_Sample_Count Indicates How Many Samples Stored in External Flash (Ext_Flash_Sample_Count) Register
 *  Indicates How Many Samples Stored in External Flash (Ext_Flash_Sample_Count) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Ext_Flash_Sample_Count_Struct
 *! \brief  Indicates How Many Samples Stored in External Flash Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Ext_Flash_Sample_Count_t {
  union {
    struct {
      uint32_t Ext_Flash_Sample_Count : 32;  /**< Indicates How Many Samples Stored in External Flash */
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Ext_Flash_Sample_Count_t;

/*@}*/

/** @defgroup Ext_Flash_Data Data Read Back from External Flash (Ext_Flash_Data) Register
 *  Data Read Back from External Flash (Ext_Flash_Data) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Ext_Flash_Data_Struct
 *! \brief  Data Read Back from External Flash Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Ext_Flash_Data_t {
  union {
    struct {
      uint8_t Ext_Flash_Data :  8;  /**< Data Read Back from External Flash */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Ext_Flash_Data_t;

/*@}*/

/** @defgroup Revision Hardware, Firmware Revision (Revision) Register
 *  Hardware, Firmware Revision (Revision) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Revision_Struct
 *! \brief  Hardware, Firmware Revision Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Revision_t {
  union {
    struct {
      uint32_t Rev_Patch  : 16;  /**< Patch Revision Information */
      uint32_t Rev_Minor  :  8;  /**< Minor Revision Information */
      uint32_t Rev_Major  :  8;  /**< Major Revision Information */
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Revision_t;

/*@}*/

/** @defgroup Channel_Count Number of Channel Occurrences per Measurement Cycle (Channel_Count) Register
 *  Number of Channel Occurrences per Measurement Cycle (Channel_Count) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Channel_Count_Struct
 *! \brief  Number of Channel Occurrences per Measurement Cycle Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Channel_Count_t {
  union {
    struct {
      uint8_t Channel_Count :  7;  /**< How Many Times Channel Should Appear in One Cycle */
      uint8_t Channel_Enable :  1;  /**< Enable Channel in Measurement Cycle */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Channel_Count_t;

/*@}*/

/** @defgroup Channel_Options Position of Channel Within Sequence and Enable for FFT (Channel_Options) Register
 *  Position of Channel Within Sequence and Enable for FFT (Channel_Options) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Channel_Options_FFT_Enable_Ch
 *! \brief  Indicates Channel to Be Used for FFT (FFT_Enable_Ch) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_CHANNEL_OPTIONS_NO_FFT = 0,  /**< FFT Will not be Performed on This Channel */
  ADISENSE_CORE_CHANNEL_OPTIONS_DO_FFT = 1   /**< FFT Will be Performed on This Channel     */
} ADI_ADISENSE_CORE_Channel_Options_FFT_Enable_Ch;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Channel_Options_Struct
 *! \brief  Position of Channel Within Sequence and Enable for FFT Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Channel_Options_t {
  union {
    struct {
      uint8_t Channel_Priority :  4;  /**< Indicates Priority or Position of This Channel in Sequence */
      uint8_t reserved4        :  3;
      uint8_t FFT_Enable_Ch    :  1;  /**< Indicates Channel to Be Used for FFT */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Channel_Options_t;

/*@}*/

/** @defgroup Sensor_Type Sensor Select (Sensor_Type) Register
 *  Sensor Select (Sensor_Type) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Sensor_Type_Sensor_Type
 *! \brief  Sensor Type (Sensor_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_T_DEF_L1      = 0,     /**< Thermocouple T-Type Sensor Defined Level 1             */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_J_DEF_L1      = 1,     /**< Thermocouple J-Type Sensor Defined Level 1             */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_K_DEF_L1      = 2,     /**< Thermocouple K-Type Sensor Defined Level 1             */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_1_DEF_L2      = 8,     /**< Thermocouple Sensor 1 Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_2_DEF_L2      = 9,     /**< Thermocouple Sensor 2 Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_3_DEF_L2      = 10,    /**< Thermocouple Sensor 3 Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_4_DEF_L2      = 11,    /**< Thermocouple Sensor 4 Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_T_ADV_L1      = 16,    /**< Thermocouple T-Type Sensor Advanced Level 1            */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_J_ADV_L1      = 17,    /**< Thermocouple J-Type Sensor Advanced Level 1            */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_K_ADV_L1      = 18,    /**< Thermocouple K-Type Sensor Advanced Level 1            */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_1_ADV_L2      = 24,    /**< Thermocouple Sensor 1 Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_2_ADV_L2      = 25,    /**< Thermocouple Sensor 2 Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_3_ADV_L2      = 26,    /**< Thermocouple Sensor 3 Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_4_ADV_L2      = 27,    /**< Thermocouple Sensor 4 Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT100_DEF_L1        = 32,    /**< RTD 2 Wire PT100 Sensor Defined Level 1                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT1000_DEF_L1       = 33,    /**< RTD 2 Wire PT1000 Sensor Defined Level 1               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_1_DEF_L2            = 40,    /**< RTD 2 Wire Sensor 1 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_2_DEF_L2            = 41,    /**< RTD 2 Wire Sensor 2 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_3_DEF_L2            = 42,    /**< RTD 2 Wire Sensor 3 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_4_DEF_L2            = 43,    /**< RTD 2 Wire Sensor 4 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT100_ADV_L1        = 48,    /**< RTD 2 Wire PT100 Sensor Advanced Level 1               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT1000_ADV_L1       = 49,    /**< RTD 2 Wire PT1000 Sensor Advanced Level 1              */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_1_ADV_L2            = 56,    /**< RTD 2 Wire Sensor 1 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_2_ADV_L2            = 57,    /**< RTD 2 Wire Sensor 2 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_3_ADV_L2            = 58,    /**< RTD 2 Wire Sensor 3 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_4_ADV_L2            = 59,    /**< RTD 2 Wire Sensor 4 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT100_DEF_L1        = 64,    /**< RTD 3 Wire PT100 Sensor Defined Level 1                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT1000_DEF_L1       = 65,    /**< RTD 3 Wire PT1000 Sensor Defined Level 1               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_1_DEF_L2            = 72,    /**< RTD 3 Wire Sensor 1 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_2_DEF_L2            = 73,    /**< RTD 3 Wire Sensor 2 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_3_DEF_L2            = 74,    /**< RTD 3 Wire Sensor 3 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_4_DEF_L2            = 75,    /**< RTD 3 Wire Sensor 4 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT100_ADV_L1        = 80,    /**< RTD 3 Wire PT100 Sensor Advanced Level 1               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT1000_ADV_L1       = 81,    /**< RTD 3 Wire PT1000 Sensor Advanced Level 1              */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_1_ADV_L2            = 88,    /**< RTD 3 Wire Sensor 1 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_2_ADV_L2            = 89,    /**< RTD 3 Wire Sensor 2 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_3_ADV_L2            = 90,    /**< RTD 3 Wire Sensor 3 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_4_ADV_L2            = 91,    /**< RTD 3 Wire Sensor 4 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT100_DEF_L1        = 96,    /**< RTD 4 Wire PT100 Sensor Defined Level 1                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT1000_DEF_L1       = 97,    /**< RTD 4 Wire PT1000 Sensor Defined Level 1               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_1_DEF_L2            = 104,   /**< RTD 4 Wire Sensor 1 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_2_DEF_L2            = 105,   /**< RTD 4 Wire Sensor 2 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_3_DEF_L2            = 106,   /**< RTD 4 Wire Sensor 3 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_4_DEF_L2            = 107,   /**< RTD 4 Wire Sensor 4 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT100_ADV_L1        = 112,   /**< RTD 4 Wire PT100 Sensor Advanced Level 1               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT1000_ADV_L1       = 113,   /**< RTD 4 Wire PT1000 Sensor Advanced Level 1              */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_1_ADV_L2            = 120,   /**< RTD 4 Wire Sensor 1 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_2_ADV_L2            = 121,   /**< RTD 4 Wire Sensor 2 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_3_ADV_L2            = 122,   /**< RTD 4 Wire Sensor 3 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_4_ADV_L2            = 123,   /**< RTD 4 Wire Sensor 4 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_A_10K_DEF_L1    = 128,   /**< Thermistor Type A 10kOhm Sensor Defined Level 1        */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_B_10K_DEF_L1    = 129,   /**< Thermistor Type B 10kOhm Sensor Defined Level 1        */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_1_DEF_L2        = 136,   /**< Thermistor Sensor 1 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_2_DEF_L2        = 137,   /**< Thermistor Sensor 2 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_3_DEF_L2        = 138,   /**< Thermistor Sensor 3 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_4_DEF_L2        = 139,   /**< Thermistor Sensor 4 Defined Level 2                    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_A_10K_ADV_L1    = 144,   /**< Thermistor Type A 10kOhm Sensor Advanced Level 1       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_B_10K_ADV_L1    = 145,   /**< Thermistor Type B 10kOhm Sensor Advanced Level 1       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_1_ADV_L2        = 152,   /**< Thermistor Sensor 1 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_2_ADV_L2        = 153,   /**< Thermistor Sensor 2 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_3_ADV_L2        = 154,   /**< Thermistor Sensor 3 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_4_ADV_L2        = 155,   /**< Thermistor Sensor 4 Advanced Level 2                   */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_1_DEF_L2         = 168,   /**< Bridge 4 Wire Sensor 1 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_2_DEF_L2         = 169,   /**< Bridge 4 Wire Sensor 2 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_3_DEF_L2         = 170,   /**< Bridge 4 Wire Sensor 3 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_4_DEF_L2         = 171,   /**< Bridge 4 Wire Sensor 4 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_1_ADV_L2         = 184,   /**< Bridge 4 Wire Sensor 1 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_2_ADV_L2         = 185,   /**< Bridge 4 Wire Sensor 2 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_3_ADV_L2         = 186,   /**< Bridge 4 Wire Sensor 2 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_4_ADV_L2         = 187,   /**< Bridge 4 Wire Sensor 2 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_1_DEF_L2         = 200,   /**< Bridge 6 Wire Sensor 1 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_2_DEF_L2         = 201,   /**< Bridge 6 Wire Sensor 2 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_3_DEF_L2         = 202,   /**< Bridge 6 Wire Sensor 3 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_4_DEF_L2         = 203,   /**< Bridge 6 Wire Sensor 4 Defined Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_1_ADV_L2         = 216,   /**< Bridge 6 Wire Sensor 1 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_2_ADV_L2         = 217,   /**< Bridge 6 Wire Sensor 2 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_3_ADV_L2         = 218,   /**< Bridge 6 Wire Sensor 3 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_4_ADV_L2         = 219,   /**< Bridge 6 Wire Sensor 4 Advanced Level 2                */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_2C_TYPEA_DEF_L1      = 224,   /**< Diode 2 Current Type A Sensor Defined Level 1          */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_3C_TYPEA_DEF_L1      = 225,   /**< Diode 3 Current Type A Sensor Defined Level 1          */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_2C_1_DEF_L2          = 232,   /**< Diode 2 Current Sensor 1 Defined Level 2               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_3C_1_DEF_L2          = 233,   /**< Diode 3 Current Sensor 1 Defined Level 2               */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_2C_TYPEA_ADV_L1      = 240,   /**< Diode 2 Current Type A Sensor Advanced Level 1         */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_3C_TYPEA_ADV_L1      = 241,   /**< Diode 3 Current Type A Sensor Advanced Level 1         */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_2C_1_ADV_L2          = 248,   /**< Diode 2 Current Sensor 1 Advanced Level 2              */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_DIODE_3C_1_ADV_L2          = 249,   /**< Diode 3 Current Sensor 1 Advanced Level 2              */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_A_DEF_L1        = 256,   /**< Microphone With No External Amplifier Defined Level 1  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_B_DEF_L1        = 257,   /**< Microphone With External Amplifier Defined Level 1     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_1_DEF_L2        = 264,   /**< Microphone With No External Amplifier Defined Level 2  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_2_DEF_L2        = 265,   /**< Microphone With External Amplifier Defined Level 2     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_A_ADV_L1        = 272,   /**< Microphone With No External Amplifier Advanced Level 1 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_B_ADV_L1        = 273,   /**< Microphone With External Amplifier Advanced Level 1    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_1_ADV_L2        = 278,   /**< Microphone With No External Amplifier Advanced Level 2 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_MICROPHONE_2_ADV_L2        = 279,   /**< Microphone With External Amplifier Advanced Level 2    */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE                    = 512,   /**< Voltage Input                                          */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_A_DEF_L1  = 544,   /**< Voltage Output Pressure Sensor A Defined Level 1       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_B_DEF_L1  = 545,   /**< Voltage Output Pressure Sensor B Defined Level 1       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_1_DEF_L2  = 552,   /**< Voltage Output Pressure Sensor 1 Defined Level 2       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_2_DEF_L2  = 553,   /**< Voltage Output Pressure Sensor 2 Defined Level 2       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_A_ADV_L1  = 560,   /**< Voltage Output Pressure Sensor A Advanced Level 1      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_B_ADV_L1  = 561,   /**< Voltage Output Pressure Sensor B Advanced Level 1      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_1_ADV_L2  = 568,   /**< Voltage Output Pressure Sensor 1 Advanced Level 2      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_2_ADV_L2  = 569,   /**< Voltage Output Pressure Sensor 2 Advanced Level 2      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT                    = 768,   /**< Current Input                                          */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_A_DEF_L1  = 800,   /**< Current Output Pressure Sensor A Defined Level 1       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_1_DEF_L2  = 808,   /**< Current Output Pressure Sensor 1 Defined Level 2       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_2_DEF_L2  = 809,   /**< Current Output Pressure Sensor 2 Defined Level 2       */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_A_ADV_L1  = 816,   /**< Current Output Pressure Sensor A Advanced Level 1      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_1_ADV_L2  = 824,   /**< Current Output Pressure Sensor 1 Advanced Level 2      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_2_ADV_L2  = 825,   /**< Current Output Pressure Sensor 2 Advanced Level 2      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_A_DEF_L1      = 2048,  /**< I2C Pressure Sensor A Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_B_DEF_L1      = 2049,  /**< I2C Pressure Sensor B Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_A_DEF_L2      = 2056,  /**< I2C Pressure Sensor A Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_B_DEF_L2      = 2057,  /**< I2C Pressure Sensor B Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_A_ADV_L1      = 2064,  /**< I2C Pressure Sensor A Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_B_ADV_L1      = 2065,  /**< I2C Pressure Sensor B Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_A_ADV_L2      = 2072,  /**< I2C Pressure Sensor A Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_B_ADV_L2      = 2073,  /**< I2C Pressure Sensor B Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_A_DEF_L1      = 2112,  /**< I2C Humidity Sensor A Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_B_DEF_L1      = 2113,  /**< I2C Humidity Sensor B Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_A_DEF_L2      = 2120,  /**< I2C Humidity Sensor A Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_B_DEF_L2      = 2121,  /**< I2C Humidity Sensor B Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_A_ADV_L1      = 2128,  /**< I2C Humidity Sensor A Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_B_ADV_L1      = 2129,  /**< I2C Humidity Sensor B Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_A_ADV_L2      = 2136,  /**< I2C Humidity Sensor A Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_B_ADV_L2      = 2137,  /**< I2C Humidity Sensor B Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_AMBIENTLIGHT_A_DEF_L1  = 2176,  /**< I2C Ambient Light Sensor A Defined Level 1             */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_AMBIENTLIGHT_A_DEF_L2  = 2184,  /**< I2C Ambient Light Sensor A Defined Level 2             */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_AMBIENTLIGHT_A_ADV_L1  = 2192,  /**< I2C Ambient Light Sensor A Advanced Level 1            */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_AMBIENTLIGHT_A_ADV_L2  = 2200,  /**< I2C Ambient Light Sensor A Advanced Level 2            */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_PRESSURE_A_DEF_L1      = 3072,  /**< SPI Pressure Sensor A Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_PRESSURE_A_DEF_L2      = 3080,  /**< SPI Pressure Sensor A Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_PRESSURE_A_ADV_L1      = 3088,  /**< SPI Pressure Sensor A Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_PRESSURE_A_ADV_L2      = 3096,  /**< SPI Pressure Sensor A Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_A_DEF_L1      = 3136,  /**< SPI Humidity Sensor A Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_B_DEF_L1      = 3137,  /**< SPI Humidity Sensor B Defined Level 1                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_A_DEF_L2      = 3144,  /**< SPI Humidity Sensor A Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_B_DEF_L2      = 3145,  /**< SPI Humidity Sensor B Defined Level 2                  */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_A_ADV_L1      = 3152,  /**< SPI Humidity Sensor A Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_B_ADV_L1      = 3153,  /**< SPI Humidity Sensor B Advanced Level 1                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_A_ADV_L2      = 3160,  /**< SPI Humidity Sensor A Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_B_ADV_L2      = 3161,  /**< SPI Humidity Sensor B Advanced Level 2                 */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_A_DEF_L1 = 3200,  /**< SPI Accelerometer Sensor A 3-Axis Defined Level 1      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_B_DEF_L1 = 3201,  /**< SPI Accelerometer Sensor B 3-Axis Defined Level 1      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_A_DEF_L2 = 3208,  /**< SPI Accelerometer Sensor A 3-Axis Defined Level 2      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_B_DEF_L2 = 3209,  /**< SPI Accelerometer Sensor B 3-Axis Defined Level 2      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_A_ADV_L1 = 3216,  /**< SPI Accelerometer Sensor A 3-Axis Advanced Level 1     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_B_ADV_L1 = 3217,  /**< SPI Accelerometer Sensor B 3-Axis Advanced Level 1     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_A_ADV_L2 = 3224,  /**< SPI Accelerometer Sensor A 3-Axis Advanced Level 2     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_B_ADV_L2 = 3225,  /**< SPI Accelerometer Sensor B 3-Axis Advanced Level 2     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_A_DEF_L1          = 3584,  /**< UART CO2 Sensor A Defined Level 1                      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_B_DEF_L1          = 3585,  /**< UART CO2 Sensor B Defined Level 1                      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_A_DEF_L2          = 3592,  /**< UART CO2 Sensor A Defined Level 2                      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_B_DEF_L2          = 3593,  /**< UART CO2 Sensor B Defined Level 2                      */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_A_ADV_L1          = 3600,  /**< UART CO2 Sensor A Advanced Level 1                     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_B_ADV_L1          = 3601,  /**< UART CO2 Sensor B Advanced Level 1                     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_A_ADV_L2          = 3608,  /**< UART CO2 Sensor A Advanced Level 2                     */
  ADISENSE_CORE_SENSOR_TYPE_SENSOR_UART_CO2_B_ADV_L2          = 3609   /**< UART CO2 Sensor B Advanced Level 2                     */
} ADI_ADISENSE_CORE_Sensor_Type_Sensor_Type;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Sensor_Type_Struct
 *! \brief  Sensor Select Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Sensor_Type_t {
  union {
    struct {
      uint16_t Sensor_Type : 12;  /**< Sensor Type */
      uint16_t reserved12  :  4;
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Sensor_Type_t;

/*@}*/

/** @defgroup Sensor_Details Sensor Details (Sensor_Details) Register
 *  Sensor Details (Sensor_Details) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Sensor_Details_Measurement_Units
 *! \brief  Units of Sensor Measurement (Measurement_Units) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_SENSOR_DETAILS_UNITS_UNSPECIFIED = 0,  /**< Not Specified */
  ADISENSE_CORE_SENSOR_DETAILS_UNITS_RESERVED    = 1,  /**< Reserved      */
  ADISENSE_CORE_SENSOR_DETAILS_UNITS_DEGC        = 2,  /**< Degrees C     */
  ADISENSE_CORE_SENSOR_DETAILS_UNITS_DEGF        = 3   /**< Degrees F     */
} ADI_ADISENSE_CORE_Sensor_Details_Measurement_Units;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Sensor_Details_Reference_Select
 *! \brief  Reference Selection (Reference_Select) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_SENSOR_DETAILS_REF_INT   = 0,  /**< Internal Reference          */
  ADISENSE_CORE_SENSOR_DETAILS_REF_AVDD  = 1,  /**< AVDD                        */
  ADISENSE_CORE_SENSOR_DETAILS_REF_VEXT1 = 2,  /**< External Voltage on Refin1  */
  ADISENSE_CORE_SENSOR_DETAILS_REF_VEXT2 = 3,  /**< External Voltage on Refin2  */
  ADISENSE_CORE_SENSOR_DETAILS_REF_RINT1 = 4,  /**< Internal Resistor1          */
  ADISENSE_CORE_SENSOR_DETAILS_REF_RINT2 = 5,  /**< Internal Resistor2          */
  ADISENSE_CORE_SENSOR_DETAILS_REF_REXT1 = 6,  /**< External Resistor on Refin1 */
  ADISENSE_CORE_SENSOR_DETAILS_REF_REXT2 = 7,  /**< External Resistor on Refin2 */
  ADISENSE_CORE_SENSOR_DETAILS_REF_EXC   = 8   /**< Bridge Excitation Voltage   */
} ADI_ADISENSE_CORE_Sensor_Details_Reference_Select;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Sensor_Details_PGA_Gain
 *! \brief  PGA Gain (PGA_Gain) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_1   = 0,  /**< Gain of 1   */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_2   = 1,  /**< Gain of 2   */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_4   = 2,  /**< Gain of 4   */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_8   = 3,  /**< Gain of 8   */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_16  = 4,  /**< Gain of 16  */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_32  = 5,  /**< Gain of 32  */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_64  = 6,  /**< Gain of 64  */
  ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_128 = 7   /**< Gain of 128 */
} ADI_ADISENSE_CORE_Sensor_Details_PGA_Gain;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Sensor_Details_Struct
 *! \brief  Sensor Details Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Sensor_Details_t {
  union {
    struct {
      uint32_t Measurement_Units :  4;  /**< Units of Sensor Measurement */
      uint32_t Compensation_Channel :  4;  /**< Indicates Which Channel is Used to Compensate Sensor Result */
      uint32_t reserved8            :  8;
      uint32_t Unity_LUT_Select     :  1;  /**< Selects Unity Transfer Function Instead of Sensor Default */
      uint32_t Do_Not_Publish       :  1;  /**< Do Not Publish Channel Result */
      uint32_t Reference_Buffer_Disable :  1;  /**< Enable or Disable ADC Reference Buffer */
      uint32_t Vbias                    :  1;  /**< Controls ADC Vbias Output */
      uint32_t Reference_Select         :  4;  /**< Reference Selection */
      uint32_t PGA_Gain                 :  3;  /**< PGA Gain */
      uint32_t reserved27               :  1;
      uint32_t Averaging                :  3;  /**< Number of ADC Results to Average */
      uint32_t Compensation_Disable     :  1;  /**< Indicates Compensation Data Should Not Be Used */
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Sensor_Details_t;

/*@}*/

/** @defgroup Channel_Excitation Excitation Current (Channel_Excitation) Register
 *  Excitation Current (Channel_Excitation) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Channel_Excitation_IOUT_Excitation_Current
 *! \brief  Current Source Value (IOUT_Excitation_Current) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_OFF    = 0,  /**< Disabled   */
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_50UA   = 1,  /**< 50 \mu;A   */
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_100UA  = 2,  /**< 100 \mu;A  */
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_250UA  = 3,  /**< 250 \mu;A  */
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_500UA  = 4,  /**< 500 \mu;A  */
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_750UA  = 5,  /**< 750 \mu;A  */
  ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_1000UA = 6   /**< 1000 \mu;A */
} ADI_ADISENSE_CORE_Channel_Excitation_IOUT_Excitation_Current;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Channel_Excitation_IOUT_Diode_Ratio
 *! \brief  Modify Current Ratios Used for Diode Sensor (IOUT_Diode_Ratio) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_DIODE_DEFAULT = 0,  /**< Default Excitation Current Ratios */
  ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_DIODE_MAX     = 1   /**< Higher Excitation Current Ratios  */
} ADI_ADISENSE_CORE_Channel_Excitation_IOUT_Diode_Ratio;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Channel_Excitation_Struct
 *! \brief  Excitation Current Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Channel_Excitation_t {
  union {
    struct {
      uint8_t IOUT_Excitation_Current :  3;  /**< Current Source Value */
      uint8_t reserved3               :  2;
      uint8_t IOUT_Diode_Ratio        :  1;  /**< Modify Current Ratios Used for Diode Sensor */
      uint8_t reserved6               :  1;
      uint8_t IOUT_Dont_Swap_3Wire    :  1;  /**< Indicates 3-Wire Excitation Currents Should Not Be Swapped */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Channel_Excitation_t;

/*@}*/

/** @defgroup Settling_Time Settling Time (Settling_Time) Register
 *  Settling Time (Settling_Time) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Settling_Time_Settling_Time_Units
 *! \brief  Units for Settling Time (Settling_Time_Units) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_SETTLING_TIME_MICROSECONDS = 0,  /**< Micro-Seconds */
  ADISENSE_CORE_SETTLING_TIME_MILLISECONDS = 1,  /**< Milli-Seconds */
  ADISENSE_CORE_SETTLING_TIME_SECONDS      = 2   /**< Seconds       */
} ADI_ADISENSE_CORE_Settling_Time_Settling_Time_Units;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Settling_Time_Struct
 *! \brief  Settling Time Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Settling_Time_t {
  union {
    struct {
      uint16_t Settling_Time : 14;  /**< Settling Time to Allow When Switching to Channel */
      uint16_t Settling_Time_Units :  2;  /**< Units for Settling Time */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Settling_Time_t;

/*@}*/

/** @defgroup Filter_Select ADC Digital Filter Selection (Filter_Select) Register
 *  ADC Digital Filter Selection (Filter_Select) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Filter_Select_ADC_Filter_Type
 *! \brief  ADC Digital Filter Type (ADC_Filter_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_FILTER_SELECT_FILTER_FIR_25SPS = 0,  /**< FIR Filter 25 SPS */
  ADISENSE_CORE_FILTER_SELECT_FILTER_FIR_20SPS = 1,  /**< FIR Filter 20 SPS */
  ADISENSE_CORE_FILTER_SELECT_FILTER_SINC4     = 2,  /**< Sinc4 Filter      */
  ADISENSE_CORE_FILTER_SELECT_FILTER_TBD       = 3   /**< TBD Filter        */
} ADI_ADISENSE_CORE_Filter_Select_ADC_Filter_Type;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Filter_Select_Struct
 *! \brief  ADC Digital Filter Selection Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Filter_Select_t {
  union {
    struct {
      uint32_t ADC_FS     : 11;  /**< ADC Digital Filter Select */
      uint32_t ADC_Filter_Type :  5;  /**< ADC Digital Filter Type */
      uint32_t reserved16      : 16;
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Filter_Select_t;

/*@}*/

/** @defgroup High_Threshold_Limit High Threshold (High_Threshold_Limit) Register
 *  High Threshold (High_Threshold_Limit) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_High_Threshold_Limit_Struct
 *! \brief  High Threshold Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_High_Threshold_Limit_t {
  union {
    struct {
      float High_Threshold;  /**< Upper Limit for Sensor Alert Comparison */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_High_Threshold_Limit_t;

/*@}*/

/** @defgroup Low_Threshold_Limit Low Threshold (Low_Threshold_Limit) Register
 *  Low Threshold (Low_Threshold_Limit) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Low_Threshold_Limit_Struct
 *! \brief  Low Threshold Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Low_Threshold_Limit_t {
  union {
    struct {
      float Low_Threshold;  /**< Lower Limit for Sensor Alert Comparison */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_Low_Threshold_Limit_t;

/*@}*/

/** @defgroup Sensor_Offset Sensor Offset Adjustment (Sensor_Offset) Register
 *  Sensor Offset Adjustment (Sensor_Offset) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Sensor_Offset_Struct
 *! \brief  Sensor Offset Adjustment Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Sensor_Offset_t {
  union {
    struct {
      float Sensor_Offset;  /**< Sensor Offset Adjustment */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_Sensor_Offset_t;

/*@}*/

/** @defgroup Sensor_Gain Sensor Gain Adjustment (Sensor_Gain) Register
 *  Sensor Gain Adjustment (Sensor_Gain) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Sensor_Gain_Struct
 *! \brief  Sensor Gain Adjustment Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Sensor_Gain_t {
  union {
    struct {
      float Sensor_Gain;  /**< Sensor Gain Adjustment */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_Sensor_Gain_t;

/*@}*/

/** @defgroup Alert_Code_Ch Per-Channel Detailed Alert-Code Information (Alert_Code_Ch) Register
 *  Per-Channel Detailed Alert-Code Information (Alert_Code_Ch) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Alert_Code_Ch_Struct
 *! \brief  Per-Channel Detailed Alert-Code Information Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Alert_Code_Ch_t {
  union {
    struct {
      uint16_t Alert_Code_Ch : 16;  /**< Per-Channel Code Indicating Type of Alert */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Alert_Code_Ch_t;

/*@}*/

/** @defgroup Channel_Skip Indicates If Channel Will Skip Some Measurement Cycles (Channel_Skip) Register
 *  Indicates If Channel Will Skip Some Measurement Cycles (Channel_Skip) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Channel_Skip_Struct
 *! \brief  Indicates If Channel Will Skip Some Measurement Cycles Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Channel_Skip_t {
  union {
    struct {
      uint16_t Channel_Skip :  8;  /**< Indicates If Channel Will Skip Some Measurement Cycles */
      uint16_t reserved8    :  8;
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Channel_Skip_t;

/*@}*/

/** @defgroup Sensor_Parameter Sensor Parameter Adjustment (Sensor_Parameter) Register
 *  Sensor Parameter Adjustment (Sensor_Parameter) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Sensor_Parameter_Struct
 *! \brief  Sensor Parameter Adjustment Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Sensor_Parameter_t {
  union {
    struct {
      float Sensor_Parameter;  /**< Sensor Parameter Adjustment */
    };
    float VALUE32;
  };
} ADI_ADISENSE_CORE_Sensor_Parameter_t;

/*@}*/

/** @defgroup Calibration_Parameter Calibration Parameter Value (Calibration_Parameter) Register
 *  Calibration Parameter Value (Calibration_Parameter) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Calibration_Parameter_Struct
 *! \brief  Calibration Parameter Value Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Calibration_Parameter_t {
  union {
    struct {
      uint32_t Calibration_Parameter : 24;  /**< Calibration Parameter Value */
      uint32_t Calibration_Parameter_Enable :  1;  /**< Enables Use of Calibration_Parameter */
      uint32_t reserved25                   :  7;
    };
    uint32_t VALUE32;
  };
} ADI_ADISENSE_CORE_Calibration_Parameter_t;

/*@}*/

/** @defgroup Digital_Sensor_Config Digital Sensor Data Coding (Digital_Sensor_Config) Register
 *  Digital Sensor Data Coding (Digital_Sensor_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Config_Digital_Sensor_Coding
 *! \brief  Data Encoding of Sensor Result (Digital_Sensor_Coding) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_NONE          = 0,  /**< None/Invalid    */
  ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_UNIPOLAR      = 1,  /**< Unipolar        */
  ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_TWOS_COMPL    = 2,  /**< Twos Complement */
  ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_OFFSET_BINARY = 3   /**< Offset Binary   */
} ADI_ADISENSE_CORE_Digital_Sensor_Config_Digital_Sensor_Coding;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Config_Struct
 *! \brief  Digital Sensor Data Coding Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Config_t {
  union {
    struct {
      uint16_t Digital_Sensor_Coding :  2;  /**< Data Encoding of Sensor Result */
      uint16_t Digital_Sensor_Little_Endian :  1;  /**< Data Endianness of Sensor Result */
      uint16_t Digital_Sensor_Left_Aligned  :  1;  /**< Data Alignment Within the Data Frame */
      uint16_t Digital_Sensor_Bit_Offset    :  4;  /**< Data Bit Offset, Relative to Alignment */
      uint16_t Digital_Sensor_Read_Bytes    :  3;  /**< Number of Bytes to Read from the Sensor */
      uint16_t Digital_Sensor_Data_Bits     :  5;  /**< Number of Relevant Data Bits */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Config_t;

/*@}*/

/** @defgroup Digital_Sensor_Address Sensor Address (Digital_Sensor_Address) Register
 *  Sensor Address (Digital_Sensor_Address) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Address_Struct
 *! \brief  Sensor Address Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Address_t {
  union {
    struct {
      uint8_t Digital_Sensor_Address :  8;  /**< I2C Address or Write Address Command for SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Address_t;

/*@}*/

/** @defgroup Digital_Sensor_Num_Cmds Number of Configuration, Read Commands for Digital Sensors (Digital_Sensor_Num_Cmds) Register
 *  Number of Configuration, Read Commands for Digital Sensors (Digital_Sensor_Num_Cmds) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Num_Cmds_Struct
 *! \brief  Number of Configuration, Read Commands for Digital Sensors Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Num_Cmds_t {
  union {
    struct {
      uint8_t Digital_Sensor_Num_Cfg_Cmds :  3;  /**< Number of Configuration Commands for Digital Sensor */
      uint8_t reserved3                    :  1;
      uint8_t Digital_Sensor_Num_Read_Cmds :  3;  /**< Number of Read Commands for Digital Sensor */
      uint8_t reserved7                    :  1;
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Num_Cmds_t;

/*@}*/

/** @defgroup Digital_Sensor_Comms Digital Sensor Communication Clock Configuration (Digital_Sensor_Comms) Register
 *  Digital Sensor Communication Clock Configuration (Digital_Sensor_Comms) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Comms_Digital_Sensor_Comms_En
 *! \brief  Enable Digital Sensor Comms Register Parameters (Digital_Sensor_Comms_En) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_DEFAULT = 0,  /**< Default Parameters Used for Digital Sensor Communications       */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_USER    = 1   /**< User Supplied Parameters Used for Digital Sensor Communications */
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_Digital_Sensor_Comms_En;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Comms_SPI_Clock
 *! \brief  Controls Clock Frequency for SPI Sensors (SPI_Clock) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_13MHZ    = 0,   /**< 13 MHz    */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_6_5MHZ   = 1,   /**< 6.5 MHz   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_3_25MHZ  = 2,   /**< 3.25 MHz  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_1_625MHZ = 3,   /**< 1.625 MHz */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_812KHZ   = 4,   /**< 812.5kHz  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_406KHZ   = 5,   /**< 406.2kHz  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_203KHZ   = 6,   /**< 203.1kHz  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_101KHZ   = 7,   /**< 101.5kHz  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_50KHZ    = 8,   /**< 50.8kHz   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_25KHZ    = 9,   /**< 25.4kHz   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_12KHZ    = 10,  /**< 12.7kHz   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_6KHZ     = 11,  /**< 6.3kHz    */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_3KHZ     = 12,  /**< 3.2kHz    */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_1_5KHZ   = 13,  /**< 1.58kHz   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_793HZ    = 14,  /**< 793Hz     */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_396HZ    = 15   /**< 396Hz     */
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_SPI_Clock;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Comms_I2C_Clock
 *! \brief  Controls SCLK Frequency for I2C Sensors (I2C_Clock) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_I2C_100K      = 0,  /**< 100kHz SCL */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_I2C_400K      = 1,  /**< 400kHz SCL */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED1 = 2,  /**< Reserved   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED2 = 3   /**< Reserved   */
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_I2C_Clock;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Comms_Uart_Baud
 *! \brief  Controls Baud Rate for UART Sensors (Uart_Baud) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_115200 = 0,  /**< 115200 bps */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_57600  = 1,  /**< 57600 bps  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_38400  = 2,  /**< 38400 bps  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_19200  = 3,  /**< 19200 bps  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_9600   = 4,  /**< 9600 bps   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_4800   = 5,  /**< 4800 bps   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_2400   = 6,  /**< 2400 bps   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_UART_1200   = 7   /**< 1200 bps   */
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_Uart_Baud;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Comms_SPI_Mode
 *! \brief  Configuration for Sensor SPI Protocol (SPI_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_0 = 0,  /**< Clock Polarity = 0 Clock Phase = 0 */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_1 = 1,  /**< Clock Polarity = 0 Clock Phase = 1 */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_2 = 2,  /**< Clock Polarity = 1 Clock Phase = 0 */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_3 = 3   /**< Clock Polarity = 1 Clock Phase = 1 */
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_SPI_Mode;


/*  =========================================================================
 *! \enum   ADI_ADISENSE_CORE_Digital_Sensor_Comms_Uart_Mode
 *! \brief  Configuration for Sensor UART Protocol (Uart_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8N1 = 0,   /**< 8 Data Bits No Parity 1 Stop Bit    */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8N2 = 1,   /**< 8 Data Bits No Parity 2 Stop Bits   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8N3 = 2,   /**< 8 Data Bits No Parity 3 Stop Bits   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8E1 = 4,   /**< 8 Data Bits Even Parity 1 Stop Bit  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8E2 = 5,   /**< 8 Data Bits Even Parity 2 Stop Bits */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8E3 = 6,   /**< 8 Data Bits Even Parity 3 Stop Bits */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8O1 = 8,   /**< 8 Data Bits Odd Parity 1 Stop Bit   */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8O2 = 9,   /**< 8 Data Bits Odd Parity 2 Stop Bits  */
  ADISENSE_CORE_DIGITAL_SENSOR_COMMS_LINECONTROL_8O3 = 10   /**< 8 Data Bits Odd Parity 3 Stop Bits  */
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_Uart_Mode;


/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Comms_Struct
 *! \brief  Digital Sensor Communication Clock Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Comms_t {
  union {
    struct {
      uint16_t Digital_Sensor_Comms_En :  1;  /**< Enable Digital Sensor Comms Register Parameters */
      uint16_t SPI_Clock               :  4;  /**< Controls Clock Frequency for SPI Sensors */
      uint16_t I2C_Clock               :  2;  /**< Controls SCLK Frequency for I2C Sensors */
      uint16_t Uart_Baud               :  3;  /**< Controls Baud Rate for UART Sensors */
      uint16_t SPI_Mode                :  2;  /**< Configuration for Sensor SPI Protocol */
      uint16_t Uart_Mode               :  4;  /**< Configuration for Sensor UART Protocol */
    };
    uint16_t VALUE16;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Comms_t;

/*@}*/

/** @defgroup Digital_Sensor_Command1 Sensor Configuration Command1 (Digital_Sensor_Command1) Register
 *  Sensor Configuration Command1 (Digital_Sensor_Command1) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command1_Struct
 *! \brief  Sensor Configuration Command1 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command1_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command1 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command1_t;

/*@}*/

/** @defgroup Digital_Sensor_Command2 Sensor Configuration Command2 (Digital_Sensor_Command2) Register
 *  Sensor Configuration Command2 (Digital_Sensor_Command2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command2_Struct
 *! \brief  Sensor Configuration Command2 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command2_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command2 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command2_t;

/*@}*/

/** @defgroup Digital_Sensor_Command3 Sensor Configuration Command3 (Digital_Sensor_Command3) Register
 *  Sensor Configuration Command3 (Digital_Sensor_Command3) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command3_Struct
 *! \brief  Sensor Configuration Command3 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command3_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command3 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command3_t;

/*@}*/

/** @defgroup Digital_Sensor_Command4 Sensor Configuration Command4 (Digital_Sensor_Command4) Register
 *  Sensor Configuration Command4 (Digital_Sensor_Command4) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command4_Struct
 *! \brief  Sensor Configuration Command4 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command4_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command4 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command4_t;

/*@}*/

/** @defgroup Digital_Sensor_Command5 Sensor Configuration Command5 (Digital_Sensor_Command5) Register
 *  Sensor Configuration Command5 (Digital_Sensor_Command5) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command5_Struct
 *! \brief  Sensor Configuration Command5 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command5_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command5 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command5_t;

/*@}*/

/** @defgroup Digital_Sensor_Command6 Sensor Configuration Command6 (Digital_Sensor_Command6) Register
 *  Sensor Configuration Command6 (Digital_Sensor_Command6) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command6_Struct
 *! \brief  Sensor Configuration Command6 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command6_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command6 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command6_t;

/*@}*/

/** @defgroup Digital_Sensor_Command7 Sensor Configuration Command7 (Digital_Sensor_Command7) Register
 *  Sensor Configuration Command7 (Digital_Sensor_Command7) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Command7_Struct
 *! \brief  Sensor Configuration Command7 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Command7_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command7 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Command7_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd1 Sensor Read Command1 (Digital_Sensor_Read_Cmd1) Register
 *  Sensor Read Command1 (Digital_Sensor_Read_Cmd1) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd1_Struct
 *! \brief  Sensor Read Command1 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd1_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd1 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd1_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd2 Sensor Read Command2 (Digital_Sensor_Read_Cmd2) Register
 *  Sensor Read Command2 (Digital_Sensor_Read_Cmd2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd2_Struct
 *! \brief  Sensor Read Command2 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd2_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd2 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd2_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd3 Sensor Read Command3 (Digital_Sensor_Read_Cmd3) Register
 *  Sensor Read Command3 (Digital_Sensor_Read_Cmd3) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd3_Struct
 *! \brief  Sensor Read Command3 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd3_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd3 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd3_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd4 Sensor Read Command4 (Digital_Sensor_Read_Cmd4) Register
 *  Sensor Read Command4 (Digital_Sensor_Read_Cmd4) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd4_Struct
 *! \brief  Sensor Read Command4 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd4_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd4 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd4_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd5 Sensor Read Command5 (Digital_Sensor_Read_Cmd5) Register
 *  Sensor Read Command5 (Digital_Sensor_Read_Cmd5) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd5_Struct
 *! \brief  Sensor Read Command5 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd5_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd5 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd5_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd6 Sensor Read Command6 (Digital_Sensor_Read_Cmd6) Register
 *  Sensor Read Command6 (Digital_Sensor_Read_Cmd6) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd6_Struct
 *! \brief  Sensor Read Command6 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd6_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd6 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd6_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd7 Sensor Read Command7 (Digital_Sensor_Read_Cmd7) Register
 *  Sensor Read Command7 (Digital_Sensor_Read_Cmd7) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd7_Struct
 *! \brief  Sensor Read Command7 Register bit field structure
 * ========================================================================== */
typedef struct _ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd7_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd7 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADI_ADISENSE_CORE_Digital_Sensor_Read_Cmd7_t;

/*@}*/


#if defined (__CC_ARM)
#pragma pop
#endif 

#endif
