
/*!
 ******************************************************************************
 * @file: sensor2_bridge_6w_pressure_config
 * @brief: Initilize the sensor configuration
 *-----------------------------------------------------------------------------
 */
#include "adi_sense_config_types.h"

ADI_SENSE_CONFIG smartcushion_adisense_config = {
    .versionId = { .major = 1, .minor = 4 },
    .productId = ADI_SENSE_PRODUCT_ID_ADSNS1000,
    .adisense1000 =
    {
        .power =
        {
            .powerMode = ADI_SENSE_1000_POWER_MODE_FULL,
        },
        .measurement =
        {
            .operatingMode = ADI_SENSE_1000_OPERATING_MODE_CONTINUOUS,
            .dataReadyMode = ADI_SENSE_1000_DATAREADY_PER_CYCLE,
        },

        /*
            Define the channels and operating mode
        */
        .channels =
        {
            [ADI_SENSE_1000_CHANNEL_ID_CJC_0] = {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 1000,
                .measurementUnit = ADI_SENSE_1000_MEASUREMENT_UNIT_CELSIUS,
                .adcChannelConfig = {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_RTD_2WIRE_PT100_DEF_L1,
                    .gain = ADI_SENSE_1000_ADC_GAIN_32X,
                    .current = {
                        .outputLevel = ADI_SENSE_1000_ADC_EXC_CURRENT_500uA,
                        .diodeRatio = ADI_SENSE_1000_ADC_EXC_CURRENT_IOUT_DIODE_DEFAULT //.swapOption = ADI_SENSE_1000_ADC_EXC_CURRENT_SWAP_NONE,
                    },
                    .filter = {
                        //.type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
//                        .fs = 0,
                        .type = ADI_SENSE_1000_ADC_FILTER_SINC4,
                        .fs = 1920,
                    },
                    .reference = {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_RESISTOR_INTERNAL_1,
                        .disableBuffer = false,
                    },
                    .enableVbias = false,
                },
            },
            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_3] =
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .offsetAdjustment = -1,
                .extraSettlingTime = 20000,
                .adcChannelConfig =
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter =
                    {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                    },
                    .reference =
                    {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                    },
                    .enableVbias = false,
                },
            },

            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_2] =
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig =
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter =
                    {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                    },
                    .reference =
                    {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                    },
                    .enableVbias = false,
                },
            },

            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_1] =
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .offsetAdjustment = -0.7,
                .extraSettlingTime = 20000,
                .adcChannelConfig =
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_3_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter =
                    {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                    },
                    .reference =
                    {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                    },
                    .enableVbias = false,
                },
            },

            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_0] =
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig =
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_4_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter =
                    {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                    },
                    .reference =
                    {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                    },
                    .enableVbias = false,
                },
            },
            [ADI_SENSE_1000_CHANNEL_ID_I2C_0] =
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 0.0000,
                .i2cChannelConfig = {
                    .sensor = ADI_SENSE_1000_I2C_SENSOR_HUMIDITY_B_DEF_L1, //ADI_SENSE_1000_I2C_SENSOR_HUMIDITY_SENSIRION_SHT3X,
                    .deviceAddress = 0x44,
                },
            },
            [ADI_SENSE_1000_CHANNEL_ID_SPI_0] =
            {
                /* Accelerometer X-Axis (and common settings for physical channel) */
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 10000,
                .offsetAdjustment = 0.07,
                /* Optional threshold limits applied to the processed measurement results */
                .lowThreshold = -2.0,
                .highThreshold = 2.0,
                .spiChannelConfig = {
                    .sensor = ADI_SENSE_1000_SPI_SENSOR_ACCELEROMETER_A_DEF_L1, 
                },
            },
            [ADI_SENSE_1000_CHANNEL_ID_SPI_1] =
            {
                /* Accelerometer Y-Axis (virtual channel) */
                .enableChannel = true,
                .offsetAdjustment = 0, 
                /* Optional threshold limits applied to the processed measurement results */
                .lowThreshold = -2.0,
                .highThreshold = 2.0,
                .spiChannelConfig = {
                    .sensor = ADI_SENSE_1000_SPI_SENSOR_ACCELEROMETER_A_DEF_L1, 
                },
            },
            [ADI_SENSE_1000_CHANNEL_ID_SPI_2] =
            {
                /* Accelerometer Z-Axis (virtual channel) */
                .enableChannel = true,
                /* Optional adjustment applied to the PROCESSED OUTPUT value from the sensor */
                .offsetAdjustment = -0.2,
                /* Optional threshold limits applied to the processed measurement results */
                .lowThreshold = -2,
                .highThreshold = 2,
                .spiChannelConfig = {
                    .sensor = ADI_SENSE_1000_SPI_SENSOR_ACCELEROMETER_A_DEF_L1, 
                },
            },


        },
    },
};

