

/**
 * @file my_proswift_error_codes.h
 * @author Jake Greaves
 * @date 05 Feb 2018
 * @brief Error codes used by both interfaces
 */

#ifndef __MY_PROSWIFT_ERROR_CODES_H_
#define __MY_PROSWIFT_ERROR_CODES_H_


/**
 * @brief Error values that may be returned.
 */
enum ErrorType {
    NO_ERROR 					= 0x00,
    NO_ERROR_BOOTLOADER				= 0x01,
    ERROR_NO_COMMAND_MATCHED 			= 0x10,
    ERROR_EXPECTED_DELIMITER 			= 0x11,
    ERROR_SET_CONFIG				= 0x20,
    ERROR_UPDATE_CONFIG				= 0x21,
    ERROR_EXPECTED_COMMAND			= 0x22,
    ERROR_GET_DRDY_INFO				= 0x30,
    ERROR_ALLOCATE_BUFFER			= 0x31,
    ERROR_GPIO_CALLBACK_REG 			= 0x32,
    ERROR_START_MEASUREMENT			= 0x33,
    ERROR_GET_DATA				= 0x34,
    ERROR_SAMPLE_COUNT_MISMATCH		= 0x35,
    ERROR_STREAM_NOT_STARTED			= 0x36,
    ERROR_STOP_MEASUREMENT			= 0x37,
    ERROR_EXPECTED_CHANNEL 			= 0x40,
    ERROR_EXPECTED_KEYWORD			= 0x41,
    ERROR_EXPECTED_VALUE			= 0x42,
    ERROR_CONVERSION_FAILED			= 0x43,
    ERROR_ATTR_NOT_SUPPORTED_ON_CHANNEL 	= 0x44,
    ERROR_UNDEFINED				= 0xF0
};


#endif
