#ifndef __BL652_H_
#define __BL652_H_


/******************************************************************************/
/* Include Files                                                              */
/******************************************************************************/

#include <stdint.h>

/******************************************************************************/
/* BLE parameters                                                             */
/******************************************************************************/

//size of buffers used
#define BLE_PACKET_SIZE 20

//parameters for da14580
#define RESET_LENGTH    10 //ms

#define BLE_TX_PACKET_DELAY 100 //ms

#define AT_COMMAND_DELIMITER '\r'

#define AT_COMMAND_ERROR "ERROR"


/******************************************************************************/
/* Function Prototypes                                                        */
/******************************************************************************/

//boot BLE module
uint32_t Bl652_Boot( void );

//Write to BLE over UART
uint32_t Bl652_Write( char *txBuffer, uint32_t byteCount );

//Read from BLE over UART
uint32_t Bl652_Read( char *rxBuffer, uint32_t byteCount );

//setup for callback based read
uint32_t Bl652_SetupReadCb( void *rxBuffer, uint32_t maxSize, volatile bool *bMessageReadFlag );

//clear read callback
uint32_t Bl652_ClearCb( void );

//wait until BLE is awake
uint32_t Bl652_WaitUntilAvailable( void );

uint32_t Bl652_Printf(const char *format, ...);

#endif
