Porting Guide
=============
[ADISENSE Host Portability Layer](@ref ADISENSE_Host) describes a portability
API layer which encapsulates the host platform-specific functions used by the
ADISENSE Host Library to communicate with the ADSNS1000 module.

Porting the ADISENSE Host Library to a new hardware platform and/or operating
system (OS) should involve replacing only the portability layer API functions
with a suitable implementation for the target platform.

A fully-functional communication interface implementation (i.e. @ref
ADISENSE_Spi) is required, as is @ref ADISENSE_Time which provides time-delay
functions for the ADISENSE Host Library.  However, other elements of the
portability layer, such as @ref ADISENSE_Gpio and @ref ADISENSE_Log, may be
substituted with dummy implementations if necessary.

Source code for the ST Nucleo / mbed portability layer implementation is located
in the following sub-directory within the ADISENSE Host Library source package:

    <path_to_library>/host/src/mbed/
