ADSNS1000 Overview
=======================

[TOC]

ADSNS1000
--------------

# Overview {#overview}
ADISENSE product family provide complete, flexible and versatile measurement
solutions for a wide range of both compensated and uncompensated analog or
digital sensors. The ADSNS1000 is the first product in this portfolio. The
ADSNS1000 module seamlessly interfaces to temperature, pressure, humidity,
acceleration and multiple other sensors. The module has all the building blocks
to excite, measure and correct each sensor and generate an output in sensor
related units such as oC, oF, psi, %RH. In conjunction with the MeasureWare
ecosystem, ADSNS1000 can be easily configured and optimised for the sensor types
selected to meet the accuracy and measurement times required.

The ADSNS1000 provides up to 11 measurement channels. The module has 4
measurement inputs that connect to uncompensated analog sensors. It also
includes two dedicated analog measurement inputs for temperature compensation
such as cold junction compensation of the thermocouples. ADSNS1000 includes a
0-10V measurement input, 0-20mA measurement input, two I2C measurement inputs
and one SPI measurement input also which are useful for compensated sensors such
as pressure, humidity and accelerometers.

The ADSNS1000 communicates to the host application processor via a dedicated SPI
interface. The ADSNS1000 operates as a slave device when communicating with the
host application processor.

The ADSNS1000 host application library currently includes support for the
ADSNS1000 module when used in conjunction with the ST Nucleo F411RE host
application processor running in the Arm Mbed development environment.

# Interfaces {#interfaces}
## Host Communication Interfaces {#interfaces_hostcommunication}
The interfaces in this section enable the connectivity with the host application
processor which is responsible for communication, configuration and control of
the ADSNS1000 module.  Platform specific host connection parameters may be
specified via the [ADI_SENSE_CONNECTION](@ref ADI_SENSE_CONNECTION) structure on
the [ADISENSE API](@ref ADISENSE_Api) and low-level connectivity is accessed via
the [ADISENSE Host Portability Layer](@ref ADISENSE_Host).

* SPI
  + Standard 4-wire SPI interface (SCLK, MOSI, MISO, SS)
  + Mode 0 (CPOL=0, CPHA=0)
  + SCLK speeds up to 1.6MHz
* Signals
  + ERROR
    - active-high digital output
    - signals an error condition to the host processor
    - an error condition signifies a fault that will affect the integrity of the
      measurement
    - operation of the ADSNS1000 will cease to continue until the ERROR is
      rectified
  + ALERT
   - active-high digital output
   - signals a warning/alert condition to the host processor
   - measurement operation will continue on the ADSNS1000 in an ALERT condition
  + DATAREADY
    - active-high digital output
    - going high to indicate the completion of a sensor measurement
    - can be programmed to go high on the completion of each individual
      measurement, it can go high when a cycle of measurements is complete or
      when the FIFO is full
  + RESET
    - active-low digital input
    - pulse low for at least 4 microseconds to trigger a hardware reset of the
      module

## Sensor Interfaces {#interfaces_sensor}
The following is an overview of the sensor interfaces available on the ADSNS1000
module.  For latest information on the sensors currently supported by this
library, please refer to the [ADSNS1000 API](@ref ADSNS1000_Api)

* Analog Sensor Interfaces
  + CJC 0-1
    - Intended for connecting temperature measurement sensors for temperature
      compensation
    - Analog sensor types currently supported:
      - 2-wire RTD PT100 temperature sensors
      - 2-wire RTD PT1000 temperature sensors
      - Thermistors 10k NTC temperature sensors
      - Diode temperature sensors
  + SENSOR 0-3
    - Intended for connecting a wide variety of uncompensated analog sensors
    - Analog sensor types currently supported:
      - 2/3/4-wire PT100 RTD temperature sensors
      - 2/3/4-wire PT1000 RTD temperature sensors
      - Type-T/K/J Thermocouple temperature sensors
      - 4/6-wire bridge transducers
      - Thermistors 10k NTC temperature sensors
      - Diode temperature sensors
  + I\_MEAS
    - Intended for connecting compensated current output 0-20mA analog sensors
  + V\_MEAS
    - Intended for connecting compensated voltage output 0-10V analog sensors
* Digital Sensor Interfaces
  + SPI
    - Intended for connecting supported SPI digital sensors
    - SPI digital sensor types currently supported:
      - Honeywell TruStability pressure sensors
      - Analog Devices ADXL362 3-Axis MEMS accelerometer
      - Analog Devices ADXL355 3-Axis MEMS accelerometer
  + I2C
    - Intended for connecting supported I2C digital sensors
    - I2C digital sensor types currently supported:
      - Honeywell HumidIcon HIH9000 Series humidity sensors
      - Sensirion SHT3x Series humidity sensors
      - ON-Semiconductor NOA1305 ambient light sensor
  + UART
    - Intended for connecting supported UART digital sensors
    - UART digital sensor types currently supported:
      - Cozir CO2 sensors

## Ancillary Interfaces {#interfaces_ancillary}
* External Reference Inputs
  + REF 1-2
    - Optional external reference inputs, for use with analog sensors
* Supply Voltages / Voltage Reference Outputs
  + AVDD
    - Analog voltage output
    - The filtered VDD power supply is available on AVDD
    - This supply can be used as the power supply for voltage out, current out
      or digital out compensated sensors.
  + VDD
    - Analog Supply Voltage
    - The voltage on VDD is referenced to GND
    - The differential between VDD and GND must be between 3 V and 3.6 V
