/*
 ******************************************************************************
 * file:   myswift_periph.cpp
 *-----------------------------------------------------------------------------
 */

#include "myproswift_periph.h"

/*
 ******************************************************************************
 * ADISense1000
 *-----------------------------------------------------------------------------
 */
//connection information for initialising ADISense1000
ADI_SENSE_CONNECTION connectionInfo = {
    .type = ADI_SENSE_CONNECTION_TYPE_SPI,
    .spi = {
        .mosiPin    = 	SENSE_SPI_MOSI,
        .misoPin    = 	SENSE_SPI_MISO,
        .sckPin     = 	SENSE_SPI_SCK,
        .csPin      = 	SENSE_SPI_CS,
        .maxSpeedHz = 	SENSE_SPI_FREQUENCY,
    },                  
    .gpio = {           
        .resetPin     = SENSE_RST_PIN,
        .errorPin     = SENSE_ERROR_PIN,
        .alertPin     = SENSE_ALERT_PIN,
        .datareadyPin = SENSE_DREADY_PIN,
    },
};

/*
 ******************************************************************************
 * Bluetooth Low Energy
 *-----------------------------------------------------------------------------
 */
//reset pin of BLE module
DigitalOut ble_rst(BLE_RST_PIN, 0);

//flow control
DigitalOut 	ble_Cts(BLE_CTS_PIN, 1);
DigitalIn  	ble_Rts(BLE_RTS_PIN);

//DigitalOut 	ble_Cts(BLE_CTS_PIN, 0);
//DigitalIn  	ble_Rts(BLE_RTS_PIN, PullDown);

Serial bleSerialDevice(BLE_SERIAL_TX, BLE_SERIAL_RX, BLE_BAUD_RATE);

#ifdef BL652
DigitalOut bleMode0(BLE_MODE_0_PIN, 0);
DigitalOut bleMode1(BLE_MODE_1_PIN, 0);
#endif


/*
 ******************************************************************************
 * PC Serial
 *-----------------------------------------------------------------------------
 */

//pointer initialised in adi_sense_Log.cpp using pins defined in this header
Serial *gpUartDevice = new Serial(PC_UART_TX_PIN, PC_UART_RX_PIN, PC_UART_BAUDRATE);

/*
 ******************************************************************************
 * Battery
 *-----------------------------------------------------------------------------
 */

//pin for reading the current voltage of the battery
//need solution to this. Battery ranges from 4.2V to 2V where the adc can only
//read to 3.3V (VDD)
//AnalogIn batteryV(BATTERY_V_PIN);

/*
 ******************************************************************************
 * Status LED
 *-----------------------------------------------------------------------------
 */

//flash when flash led is called, also iluminated when device boots successfully
DigitalOut status_led(STATUS_LED_PIN, 0);
//DigitalOut status_led1(PC_6, 0);


