#ifndef __MYSWIFT_PERIPH_H_
#define __MYSWIFT_PERIPH_H_


#include "mbed.h"
#include "adi_sense_api.h"
#include "JENKINS_AUTOGEN_PLATFORM.h"


#ifdef MYSWIFT
#define DEVICE_NAME "ADI MySwift"
#define FIRMWARE_VERSION "Version 1.0"
#endif


#ifdef PROSWIFT
#define DEVICE_NAME "ADI ProSwift"
#define FIRMWARE_VERSION "Version 1.0"
#endif


#if defined(MYSWIFT) && defined(PROSWIFT)
#error "Only one platform must be defined"
#endif


#if !(defined(MYSWIFT) || defined(PROSWIFT))
#error "At least one platform must be defined"
#endif

#define BL652

/*
 ******************************************************************************
 * ADISense1000
 *-----------------------------------------------------------------------------
 */

#ifdef MYSWIFT
#define SENSE_SPI_FREQUENCY  	2000000
#define SENSE_SPI_MOSI   	PA_7
#define SENSE_SPI_MISO    	PA_6
#define SENSE_SPI_SCK     	PA_5
#define SENSE_SPI_CS     	PC_7
//pin declarations
#define SENSE_RST_PIN     	PB_10
#define SENSE_ERROR_PIN     	PB_3 
#define SENSE_ALERT_PIN     	PB_5 
#define SENSE_DREADY_PIN 	PB_4
#endif


#ifdef PROSWIFT
//spi frequency
#define SENSE_SPI_FREQUENCY  	2000000
#define SENSE_SPI_MOSI   	SPI_MOSI
#define SENSE_SPI_MISO    	SPI_MISO
#define SENSE_SPI_SCK     	SPI_SCK
#define SENSE_SPI_CS     	SPI_CS
//pin declarations
#define SENSE_RST_PIN     	PB_10
#define SENSE_ERROR_PIN     	PB_3 
#define SENSE_ALERT_PIN     	PB_5 
#define SENSE_DREADY_PIN 	PB_4
#endif

/*
 ******************************************************************************
 * Bluetooth Low Energy
 *-----------------------------------------------------------------------------
 */

#ifdef BL652

#ifdef MYSWIFT
//pin declarations
#define BLE_RST_PIN     	PA_8
#define BLE_RTS_PIN     	PA_0
#define BLE_CTS_PIN     	PB_2
//uart pins and baudrate
#define BLE_BAUD_RATE 		115200
#define BLE_SERIAL_TX 		PA_2
#define BLE_SERIAL_RX 		PA_3
//mode pins
#define BLE_MODE_0_PIN 		PB_0
#define BLE_MODE_1_PIN		PA_1
#endif

#ifdef PROSWIFT
//pin declarations
#define BLE_RST_PIN     	PA_0
#define BLE_RTS_PIN     	PA_8
#define BLE_CTS_PIN     	PA_10
//uart pins and baudrate
#define BLE_BAUD_RATE 		115200
#define BLE_SERIAL_TX 		PA_2
#define BLE_SERIAL_RX 		PA_3
//mode pins
#define BLE_MODE_0_PIN 		PB_0
#define BLE_MODE_1_PIN		PA_4
#endif

#endif


/*
 ******************************************************************************
 * PC Serial
 *-----------------------------------------------------------------------------
 */

#ifdef MYSWIFT
#define PC_UART_TX_PIN   PA_9
#define PC_UART_RX_PIN   PA_10
#define PC_UART_BAUDRATE 921600
#endif


#ifdef PROSWIFT
#define PC_UART_TX_PIN   PA_11
#define PC_UART_RX_PIN   PA_12
#define PC_UART_BAUDRATE 115200
#endif

/*
 ******************************************************************************
 * Battery
 *-----------------------------------------------------------------------------
 */
#ifdef MYSWIFT
//#define VCC 				3.3
//#define BATTERY_V_PIN 		PH_0
#endif

/*
 ******************************************************************************
 * Status LED
 *-----------------------------------------------------------------------------
 */

#ifdef MYSWIFT
#define STATUS_LED_PIN 		PC_8
#endif

#ifdef PROSWIFT
#define STATUS_LED_PIN 		LED1
#endif
	 
#endif

/*
 ******************************************************************************
 * VIRT_EEPROM
 *-----------------------------------------------------------------------------
 */

#undef VIRT_EEPROM
