/*!
 ******************************************************************************
 * @file:   config.c
 * @brief:
 *-----------------------------------------------------------------------------
 *
Copyright (c) 2018 Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors
    manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner
    that would cause the software to become subject to terms and conditions
    which differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one
    or more patent holders.  This license does not release you from the
    requirement that you obtain separate licenses from these patent holders
    to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#include "inc/adi_sense_config_types.h"

ADI_SENSE_CONFIG adi_sense_config = {
    .versionId = { .major = 1, .minor = 4 },
    .productId = ADI_SENSE_PRODUCT_ID_1000,
    .adisense1000 = {
            .power = {
                .powerMode = ADI_SENSE_1000_POWER_MODE_FULL,
                .supplyVoltage = 3.3,
            },
            .measurement = {
                .operatingMode = ADI_SENSE_1000_OPERATING_MODE_CONTINUOUS,
                .dataReadyMode = ADI_SENSE_1000_DATAREADY_PER_CYCLE,
                .cycleInterval = 0,
            },
            .channels = {
                [ADI_SENSE_1000_CHANNEL_ID_CJC_0] = {
                    .enableChannel = true,
                    .disablePublishing = false,
                    .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                    .measurementsPerCycle = 1,
                    .extraSettlingTime = 0.0000,
                    .measurementUnit = ADI_SENSE_1000_MEASUREMENT_UNIT_CELSIUS,
                    .adcChannelConfig = {
                        .sensor = ADI_SENSE_1000_ADC_SENSOR_RTD_2WIRE_PT100_DEF_L1,
                        .gain = ADI_SENSE_1000_ADC_GAIN_32X,
                        .current = {
                            .outputLevel = ADI_SENSE_1000_ADC_EXC_CURRENT_500uA,
                            .swapOption = ADI_SENSE_1000_ADC_EXC_CURRENT_SWAP_NONE,
                        },
                        .filter = {
                            .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                            .fs = 0,
                            //.type = ADI_SENSE_1000_ADC_FILTER_SINC4,
                            //.fs = 1920,
                        },
                        .reference = {
                            .type = ADI_SENSE_1000_ADC_REFERENCE_RESISTOR_INTERNAL_1,
                            .disableBuffer = false,
                        },
                        .enableVbias = false,
                    },
                },
                [ADI_SENSE_1000_CHANNEL_ID_SENSOR_0] = {
                    .enableChannel = true,
                    .disablePublishing = false,
                    .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_CJC_0,
                    .measurementsPerCycle = 1,
                    .extraSettlingTime = 0.0000,
                    .measurementUnit = ADI_SENSE_1000_MEASUREMENT_UNIT_CELSIUS,
                    .adcChannelConfig = {
                        .sensor = ADI_SENSE_1000_ADC_SENSOR_THERMOCOUPLE_K_DEF_L1,
                        .gain = ADI_SENSE_1000_ADC_GAIN_128X,
                        .current = {
                            .outputLevel = ADI_SENSE_1000_ADC_EXC_CURRENT_NONE,
                            .swapOption = ADI_SENSE_1000_ADC_EXC_CURRENT_SWAP_NONE,
                        },
                        .filter = {
                            .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                            .fs = 0,
                            //.type = ADI_SENSE_1000_ADC_FILTER_SINC4,
                            //.fs = 1920,
                        },
                        .reference = {
                            .type = ADI_SENSE_1000_ADC_REFERENCE_VOLTAGE_INTERNAL,
                            .disableBuffer = false,
                        },
                        .enableVbias = true,
                    },
                },
                [ADI_SENSE_1000_CHANNEL_ID_I2C_0] = {
                    .enableChannel = true,
                    .disablePublishing = false,
                    .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                    .measurementsPerCycle = 1,
                    .extraSettlingTime = 0.0000,
                    .i2cChannelConfig = {
                        .sensor = ADI_SENSE_1000_I2C_SENSOR_HUMIDITY_SENSIRION_SHT3X,
                        .deviceAddress = 0x44,
                    },
                },
                [ADI_SENSE_1000_CHANNEL_ID_SPI_0] = {
                    /* Accelerometer X-Axis (and common settings for physical channel) */
                    .enableChannel = true,
                    .disablePublishing = false,
                    .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                    .measurementsPerCycle = 1,
                    .extraSettlingTime = 10,
                    .offsetAdjustment = -0.15,
                    /* Optional threshold limits applied to the processed measurement results */
                    .lowThreshold = -2.0,
                    .highThreshold = 2.0,
                    .spiChannelConfig = {
                    .sensor = ADI_SENSE_1000_SPI_SENSOR_ACCELEROMETER_ADI_ADXL362,
                    .configurationCommand = {
                        .command = { 0x0A, 0x2C, 0x03 }, /* +/-8G range */
                        .commandLength = 3,
                    },
                  },
                },
                [ADI_SENSE_1000_CHANNEL_ID_SPI_1] = {
                    /* Accelerometer Y-Axis (virtual channel) */
                    .enableChannel = true,
                    .offsetAdjustment = -0.15,
                    /* Optional threshold limits applied to the processed measurement results */
                    .lowThreshold = -2.0,
                    .highThreshold = 2.0,
                    .spiChannelConfig = {
                        .sensor = ADI_SENSE_1000_SPI_SENSOR_ACCELEROMETER_ADI_ADXL362,
                    },
                },
                [ADI_SENSE_1000_CHANNEL_ID_SPI_2] = {
                    /* Accelerometer Z-Axis (virtual channel) */
                    .enableChannel = true,
                    /* Optional adjustment applied to the PROCESSED OUTPUT value from the sensor */
                    .offsetAdjustment = -0.4,
                    /* Optional threshold limits applied to the processed measurement results */
                    .lowThreshold = -2,
                    .highThreshold = 2,
                    .spiChannelConfig = {
                        .sensor = ADI_SENSE_1000_SPI_SENSOR_ACCELEROMETER_ADI_ADXL362,
                    },
                },
            },
    },
};

