#ifndef __PC_SERIAL_H_
#define __PC_SERIAL_H_

#include "mbed.h"
#include "stdarg.h"
#include "inc/communications.h"

/*
    Definitions
*/

//size of buffers used
#define PC_BUFFER_SIZE 100

//uart pins and baudrate
#define PC_BAUD_RATE 115200
#define PC_SERIAL_TX PA_11
#define PC_SERIAL_RX PA_12

/*
    Function Prototypes
*/

//setup the callbck and vars necessary to read a pc json message
uint32_t Pc_SetupReadLineCb( char *rxBuffer, uint32_t maxSize, volatile bool *bMessageReadFlag );

//clear callback on pc serial handle
uint32_t Pc_ClearReadLineCb( void );

//read from pc
uint32_t Pc_Read( char *rxBuffer, uint32_t maxSize );

//wrapper for printf for general messages
uint32_t Pc_Write( const char* txBuffer, uint32_t size );

//wrapper for printf for error messages
uint32_t Pc_WriteError( const char* txBuffer, ... );

//wrapper for printf for debug messages
uint32_t Pc_WriteDebug( const char* txBuffer, ... );

#endif
