#ifndef __UTILS_H__
#define __UTILS_H__

#include "inc/adi_sense_api.h"
#include "inc/adi_sense_1000/adi_sense_1000_api.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Utility function to print the status read from the ADI Sense device */
void utils_printStatus(
    ADI_SENSE_STATUS *pStatus);

/* Utility function to print data samples read from the ADI Sense device */
void utils_printSamples(
    ADI_SENSE_DATA_SAMPLE *pSampleBuffer,
    uint32_t numSamples);
    
/* Alternative print utility */
void utils_printSamples_alt(
    ADI_SENSE_DATA_SAMPLE *pSampleBuffer,
    uint32_t numSamples);
    
/* Alternative print utility */
void utils_printSamples_pro(
    ADI_SENSE_DATA_SAMPLE *pSampleBuffer,
    uint32_t numSamples);
    
/* Utility function to register callbacks for ADI Sense device notification signals  */
ADI_SENSE_RESULT utils_registerCallbacks(
    ADI_SENSE_DEVICE_HANDLE hDevice,
    volatile bool_t *pbDataReady,
    volatile bool_t *pbError,
    volatile bool_t *pbAlert);

/* Utility function to de-register callbacks for ADI Sense device notification signals */
ADI_SENSE_RESULT utils_deregisterCallbacks(
    ADI_SENSE_DEVICE_HANDLE hDevice);

/* Utility function to run measurements on ADI Sense device, according to its current
 * configuration, and display data samples and device status following each cycle */
ADI_SENSE_RESULT utils_runMeasurement(
    ADI_SENSE_DEVICE_HANDLE hDevice,
    ADI_SENSE_MEASUREMENT_MODE eMeasurementMode);
 
/* Utility function to retrieve and print the factory calibration coefficients table from the ADI Sense device */
ADI_SENSE_RESULT utils_printCalTable(
    ADI_SENSE_DEVICE_HANDLE hDevice);

#ifdef __cplusplus
}
#endif

#endif /* __UTILS_H__ */

