
#include "myproswift_eval.h"


#include "mbed.h"
#include "pc_interface.h"
#include "ble_interface.h"
#include "myproswift_periph.h"


/***************************************************************
* Function Name: MyProSwift_Command
* Description  : read a command from either PC or BLE interfaces
*		and handle accordingly
****************************************************************/
int32_t MyProSwift_Command( bool bleActive )
{
	uint32_t ret = 0;
	//init buffers to 0x00
	char msgBuffer[MSG_BUFFER_MAX_SIZE] = {0x00};
	char bleBuffer[BLE_BUFFER_MAX_SIZE] = {0x00};
	
  	//setup callback routine for pc
  	volatile bool bPcMessageFlag = 0;
  	ret = Pc_SetupReadLineCb( msgBuffer, MSG_BUFFER_MAX_SIZE, &bPcMessageFlag );
	if( ret != 0 ) {
		return ret;
	}
  	
	//setup callback routine for ble
	volatile bool bBleMessageReceived = 0;
	if( bleActive ) {
	  //read first byte
	  ret = Bl652_SetupReadCb( bleBuffer, 1, &bBleMessageReceived );
	  if( ret != 0 ) {
	  	ADI_SENSE_LOG_INFO("Ble Message Read Unsuccesful!");
		  return ret;
	  }
	}
  	
  	//poll ble and pc flag
  	while( !bBleMessageReceived /*&& !bPcMessageFlag */ )
		;//add mbed abstracted sleep function
	
	//clear ble callbacks if needed
	if( bleActive ) {
	  ret = Bl652_ClearCb();
	  if( ret != 0 ) {
		  return ret;
	  }
	}
	
	//clear pc callbacks always
	ret = Pc_ClearReadLineCb();
	if( ret != 0 ) {
		return ret;
	}
	
  	//handle message based on which interface it was received from
	if( bBleMessageReceived ) {
		//parse and handle command
		ADI_SENSE_LOG_INFO("Ble Message Received!");
		ret = Ble_ParseCommand( bleBuffer );
		ADI_SENSE_LOG_INFO("Command Parsed!");
		if(ret != 0) {
			//all ble side error handled within function as responses
			return ret;
		}
	}
	
	else if(bPcMessageFlag) {
            //parse and handle command
		ret = Pc_ParseCommand( msgBuffer );
		if( ret != 0 ) {
			//all pc side error handled within function as responses
			return ret;
		}
	}
	
	return 0;
}