/*
 * ADISense1000 - Reset Device functions
 *
 * Author: Jake Greaves
 */
 
#include "inc/adisense1000_boot.h"

ADI_SENSE_DEVICE_HANDLE hDevice;

//connection information for initialising ADISense1000
extern ADI_SENSE_CONNECTION connectionInfo;

extern ADI_SENSE_CONFIG adi_sense_config;
extern ADI_SENSE_CONFIG adi_sense_config_eeprom;
//extern ADI_SENSE_DSP_LUT_RAW adi_sense_dsp_lut;

/***************************************************************
* Function Name: ADISense1000_Boot
* Description  : open the ADISense1000 and reset it,
                    loading default config
***************************************************************/
uint8_t Adisense1000_Boot(void)
{    
	bool_t bDeviceReady;
	ADI_SENSE_PRODUCT_ID productId;
	
	//Open an ADI Sense device instance.
	if(adi_sense_Open(0, &connectionInfo, &hDevice) != ADI_SENSE_SUCCESS)
	    return 1;
	
	//Reset the given ADI Sense device, and wait until the device is ready
	if(adi_sense_Reset(hDevice) != ADI_SENSE_SUCCESS)
	   return 1;
	
	
	//Wait until the device is ready.
	do {
	    wait_ms(100);
	    if(adi_sense_GetDeviceReadyState(hDevice, &bDeviceReady) != ADI_SENSE_SUCCESS)
		  return 1;
	} while (! bDeviceReady);
	
	/*
	 * Read the product ID from the device registers.
	 */
	if(adi_sense_GetProductID(hDevice, &productId) != ADI_SENSE_SUCCESS)
	    return 1;
		 
	//apply config
	if(adi_sense_SetConfig(hDevice, &adi_sense_config) != ADI_SENSE_SUCCESS)
	    return 1;
	//if(adi_sense_SetDspData(hDevice, &adi_sense_dsp_lut) == ADI_SENSE_SUCCESS);
	if(adi_sense_ApplyConfigUpdates(hDevice) != ADI_SENSE_SUCCESS)
	    return 1;

// Prototype for saving and reading from EEPROM
// Still needs testing
#ifdef VIRT_EEPROM
	//recall config from emulated eeprom
	//Unlock the Flash Program Erase controller
	HAL_FLASH_Unlock();
	
	//EEPROM Init
	//cleans up eeprom area and handles pages
	if(EE_Init() == EE_OK) {
		
		//flag to set if eeprom is currently valid
		uint16_t eepromConfigValid;
		
		//if read of flag is successful
		if((EE_ReadVariable(VirtAddVarTab[0], &eepromConfigValid)) == HAL_OK) {
			
			//if eeprom config is valid, read into working config struct
			//0xAF is generic flag
			if(eepromConfigValid == 0xAF) {
				//read eeprom to adisenseconfig
				uint16_t *p = (uint16_t*)&adi_sense_config_eeprom;
				int i = 0;
				
				//read back all bytes, on error, read is broken
				for(i = 0; i < sizeof(adi_sense_config_eeprom)/sizeof(uint16_t); i++, p++) {
					//read struct back, break on error
					if((EE_ReadVariable(VirtAddVarTab[1] + i, p)) != HAL_OK)
						break;
				}
				
				//if no error occurred and the config struct is complete
				if(i == sizeof(adi_sense_config_eeprom)/sizeof(uint16_t)) {
					//apply config
					if(adi_sense_SetConfig(hDevice, &adi_sense_config_eeprom) != ADI_SENSE_SUCCESS)
					    return 1;
					//if(adi_sense_SetDspData(hDevice, &adi_sense_dsp_lut) == ADI_SENSE_SUCCESS);
					if(adi_sense_ApplyConfigUpdates(hDevice) != ADI_SENSE_SUCCESS)
					    return 1;
				}
			}
		}
	}
	
	//Lock the Flash Program Erase controller
	HAL_FLASH_Lock();
	
#endif
	
	return 0;
}

