Porting Guide
=============
[ADI Sense Host Portability Layer](@ref ADI_Sense_Host) describes a portability
API layer which encapsulates the host platform-specific functions used by the
ADI Sense Host Library to communicate with the ADI Sense module.

Porting the ADI Sense Host Library to a new hardware platform and/or operating
system (OS) should involve replacing only the portability layer API functions
with a suitable implementation for the target platform.

A fully-functional communication interface implementation (i.e. @ref
ADI_Sense_Spi) is required, as is @ref ADI_Sense_Time which provides time-delay
functions for the ADI Sense Host Library.  However, other elements of the
portability layer, such as @ref ADI_Sense_Gpio and @ref ADI_Sense_Log, may be
substituted with dummy implementations if necessary (though some
[examples](doc/examples.md) may not function correctly as a result).

Source code for the ST Nucleo / mbed portability layer implementation is located
in the following sub-directory within the ADI Sense Host Library source package:

    <path_to_library>/host/src/mbed/

