/*
 * rcc_backup_registers.cpp - Interface functions for writing to back-up registers
 *
 * Author: Jake Greaves
 */
 
 
#include "rcc_backup_registers/rcc_backup_registers.h"


/***************************************************************
* Function Name: Rcc_ReadBackupReg
* Description  : read from BackupRegister and return its value
****************************************************************/
uint32_t Rcc_ReadBackupReg( uint32_t BackupRegister ) 
{
    RTC_HandleTypeDef RtcHandle;
    RtcHandle.Instance = RTC;
    return HAL_RTCEx_BKUPRead(&RtcHandle, BackupRegister);
}
 
/***************************************************************
* Function Name: Rcc_WriteBackupReg
* Description  : write data to BackupRegister
****************************************************************/
void Rcc_WriteBackupReg( uint32_t BackupRegister, uint32_t data ) 
{
    RTC_HandleTypeDef RtcHandle;
    RtcHandle.Instance = RTC;
    HAL_PWR_EnableBkUpAccess();
    HAL_RTCEx_BKUPWrite(&RtcHandle, BackupRegister, data);
    HAL_PWR_DisableBkUpAccess();
}

