/*!
 ******************************************************************************
 * @file:  adi_sense_1000_calibration.h
 * @brief: Constants defining a table of calibration constants for the device
 *-----------------------------------------------------------------------------
 *
Copyright 2017 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#ifndef __ADI_SENSE_1000_CALIBRATION_H__
#define __ADI_SENSE_1000_CALIBRATION_H__

#include "adi_sense_types.h"

typedef enum {
    ADI_SENSE_1000_CAL_INTERNAL_REFERENCE_ABSOLUTE_VALUE_CAL_COEFFICIENT,
    ADI_SENSE_1000_CAL_EXCITATION_CURRENT_MISMATCH_CAL_COEFFICIENT_1MA,
    ADI_SENSE_1000_CAL_EXCITATION_CURRENT_MISMATCH_CAL_COEFFICIENT_750UA,
    ADI_SENSE_1000_CAL_EXCITATION_CURRENT_MISMATCH_CAL_COEFFICIENT_500UA,
    ADI_SENSE_1000_CAL_EXCITATION_CURRENT_MISMATCH_CAL_COEFFICIENT_250UA,
    ADI_SENSE_1000_CAL_EXCITATION_CURRENT_MISMATCH_CAL_COEFFICIENT_100UA,
    ADI_SENSE_1000_CAL_EXCITATION_CURRENT_MISMATCH_CAL_COEFFICIENT_50UA,
    ADI_SENSE_1000_CAL_REFERENCE_RESISTER1_CAL_COEFFICIENT,
    ADI_SENSE_1000_CAL_REFERENCE_RESISTER2_CAL_COEFFICIENT,

    ADI_SENSE_1000_CAL_TC_TYPE_AFE_OFFSET_MEASURE0,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_GAIN_MEASURE0,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_OFFSET_MEASURE1,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_GAIN_MEASURE1,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_OFFSET_MEASURE2,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_GAIN_MEASURE2,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_OFFSET_MEASURE3,
    ADI_SENSE_1000_CAL_TC_TYPE_AFE_GAIN_MEASURE3,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_OFFSET_MEASURE0,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_GAIN_MEASURE0,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_OFFSET_MEASURE1,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_GAIN_MEASURE1,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_OFFSET_MEASURE2,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_GAIN_MEASURE2,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_OFFSET_MEASURE3,
    ADI_SENSE_1000_CAL_RTD_4_WIRE_TYPE_AFE_GAIN_MEASURE3,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_OFFSET_MEASURE0,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_GAIN_MEASURE0,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_OFFSET_MEASURE1,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_GAIN_MEASURE1,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_OFFSET_MEASURE2,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_GAIN_MEASURE2,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_OFFSET_MEASURE3,
    ADI_SENSE_1000_CAL_RTD_3_WIRE_TYPE_AFE_GAIN_MEASURE3,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_OFFSET_MEASURE_CJC0,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_GAIN_MEASURE_CJC0,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_OFFSET_MEASURE_CJC1,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_GAIN_MEASURE_CJC1,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_OFFSET_MEASURE0,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_GAIN_MEASURE0,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_OFFSET_MEASURE1,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_GAIN_MEASURE1,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_OFFSET_MEASURE2,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_GAIN_MEASURE2,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_OFFSET_MEASURE3,
    ADI_SENSE_1000_CAL_RTD_2_WIRE_TYPE_AFE_GAIN_MEASURE3,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_OFFSET_MEASURE0,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_GAIN_MEASURE0,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_OFFSET_MEASURE1,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_GAIN_MEASURE1,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_OFFSET_MEASURE2,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_GAIN_MEASURE2,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_OFFSET_MEASURE3,
    ADI_SENSE_1000_CAL_10K_THERMISTOR_TYPE_AFE_GAIN_MEASURE3,
    ADI_SENSE_1000_CAL_I_CHANNEL_TYPE_AFE_OFFSET,
    ADI_SENSE_1000_CAL_I_CHANNEL_TYPE_AFE_GAIN,
    ADI_SENSE_1000_CAL_V_CHANNEL_TYPE_AFE_OFFSET,
    ADI_SENSE_1000_CAL_V_CHANNEL_TYPE_AFE_GAIN,

    ADI_SENSE_1000_CAL_NUM_TABLES, /**< Counter of the enum */
    ADI_SENSE_1000_CAL_NOT_VALID
} ADI_SENSE_1000_CAL_CONSTANTS;


typedef enum {
    ADI_SENSE_1000_CAL_TEMP_P25,
    ADI_SENSE_1000_CAL_TEMP_M40,
    ADI_SENSE_1000_CAL_TEMP_P85,
    ADI_SENSE_1000_CAL_NUM_TEMPS, /**< Counter of the enum */
} ADI_SENSE_1000_CAL_TEMP;

#endif /* __ADI_SENSE_1000_CALIBRATION_H__ */

