/*
 * communications.cpp - low level communications wrapper for mbed
 *
 * Author: Jake Greaves
 */

#include "communications.h"

//spi callback flags
static volatile int intType;
static volatile bool spiCallbackFlag;
static event_callback_t callbck;


/***************************************************************
* Function Name: uart_Init
* Description  : init for serialHandle
****************************************************************/
int Uart_Init( Serial &serialHandle, uint32_t baudrate )
{
    //set baudrate
    serialHandle.baud( baudrate );

    return 0;
}

/***************************************************************
* Function Name: uart_Write
* Description  : write a string to a serial device
****************************************************************/
int Uart_Write( Serial &serialHandle, const char* txBuffer, unsigned int length )
{

    for(unsigned int i = 0; i < length; i++) {
    	//print to serial device
   	serialHandle.putc( txBuffer[i] );
    }

    return 0;
}

/***************************************************************
* Function Name: uart_read_cb
* Description  : Read from a serial device using a callback
****************************************************************/
int Uart_ReadCb( Serial &serialHandle, void ( *callback )( void ) )
{
    //attach callback
    serialHandle.attach( callback );

    return 0;
}

/***************************************************************
* Function Name: uart_clear_cb
* Description  : clear callback
****************************************************************/
int Uart_ClearCb( Serial &serialHandle )
{
    //attach callback
    serialHandle.attach( NULL );

    return 0;
}
