#ifndef __COMMUNICATIONS_H_
#define __COMMUNICATIONS_H_

#include "mbed.h"

/*
    Definitions
*/

#define TIMEOUT_3_SEC 3.0f

/*
    Function Prototypes
*/

//init a uart handle
int Uart_Init( Serial &serialHandle, int baudrate );

//write to serial comms using comms handle
int Uart_Write( Serial &serialHandle, const char* txBuffer, unsigned int length );

//read from serial comms using comms handle
int Uart_ReadCb( Serial &serialHandle, void ( *callback )( void ) );

//clear attached callback
int Uart_ClearCb( Serial &serialHandle );

#endif
