/*
 ******************************************************************************
 * file:   main.cpp
 *-----------------------------------------------------------------------------
 *
Copyright 2017 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/
#include "mbed.h"
#include "inc/adi_sense_api.h"
#include "inc/adi_sense_log.h"
#include "common/utils.h"

extern ADI_SENSE_CONFIG config;

ADI_SENSE_RESULT res;
ADI_SENSE_DEVICE_HANDLE hDevice;
ADI_SENSE_MEASUREMENT_MODE eMeasurementMode = ADI_SENSE_MEASUREMENT_MODE_NORMAL;
bool_t bDeviceReady;

/* Change the following pointer to select any of the configurations above */
static ADI_SENSE_CONFIG *pSelectedConfig = &config;

static ADI_SENSE_CONNECTION connectionInfo = {
    .type = ADI_SENSE_CONNECTION_TYPE_SPI,
    .spi = {
        .mosiPin    = SPI_MOSI,
        .misoPin    = SPI_MISO,
        .sckPin     = SPI_SCK,
        .csPin      = D10,
        .maxSpeedHz = 2000000,
    },
    .gpio = {
        .resetPin     = D6,
        .errorPin     = D3,
        .alertPin     = D4,
        .datareadyPin = D5,
    },
};

uint8_t adisense1000_boot(void)
{
   bool_t bDeviceReady;

    res = adi_sense_Open(0, &connectionInfo, &hDevice);
    if (res != ADI_SENSE_SUCCESS)
    {
        ADI_SENSE_LOG_ERROR("Failed to open device instance");
        return res;
    }

    ADI_SENSE_LOG_INFO("Resetting ADI Sense device, please wait...");
    res = adi_sense_Reset(hDevice);
    if (res != ADI_SENSE_SUCCESS)
    {
        ADI_SENSE_LOG_ERROR("Failed to reset device");
        return res;
    }

    do {
        wait_ms(100);
        res = adi_sense_GetDeviceReadyState(hDevice, &bDeviceReady);
        if (res != ADI_SENSE_SUCCESS)
        {
            ADI_SENSE_LOG_ERROR("Failed to get device ready-state");
            return res;
        }
    } while (! bDeviceReady);
    ADI_SENSE_LOG_INFO("ADI Sense device ready");

    ADI_SENSE_LOG_INFO("Setting device configuration");
    res = adi_sense_SetConfig(hDevice, pSelectedConfig);
    if (res != ADI_SENSE_SUCCESS)
    {
        ADI_SENSE_LOG_ERROR("Failed to set device configuration");
        return res;
    }
    res = adi_sense_ApplyConfigUpdates(hDevice);
    if (res != ADI_SENSE_SUCCESS)
    {
        ADI_SENSE_LOG_ERROR("Failed to apply device configuration");
        return res;
    }
    return 0;
}

void blink_led()
{
    DigitalOut led1(LED1);
    int i=0;
    for(i=0; i<10; i++) {
        led1 = !led1;
        wait(0.5);
    }
}

int main()
{
    wait(0.5);
    blink_led();
    
    adisense1000_boot();
    ADI_SENSE_LOG_INFO("Configuration Set Success");
    wait(0.5);
    
    ADI_SENSE_LOG_INFO("~ Get Data\n\r");
    
    //temp_comp temp pressure himidity AccX AccY AccZ
    
    ADI_SENSE_LOG_INFO("tc_raw\ttc_pro\tt_raw\tt_pro\tp_raw\tp_pro\th_raw\th_pro\tax_raw\tax_pro\tay_raw\tay_pro\taz_raw\taz_pro");
    //ADI_SENSE_LOG_INFO("tc_pro t_pro h_pro ax_pro ay_pro az_pro");
    
    utils_runMeasurement(hDevice, eMeasurementMode);
    
}

