/*
Copyright 2017 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

/*!
 ******************************************************************************
 * @file:
 * @brief:
 *-----------------------------------------------------------------------------
 */
#include "adi_sense_config_types.h"

ADI_SENSE_CONFIG sensor2_bridge_6w_pressure_config = {
    .versionId = { .major = 1, .minor = 4 },
    .productId = ADI_SENSE_PRODUCT_ID_1000,
    .adisense1000 = {
        .power = {
            .powerMode = ADI_SENSE_1000_POWER_MODE_FULL,
        },
        .measurement = {
            .operatingMode = ADI_SENSE_1000_OPERATING_MODE_CONTINUOUS,
            .dataReadyMode = ADI_SENSE_1000_DATAREADY_PER_CYCLE,
        },
        .channels = {
            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_2] = {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig = {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter = {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                    },
                    .reference = {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                    },
                    .enableVbias = false,
                },
            },
        },
    },
};

