/*
 * File: sample_lut_data.c
 * The following example illustrates how individual tables can be declared, and
 * later assembled into a complete LUT data structure using adi_sense_1000_AssembleLutData().
 * That LUT data structure can then be written to the ADI Sense 1000 device 
 * using adi_sense_1000_SetLutData().
 */

#include "adi_sense_1000_lut_data.h"
#include "adi_sense_1000_sensor_types.h"

/*
 * The following table provide linearisation data for a 4-wire bridge sensor
 * identified with the ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2
 * sensor type.  The Look-Up Table provided maps a range of input (X)
 * values to a corresponding range of output (Y) values.  In this example,
 * the bridge sensor input in millivolts is effectively translated to volts.
 */

ADI_SENSE_1000_LUT_DESCRIPTOR bridge_4wire_1_def_l2_range1_desc = 
{
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};

ADI_SENSE_1000_LUT_1D_NES bridge_4wire_1_def_l2_range1_data = 
{
    .nElements = 2,
    .lut = 
    {
        -3300.0f, /* x(min) */
        +3300.0f, /* x(max) */
        -3300.0f,    /* y(min) */
        +3300.0f,    /* y(max) */
    },
};

/*
 * The following variables can be passed as parameters to
 * adi_sense_1000_AssembleLutData()
 */
ADI_SENSE_1000_LUT_DESCRIPTOR *sample_lut_desc_list[] = 
{

    &bridge_4wire_1_def_l2_range1_desc,
    
};

ADI_SENSE_1000_LUT_TABLE_DATA *sample_lut_data_list[] = 
{
    
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &bridge_4wire_1_def_l2_range1_data,
    
};

unsigned sample_lut_num_tables =
    (sizeof(sample_lut_desc_list) / sizeof(sample_lut_desc_list[0]));

