Examples
========

[TOC]

# Overview {#overview}

# Getting Started {#getting_started}

## ST Nucleo F411RE / Mbed OS {#stnucleo_mbed}

### Hardware Setup

The following examples assume that the ADI Sense 1000 module is connected to the
ST Nucleo FR11RE as follows:

ADI Sense 1000    | ST Nucleo FR11RE
---------------   | -------------
SPI\_SLAVE\_CS    | D10
SPI\_SLAVE\_MOSI  | D11
SPI\_SLAVE\_MISO  | D12
RESET             | D6
ERROR             | D3
ALERT             | D4
DRDY              | D5

### Software Setup

### Building an example

#### Using mbed online tools
An mbed online account is required.  For more information,
see (https://developer.mbed.org/account/signup/).

Once logged into mbed, visit the following URL to locate the ADI Sense Host Library repository:
(https://os.mbed.com/teams/AnalogDevices/code/AdiSense1000)

Select the "Import into Compiler" option to add this library to your project.

Navigate to one of the examples (e.g. AdiSense1000/examples/sensors/) and click
to open the source file named 'main.cpp'.  Then click on compile at the top of
the page to build the binary image. This will download the binary to your PC.

#### Using mbed-cli (command line interface) tools
Follow the instructions at (https://github.com/ARMmbed/mbed-cli) to download and
install the mbed-cli.

In a command-line terminal window, navigate to the directory containing one of
the examples included in the ADI Sense Host Library software package, set up the
mbed-os environment, and build the code:

    cd <path_to_library>/examples/sensors/
    mbed deploy
    mbed new .
    mbed compile -m nucleo_f411re -t GCC_ARM

The resulting binary image will be created as:

    <path_to_library>/examples/sensors/BUILD/nucleo_f411re/GCC_ARM/sensors.bin

### Running an example
Assuming the Nucleo board is plugged in to your PC via a micro-USB cable, copy
the binary image (built in the previous step) to the "NODE_F411RE" USB storage
device.  The programming LED on the F411RE should flash for a few seconds while
the program is being loaded, and the device should then automatically reboot
and start running the example.

Output messages from the example are transmitted on UART6 (pins PA\_11, PA\_12)
by default.  This pins may be routed via the micro-USB cable COM/serial
by connecting PA\_11 and PA\_12 to the RX and TX pins on CN3 of the F411RE board.
Alternatively, it is possible to specify a different UART by modifying the
following file and rebuilding the example:

    <path_to_library>/host/src/mbed/adi_sense_log.cpp

# API Usage Examples {#api_examples}
The following examples are intended to demonstrate the correct usage of the [ADI Sense API](@ref ADI_Sense_Api) in a variety of scenarios and configurations.

## Sensors {#api_examples_sensors}
The "sensors" example demonstrates configurations that may be used to enable a
selection of analog and digital sensors which may be connected to the ADI Sense
1000 module and used in various modes of operation.  Different configurations
may be selected by modifying the value of 'pSelectedConfig' in main.cpp.  The
example application code will show how the selected configuration is loaded to
the ADI Sense 1000 device and applied before measurement cycles are started.

## User-Defined Look-Up Table Data {#api_examples_user_lut_data}
The "user_lut_data" example aims to show how a user may specify sensor
correction data to linearise the raw results from a custom sensor (a
thermocouple and bridge sensor in this case).  The data is encapsulated in a
series of individual tables and corresponding descriptors
(see 'sample\_lut\_data.c') which are assembled into a single monolithic Look-Up
Table (LUT) data structure.  That LUT data structure is loaded onto the ADI
Sense 1000 module and applied as part of the module configuration before any
measurement cycles are started.

## Save/Restore Configuration {#api_examples_save_restore}
The "save_restore_config" example demonstrates how configuration settings may be
saved to non-volatile memory on the ADI Sense module.  Saved settings are loaded
automatically when the module is subsequently powered on, and may also be
loaded (restored) at any time by the user if required.  Note that settings must
always be applied explicitly with @ref adi_sense_ApplyConfigUpdates before they
take effect.

## Diagnostics {#api_examples_diagnostics}
The "diagnostics" example demonstrates how some of the various diagnostic
functions of the ADI Sense module can be utilised to detect error conditions
such as disconnected or mis-wired sensors.

