/* ================================================================================
 
     Created by   : sherry
     Created on   : 2017 Nov 14, 10:55 GMT

     Project      :   ADISENSE1000_REGISTERS
     File         :   ADISENSE1000_REGISTERS.h
     Description  :   Register Definitions

     !! ADI Confidential !!
       INTERNAL USE ONLY

     Copyright (c) 2017 Analog Devices, Inc.  All Rights Reserved.
     This software is proprietary and confidential to Analog Devices, Inc. and
     its licensors.

     This file was auto-generated. Do not make local changes to this file.
 
     Auto generation script information:
       Script:        /usr/cadtools/bin/yoda.dir/generators/inc/genHeaders
       Last modified: 26-SEP-2017

   ================================================================================ */

#ifndef _DEF_ADISENSE1000_REGISTERS_H
#define _DEF_ADISENSE1000_REGISTERS_H

#if defined(_LANGUAGE_C) || (defined(__GNUC__) && !defined(__ASSEMBLER__))
#include <stdint.h>
#endif /* _LANGUAGE_C */

#ifndef __ADI_GENERATED_DEF_HEADERS__
#define __ADI_GENERATED_DEF_HEADERS__    1
#endif

#define __ADI_HAS_ADISENSE_CORE__  1
#define __ADI_HAS_ADISENSE_SPI__   1
#define __ADI_HAS_ADISENSE_TEST__  1

/* ============================================================================================================================
        
   ============================================================================================================================ */

/* ============================================================================================================================
        ADISENSE_SPI
   ============================================================================================================================ */
#define MOD_ADISENSE_SPI_BASE                0x00000000            /*    */
#define MOD_ADISENSE_SPI_MASK                0x00007FFF            /*    */
#define REG_ADISENSE_SPI_INTERFACE_CONFIG_A_RESET 0x00000030            /*      Reset Value for Interface_Config_A  */
#define REG_ADISENSE_SPI_INTERFACE_CONFIG_A  0x00000000            /*  ADISENSE_SPI Interface Configuration A */
#define REG_ADISENSE_SPI_INTERFACE_CONFIG_B_RESET 0x00000000            /*      Reset Value for Interface_Config_B  */
#define REG_ADISENSE_SPI_INTERFACE_CONFIG_B  0x00000001            /*  ADISENSE_SPI Interface Configuration B */
#define REG_ADISENSE_SPI_DEVICE_CONFIG_RESET 0x00000000            /*      Reset Value for Device_Config  */
#define REG_ADISENSE_SPI_DEVICE_CONFIG       0x00000002            /*  ADISENSE_SPI Device Configuration */
#define REG_ADISENSE_SPI_CHIP_TYPE_RESET     0x00000007            /*      Reset Value for Chip_Type  */
#define REG_ADISENSE_SPI_CHIP_TYPE           0x00000003            /*  ADISENSE_SPI Chip Type */
#define REG_ADISENSE_SPI_PRODUCT_ID_L_RESET  0x00000020            /*      Reset Value for Product_ID_L  */
#define REG_ADISENSE_SPI_PRODUCT_ID_L        0x00000004            /*  ADISENSE_SPI Product ID Low */
#define REG_ADISENSE_SPI_PRODUCT_ID_H_RESET  0x00000000            /*      Reset Value for Product_ID_H  */
#define REG_ADISENSE_SPI_PRODUCT_ID_H        0x00000005            /*  ADISENSE_SPI Product ID High */
#define REG_ADISENSE_SPI_CHIP_GRADE_RESET    0x00000000            /*      Reset Value for Chip_Grade  */
#define REG_ADISENSE_SPI_CHIP_GRADE          0x00000006            /*  ADISENSE_SPI Chip Grade */
#define REG_ADISENSE_SPI_SCRATCH_PAD_RESET   0x00000000            /*      Reset Value for Scratch_Pad  */
#define REG_ADISENSE_SPI_SCRATCH_PAD         0x0000000A            /*  ADISENSE_SPI Scratch Pad */
#define REG_ADISENSE_SPI_SPI_REVISION_RESET  0x00000082            /*      Reset Value for SPI_Revision  */
#define REG_ADISENSE_SPI_SPI_REVISION        0x0000000B            /*  ADISENSE_SPI SPI Revision */
#define REG_ADISENSE_SPI_VENDOR_L_RESET      0x00000056            /*      Reset Value for Vendor_L  */
#define REG_ADISENSE_SPI_VENDOR_L            0x0000000C            /*  ADISENSE_SPI Vendor ID Low */
#define REG_ADISENSE_SPI_VENDOR_H_RESET      0x00000004            /*      Reset Value for Vendor_H  */
#define REG_ADISENSE_SPI_VENDOR_H            0x0000000D            /*  ADISENSE_SPI Vendor ID High */
#define REG_ADISENSE_SPI_STREAM_MODE_RESET   0x00000000            /*      Reset Value for Stream_Mode  */
#define REG_ADISENSE_SPI_STREAM_MODE         0x0000000E            /*  ADISENSE_SPI Stream Mode */
#define REG_ADISENSE_SPI_TRANSFER_CONFIG_RESET 0x00000000            /*      Reset Value for Transfer_Config  */
#define REG_ADISENSE_SPI_TRANSFER_CONFIG     0x0000000F            /*  ADISENSE_SPI Transfer Config */
#define REG_ADISENSE_SPI_INTERFACE_CONFIG_C_RESET 0x00000033            /*      Reset Value for Interface_Config_C  */
#define REG_ADISENSE_SPI_INTERFACE_CONFIG_C  0x00000010            /*  ADISENSE_SPI Interface Configuration C */
#define REG_ADISENSE_SPI_INTERFACE_STATUS_A_RESET 0x00000000            /*      Reset Value for Interface_Status_A  */
#define REG_ADISENSE_SPI_INTERFACE_STATUS_A  0x00000011            /*  ADISENSE_SPI Interface Status A */

/* ============================================================================================================================
        ADISENSE_SPI Register BitMasks, Positions & Enumerations 
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_INTERFACE_CONFIG_A      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_A_SW_RESET  7            /*  First of Two of SW_RESET Bits. */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_A_ADDR_ASCENSION  5            /*  Determines Sequential Addressing Behavior */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_A_SDO_ENABLE  4            /*  SDO Pin Enable */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_A_SW_RESETX  0            /*  Second  of Two of SW_RESET Bits. */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_A_SW_RESET 0x00000080    /*  First of Two of SW_RESET Bits. */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_A_ADDR_ASCENSION 0x00000020    /*  Determines Sequential Addressing Behavior */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_A_SDO_ENABLE 0x00000010    /*  SDO Pin Enable */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_A_SW_RESETX 0x00000001    /*  Second  of Two of SW_RESET Bits. */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_A_DESCEND 0x00000000            /*  Addr_Ascension: Address accessed is decremented by one for each data byte when streaming */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_A_ASCEND 0x00000020            /*  Addr_Ascension: Address accessed is incremented by one for each data byte when streaming */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_INTERFACE_CONFIG_B      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_B_SINGLE_INST  7            /*  Select Streaming or Single Instruction Mode */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_B_SINGLE_INST 0x00000080    /*  Select Streaming or Single Instruction Mode */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_B_STREAMING_MODE 0x00000000            /*  Single_Inst: Streaming mode is enabled */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_B_SINGLE_INSTRUCTION_MODE 0x00000080            /*  Single_Inst: Single Instruction mode is enabled */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_DEVICE_CONFIG           Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_DEVICE_CONFIG_OPERATING_MODES  0            /*  Power Modes */
#define BITM_ADISENSE_SPI_DEVICE_CONFIG_OPERATING_MODES 0x00000003    /*  Power Modes */
#define ENUM_ADISENSE_SPI_DEVICE_CONFIG_NORMAL 0x00000000            /*  Operating_Modes: Normal Operating Mode */
#define ENUM_ADISENSE_SPI_DEVICE_CONFIG_SLEEP 0x00000003            /*  Operating_Modes: Low Power Mode */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_CHIP_TYPE               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_CHIP_TYPE_CHIP_TYPE  0            /*  Precision ADC */
#define BITM_ADISENSE_SPI_CHIP_TYPE_CHIP_TYPE 0x0000000F    /*  Precision ADC */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_PRODUCT_ID_L            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_PRODUCT_ID_L_PRODUCT_ID_FIXED_BITS  4            /*  These Bits are Fixed on Die Configured for Multiple Generics */
#define BITP_ADISENSE_SPI_PRODUCT_ID_L_PRODUCT_ID_TRIM_BITS  0            /*  These Bits Vary on Die Configured for Multiple Generics */
#define BITM_ADISENSE_SPI_PRODUCT_ID_L_PRODUCT_ID_FIXED_BITS 0x000000F0    /*  These Bits are Fixed on Die Configured for Multiple Generics */
#define BITM_ADISENSE_SPI_PRODUCT_ID_L_PRODUCT_ID_TRIM_BITS 0x0000000F    /*  These Bits Vary on Die Configured for Multiple Generics */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_PRODUCT_ID_H            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_PRODUCT_ID_H_PRODUCT_ID_FIXED_BITS  0            /*  These Bits are Fixed on Die Configured for Multiple Generics */
#define BITM_ADISENSE_SPI_PRODUCT_ID_H_PRODUCT_ID_FIXED_BITS 0x000000FF    /*  These Bits are Fixed on Die Configured for Multiple Generics */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_CHIP_GRADE              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_CHIP_GRADE_GRADE    4            /*  This is the Device Performance Grade */
#define BITP_ADISENSE_SPI_CHIP_GRADE_DEVICE_REVISION  0            /*  This is the Device Hardware Revision */
#define BITM_ADISENSE_SPI_CHIP_GRADE_GRADE   0x000000F0    /*  This is the Device Performance Grade */
#define BITM_ADISENSE_SPI_CHIP_GRADE_DEVICE_REVISION 0x0000000F    /*  This is the Device Hardware Revision */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_SCRATCH_PAD             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_SCRATCH_PAD_SCRATCH_VALUE  0            /*  Software Scratchpad */
#define BITM_ADISENSE_SPI_SCRATCH_PAD_SCRATCH_VALUE 0x000000FF    /*  Software Scratchpad */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_SPI_REVISION            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_SPI_REVISION_SPI_TYPE  6            /*  Always Reads as 0x2 */
#define BITP_ADISENSE_SPI_SPI_REVISION_VERSION  0            /*  SPI Version */
#define BITM_ADISENSE_SPI_SPI_REVISION_SPI_TYPE 0x000000C0    /*  Always Reads as 0x2 */
#define BITM_ADISENSE_SPI_SPI_REVISION_VERSION 0x0000003F    /*  SPI Version */
#define ENUM_ADISENSE_SPI_SPI_REVISION_ADI_SPI 0x00000000
#define ENUM_ADISENSE_SPI_SPI_REVISION_LPT_SPI 0x00000080
#define ENUM_ADISENSE_SPI_SPI_REVISION_REV1_0 0x00000002            /*  Version: Revision 1.0 */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_VENDOR_L                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_VENDOR_L_VID        0            /*  Analog Devices Vendor ID */
#define BITM_ADISENSE_SPI_VENDOR_L_VID       0x000000FF    /*  Analog Devices Vendor ID */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_VENDOR_H                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_VENDOR_H_VID        0            /*  Analog Devices Vendor ID */
#define BITM_ADISENSE_SPI_VENDOR_H_VID       0x000000FF    /*  Analog Devices Vendor ID */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_STREAM_MODE             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_STREAM_MODE_LOOP_COUNT  0            /*  Sets the Data Byte Count Before Looping to Start Address */
#define BITM_ADISENSE_SPI_STREAM_MODE_LOOP_COUNT 0x000000FF    /*  Sets the Data Byte Count Before Looping to Start Address */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_TRANSFER_CONFIG         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_TRANSFER_CONFIG_STREAM_MODE  1            /*  When Streaming, Controls Master-Slave Transfer */
#define BITM_ADISENSE_SPI_TRANSFER_CONFIG_STREAM_MODE 0x00000002    /*  When Streaming, Controls Master-Slave Transfer */
#define ENUM_ADISENSE_SPI_TRANSFER_CONFIG_UPDATE_ON_WRITE 0x00000000            /*  Stream_Mode: Transfers after each byte/mulit-byte register */
#define ENUM_ADISENSE_SPI_TRANSFER_CONFIG_UPDATE_ON_ADDRESS_LOOP 0x00000002            /*  Stream_Mode: Transfers when address loops */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_INTERFACE_CONFIG_C      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_C_CRC_ENABLE  6            /*  CRC Enable */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_C_STRICT_REGISTER_ACCESS  5            /*  Multi-byte Registers Must Be Read/Written in Full */
#define BITP_ADISENSE_SPI_INTERFACE_CONFIG_C_CRC_ENABLEB  0            /*  Inverted CRC Enable */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_C_CRC_ENABLE 0x000000C0    /*  CRC Enable */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_C_STRICT_REGISTER_ACCESS 0x00000020    /*  Multi-byte Registers Must Be Read/Written in Full */
#define BITM_ADISENSE_SPI_INTERFACE_CONFIG_C_CRC_ENABLEB 0x00000003    /*  Inverted CRC Enable */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_C_DISABLED 0x00000000            /*  CRC_Enable: CRC Disabled */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_C_ENABLED 0x00000040            /*  CRC_Enable: CRC Enabled */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_C_NORMAL_ACCESS 0x00000000            /*  Strict_Register_Access: Normal mode, no access restrictions */
#define ENUM_ADISENSE_SPI_INTERFACE_CONFIG_C_STRICT_ACCESS 0x00000020            /*  Strict_Register_Access: Strict mode, multi-byte registers require all bytes read/written */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_SPI_INTERFACE_STATUS_A      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_SPI_INTERFACE_STATUS_A_NOT_READY_ERROR  7            /*  Device Not Ready for Transaction */
#define BITP_ADISENSE_SPI_INTERFACE_STATUS_A_CLOCK_COUNT_ERROR  4            /*  Incorrect Number of Clocks Detected in a Transaction */
#define BITP_ADISENSE_SPI_INTERFACE_STATUS_A_CRC_ERROR  3            /*  Invalid/No CRC Received */
#define BITP_ADISENSE_SPI_INTERFACE_STATUS_A_WR_TO_RD_ONLY_REG_ERROR  2            /*  Write to Read-Only Register Attempted */
#define BITP_ADISENSE_SPI_INTERFACE_STATUS_A_REGISTER_PARTIAL_ACCESS_ERROR  1            /*  Set When Fewer Than Expected Number of Bytes Read/Written */
#define BITP_ADISENSE_SPI_INTERFACE_STATUS_A_ADDRESS_INVALID_ERROR  0            /*  Attempt to Read/Write Non-existent Register Address */
#define BITM_ADISENSE_SPI_INTERFACE_STATUS_A_NOT_READY_ERROR 0x00000080    /*  Device Not Ready for Transaction */
#define BITM_ADISENSE_SPI_INTERFACE_STATUS_A_CLOCK_COUNT_ERROR 0x00000010    /*  Incorrect Number of Clocks Detected in a Transaction */
#define BITM_ADISENSE_SPI_INTERFACE_STATUS_A_CRC_ERROR 0x00000008    /*  Invalid/No CRC Received */
#define BITM_ADISENSE_SPI_INTERFACE_STATUS_A_WR_TO_RD_ONLY_REG_ERROR 0x00000004    /*  Write to Read-Only Register Attempted */
#define BITM_ADISENSE_SPI_INTERFACE_STATUS_A_REGISTER_PARTIAL_ACCESS_ERROR 0x00000002    /*  Set When Fewer Than Expected Number of Bytes Read/Written */
#define BITM_ADISENSE_SPI_INTERFACE_STATUS_A_ADDRESS_INVALID_ERROR 0x00000001    /*  Attempt to Read/Write Non-existent Register Address */


/* ============================================================================================================================
        ADISENSE1000 Core Registers
   ============================================================================================================================ */

/* ============================================================================================================================
        ADISENSE_CORE
   ============================================================================================================================ */
#define MOD_ADISENSE_CORE_BASE               0x00000010            /*  ADISENSE1000 Core Registers  */
#define MOD_ADISENSE_CORE_MASK               0x00007FFF            /*  ADISENSE1000 Core Registers  */
#define REG_ADISENSE_CORE_COMMAND_RESET      0x00000000            /*      Reset Value for Command  */
#define REG_ADISENSE_CORE_COMMAND            0x00000014            /*  ADISENSE_CORE Special Command */
#define REG_ADISENSE_CORE_MODE_RESET         0x00000000            /*      Reset Value for Mode  */
#define REG_ADISENSE_CORE_MODE               0x00000016            /*  ADISENSE_CORE Operating Mode and DRDY Control */
#define REG_ADISENSE_CORE_POWER_CONFIG_RESET 0x00000000            /*      Reset Value for Power_Config  */
#define REG_ADISENSE_CORE_POWER_CONFIG       0x00000017            /*  ADISENSE_CORE General Configuration */
#define REG_ADISENSE_CORE_CYCLE_CONTROL_RESET 0x00000000            /*      Reset Value for Cycle_Control  */
#define REG_ADISENSE_CORE_CYCLE_CONTROL      0x00000018            /*  ADISENSE_CORE Measurement Cycle */
#define REG_ADISENSE_CORE_FIFO_NUM_CYCLES_RESET 0x00000001            /*      Reset Value for Fifo_Num_Cycles  */
#define REG_ADISENSE_CORE_FIFO_NUM_CYCLES    0x0000001A            /*  ADISENSE_CORE Number of Measurement Cycles to Store in FIFO */
#define REG_ADISENSE_CORE_MULTI_CYCLE_REPEAT_INTERVAL_RESET 0x00000000            /*      Reset Value for Multi_Cycle_Repeat_Interval  */
#define REG_ADISENSE_CORE_MULTI_CYCLE_REPEAT_INTERVAL 0x0000001C            /*  ADISENSE_CORE Time Between Repeats of Multi-Cycle Conversions.... */
#define REG_ADISENSE_CORE_STATUS_RESET       0x00000000            /*      Reset Value for Status  */
#define REG_ADISENSE_CORE_STATUS             0x00000020            /*  ADISENSE_CORE General Status */
#define REG_ADISENSE_CORE_DIAGNOSTICS_STATUS_RESET 0x00000000            /*      Reset Value for Diagnostics_Status  */
#define REG_ADISENSE_CORE_DIAGNOSTICS_STATUS 0x00000024            /*  ADISENSE_CORE Diagnostics Status */
#define REG_ADISENSE_CORE_CHANNEL_ALERT_STATUS_RESET 0x00000000            /*      Reset Value for Channel_Alert_Status  */
#define REG_ADISENSE_CORE_CHANNEL_ALERT_STATUS 0x00000026            /*  ADISENSE_CORE Alert Status Summary */
#define REG_ADISENSE_CORE_ALERT_STATUS_2_RESET 0x00000000            /*      Reset Value for Alert_Status_2  */
#define REG_ADISENSE_CORE_ALERT_STATUS_2     0x00000028            /*  ADISENSE_CORE Additional Alert Status Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CHn_RESET 0x00000000            /*      Reset Value for Alert_Detail_Ch[n]  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH0  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH1  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH2  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH3  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH4  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH5  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH6  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH7  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH8  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH9  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH10  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH11_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH11  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH12_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_DETAIL_CH12  */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH0   0x0000002A            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH1   0x0000002C            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH2   0x0000002E            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH3   0x00000030            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH4   0x00000032            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH5   0x00000034            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH6   0x00000036            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH7   0x00000038            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH8   0x0000003A            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH9   0x0000003C            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH10  0x0000003E            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH11  0x00000040            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CH12  0x00000042            /*  ADISENSE_CORE Detailed Error Information */
#define REG_ADISENSE_CORE_ALERT_DETAIL_CHn(i) (REG_ADISENSE_CORE_ALERT_DETAIL_CH0 + ((i) * 2))
#define REG_ADISENSE_CORE_ALERT_DETAIL_CHn_COUNT 13
#define REG_ADISENSE_CORE_ERROR_CODE_RESET   0x00000000            /*      Reset Value for Error_Code  */
#define REG_ADISENSE_CORE_ERROR_CODE         0x0000004C            /*  ADISENSE_CORE Code Indicating Source of Error */
#define REG_ADISENSE_CORE_ALERT_CODE_RESET   0x00000000            /*      Reset Value for Alert_Code  */
#define REG_ADISENSE_CORE_ALERT_CODE         0x0000004E            /*  ADISENSE_CORE Code Indicating Source of Alert */
#define REG_ADISENSE_CORE_EXTERNAL_REFERENCE1_RESET 0x00000000            /*      Reset Value for External_Reference1  */
#define REG_ADISENSE_CORE_EXTERNAL_REFERENCE1 0x00000050            /*  ADISENSE_CORE External Reference Information */
#define REG_ADISENSE_CORE_EXTERNAL_REFERENCE2_RESET 0x00000000            /*      Reset Value for External_Reference2  */
#define REG_ADISENSE_CORE_EXTERNAL_REFERENCE2 0x00000054            /*  ADISENSE_CORE External Reference Information */
#define REG_ADISENSE_CORE_AVDD_VOLTAGE_RESET 0x40533333            /*      Reset Value for AVDD_Voltage  */
#define REG_ADISENSE_CORE_AVDD_VOLTAGE       0x00000058            /*  ADISENSE_CORE AVDD Voltage */
#define REG_ADISENSE_CORE_DIAGNOSTICS_CONTROL_RESET 0x00000000            /*      Reset Value for Diagnostics_Control  */
#define REG_ADISENSE_CORE_DIAGNOSTICS_CONTROL 0x0000005C            /*  ADISENSE_CORE Diagnostic Control */
#define REG_ADISENSE_CORE_DATA_FIFO_RESET    0x00000000            /*      Reset Value for Data_FIFO  */
#define REG_ADISENSE_CORE_DATA_FIFO          0x00000060            /*  ADISENSE_CORE FIFO of Sensor Results */
#define REG_ADISENSE_CORE_LUT_SELECT_RESET   0x00000000            /*      Reset Value for LUT_Select  */
#define REG_ADISENSE_CORE_LUT_SELECT         0x00000070            /*  ADISENSE_CORE Read/Write Strobe */
#define REG_ADISENSE_CORE_LUT_OFFSET_RESET   0x00000000            /*      Reset Value for LUT_Offset  */
#define REG_ADISENSE_CORE_LUT_OFFSET         0x00000072            /*  ADISENSE_CORE Offset into Selected LUT */
#define REG_ADISENSE_CORE_LUT_DATA_RESET     0x00000000            /*      Reset Value for LUT_Data  */
#define REG_ADISENSE_CORE_LUT_DATA           0x00000074            /*  ADISENSE_CORE Data to Read/Write from Addressed LUT Entry */
#define REG_ADISENSE_CORE_CAL_OFFSET_RESET   0x00000000            /*      Reset Value for CAL_Offset  */
#define REG_ADISENSE_CORE_CAL_OFFSET         0x0000007A            /*  ADISENSE_CORE Offset into Selected Calibration Values */
#define REG_ADISENSE_CORE_CAL_DATA_RESET     0x00000000            /*      Reset Value for CAL_Data  */
#define REG_ADISENSE_CORE_CAL_DATA           0x0000007C            /*  ADISENSE_CORE Data to Read/Write from Addressed Calibration Values */
#define REG_ADISENSE_CORE_REVISION_RESET     0x00000000            /*      Reset Value for Revision  */
#define REG_ADISENSE_CORE_REVISION           0x0000008C            /*  ADISENSE_CORE Hardware, Firmware Revision */
#define REG_ADISENSE_CORE_CHANNEL_COUNTn_RESET 0x00000000            /*      Reset Value for Channel_Count[n]  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT0  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT1  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT2  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT3  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT4  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT5  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT6  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT7  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT8  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT9  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_COUNT10  */
#define REG_ADISENSE_CORE_CHANNEL_COUNT0     0x00000090            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT1     0x000000D0            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT2     0x00000110            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT3     0x00000150            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT4     0x00000190            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT5     0x000001D0            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT6     0x00000210            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT7     0x00000250            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT8     0x00000290            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT9     0x000002D0            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNT10    0x00000310            /*  ADISENSE_CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_ADISENSE_CORE_CHANNEL_COUNTn(i)  (REG_ADISENSE_CORE_CHANNEL_COUNT0 + ((i) * 64))
#define REG_ADISENSE_CORE_CHANNEL_COUNTn_COUNT 11
#define REG_ADISENSE_CORE_SENSOR_TYPEn_RESET 0x00000000            /*      Reset Value for Sensor_Type[n]  */
#define REG_ADISENSE_CORE_SENSOR_TYPE0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE0  */
#define REG_ADISENSE_CORE_SENSOR_TYPE1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE1  */
#define REG_ADISENSE_CORE_SENSOR_TYPE2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE2  */
#define REG_ADISENSE_CORE_SENSOR_TYPE3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE3  */
#define REG_ADISENSE_CORE_SENSOR_TYPE4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE4  */
#define REG_ADISENSE_CORE_SENSOR_TYPE5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE5  */
#define REG_ADISENSE_CORE_SENSOR_TYPE6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE6  */
#define REG_ADISENSE_CORE_SENSOR_TYPE7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE7  */
#define REG_ADISENSE_CORE_SENSOR_TYPE8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE8  */
#define REG_ADISENSE_CORE_SENSOR_TYPE9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE9  */
#define REG_ADISENSE_CORE_SENSOR_TYPE10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_TYPE10  */
#define REG_ADISENSE_CORE_SENSOR_TYPE0       0x00000092            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE1       0x000000D2            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE2       0x00000112            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE3       0x00000152            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE4       0x00000192            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE5       0x000001D2            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE6       0x00000212            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE7       0x00000252            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE8       0x00000292            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE9       0x000002D2            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPE10      0x00000312            /*  ADISENSE_CORE Sensor Select */
#define REG_ADISENSE_CORE_SENSOR_TYPEn(i)    (REG_ADISENSE_CORE_SENSOR_TYPE0 + ((i) * 64))
#define REG_ADISENSE_CORE_SENSOR_TYPEn_COUNT 11
#define REG_ADISENSE_CORE_SENSOR_DETAILSn_RESET 0x0000FFF0            /*      Reset Value for Sensor_Details[n]  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS0_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS0  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS1_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS1  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS2_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS2  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS3_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS3  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS4_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS4  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS5_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS5  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS6_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS6  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS7_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS7  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS8_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS8  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS9_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS9  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS10_RESET 0x0000FFF0            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_DETAILS10  */
#define REG_ADISENSE_CORE_SENSOR_DETAILS0    0x00000094            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS1    0x000000D4            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS2    0x00000114            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS3    0x00000154            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS4    0x00000194            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS5    0x000001D4            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS6    0x00000214            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS7    0x00000254            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS8    0x00000294            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS9    0x000002D4            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILS10   0x00000314            /*  ADISENSE_CORE Sensor Details */
#define REG_ADISENSE_CORE_SENSOR_DETAILSn(i) (REG_ADISENSE_CORE_SENSOR_DETAILS0 + ((i) * 64))
#define REG_ADISENSE_CORE_SENSOR_DETAILSn_COUNT 11
#define REG_ADISENSE_CORE_CHANNEL_EXCITATIONn_RESET 0x00000000            /*      Reset Value for Channel_Excitation[n]  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION0  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION1  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION2  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION3  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION4  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION5  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION6  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION7  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION8  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION9  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_CHANNEL_EXCITATION10  */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION0 0x00000098            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION1 0x000000D8            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION2 0x00000118            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION3 0x00000158            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION4 0x00000198            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION5 0x000001D8            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION6 0x00000218            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION7 0x00000258            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION8 0x00000298            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION9 0x000002D8            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATION10 0x00000318            /*  ADISENSE_CORE Excitation Current */
#define REG_ADISENSE_CORE_CHANNEL_EXCITATIONn(i) (REG_ADISENSE_CORE_CHANNEL_EXCITATION0 + ((i) * 64))
#define REG_ADISENSE_CORE_CHANNEL_EXCITATIONn_COUNT 11
#define REG_ADISENSE_CORE_SETTLING_TIMEn_RESET 0x00000000            /*      Reset Value for Settling_Time[n]  */
#define REG_ADISENSE_CORE_SETTLING_TIME0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME0  */
#define REG_ADISENSE_CORE_SETTLING_TIME1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME1  */
#define REG_ADISENSE_CORE_SETTLING_TIME2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME2  */
#define REG_ADISENSE_CORE_SETTLING_TIME3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME3  */
#define REG_ADISENSE_CORE_SETTLING_TIME4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME4  */
#define REG_ADISENSE_CORE_SETTLING_TIME5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME5  */
#define REG_ADISENSE_CORE_SETTLING_TIME6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME6  */
#define REG_ADISENSE_CORE_SETTLING_TIME7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME7  */
#define REG_ADISENSE_CORE_SETTLING_TIME8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME8  */
#define REG_ADISENSE_CORE_SETTLING_TIME9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME9  */
#define REG_ADISENSE_CORE_SETTLING_TIME10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SETTLING_TIME10  */
#define REG_ADISENSE_CORE_SETTLING_TIME0     0x0000009A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME1     0x000000DA            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME2     0x0000011A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME3     0x0000015A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME4     0x0000019A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME5     0x000001DA            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME6     0x0000021A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME7     0x0000025A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME8     0x0000029A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME9     0x000002DA            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIME10    0x0000031A            /*  ADISENSE_CORE Settling Time */
#define REG_ADISENSE_CORE_SETTLING_TIMEn(i)  (REG_ADISENSE_CORE_SETTLING_TIME0 + ((i) * 64))
#define REG_ADISENSE_CORE_SETTLING_TIMEn_COUNT 11
#define REG_ADISENSE_CORE_FILTER_SELECTn_RESET 0x00000000            /*      Reset Value for Filter_Select[n]  */
#define REG_ADISENSE_CORE_FILTER_SELECT0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT0  */
#define REG_ADISENSE_CORE_FILTER_SELECT1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT1  */
#define REG_ADISENSE_CORE_FILTER_SELECT2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT2  */
#define REG_ADISENSE_CORE_FILTER_SELECT3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT3  */
#define REG_ADISENSE_CORE_FILTER_SELECT4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT4  */
#define REG_ADISENSE_CORE_FILTER_SELECT5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT5  */
#define REG_ADISENSE_CORE_FILTER_SELECT6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT6  */
#define REG_ADISENSE_CORE_FILTER_SELECT7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT7  */
#define REG_ADISENSE_CORE_FILTER_SELECT8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT8  */
#define REG_ADISENSE_CORE_FILTER_SELECT9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT9  */
#define REG_ADISENSE_CORE_FILTER_SELECT10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_FILTER_SELECT10  */
#define REG_ADISENSE_CORE_FILTER_SELECT0     0x0000009C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT1     0x000000DC            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT2     0x0000011C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT3     0x0000015C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT4     0x0000019C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT5     0x000001DC            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT6     0x0000021C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT7     0x0000025C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT8     0x0000029C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT9     0x000002DC            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECT10    0x0000031C            /*  ADISENSE_CORE ADC Digital Filter Selection */
#define REG_ADISENSE_CORE_FILTER_SELECTn(i)  (REG_ADISENSE_CORE_FILTER_SELECT0 + ((i) * 64))
#define REG_ADISENSE_CORE_FILTER_SELECTn_COUNT 11
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMITn_RESET 0x7F800000            /*      Reset Value for High_Threshold_Limit[n]  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT0_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT0  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT1_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT1  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT2_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT2  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT3_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT3  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT4_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT4  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT5_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT5  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT6_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT6  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT7_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT7  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT8_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT8  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT9_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT9  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT10_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT10  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT11_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT11  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT12_RESET 0x7F800000            /*      Reset Value for REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT12  */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT0 0x000000A0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT1 0x000000E0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT2 0x00000120            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT3 0x00000160            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT4 0x000001A0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT5 0x000001E0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT6 0x00000220            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT7 0x00000260            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT8 0x000002A0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT9 0x000002E0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT10 0x00000320            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT11 0x00000360            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT12 0x000003A0            /*  ADISENSE_CORE High Threshold */
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMITn(i) (REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT0 + ((i) * 64))
#define REG_ADISENSE_CORE_HIGH_THRESHOLD_LIMITn_COUNT 13
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMITn_RESET 0xFF800000            /*      Reset Value for Low_Threshold_Limit[n]  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT0_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT0  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT1_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT1  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT2_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT2  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT3_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT3  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT4_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT4  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT5_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT5  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT6_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT6  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT7_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT7  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT8_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT8  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT9_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT9  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT10_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT10  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT11_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT11  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT12_RESET 0xFF800000            /*      Reset Value for REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT12  */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT0 0x000000A4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT1 0x000000E4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT2 0x00000124            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT3 0x00000164            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT4 0x000001A4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT5 0x000001E4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT6 0x00000224            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT7 0x00000264            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT8 0x000002A4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT9 0x000002E4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT10 0x00000324            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT11 0x00000364            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT12 0x000003A4            /*  ADISENSE_CORE Low Threshold */
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMITn(i) (REG_ADISENSE_CORE_LOW_THRESHOLD_LIMIT0 + ((i) * 64))
#define REG_ADISENSE_CORE_LOW_THRESHOLD_LIMITn_COUNT 13
#define REG_ADISENSE_CORE_SENSOR_OFFSETn_RESET 0x00000000            /*      Reset Value for Sensor_Offset[n]  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET0  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET1  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET2  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET3  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET4  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET5  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET6  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET7  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET8  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET9  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET10  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET11_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET11  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET12_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_OFFSET12  */
#define REG_ADISENSE_CORE_SENSOR_OFFSET0     0x000000A8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET1     0x000000E8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET2     0x00000128            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET3     0x00000168            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET4     0x000001A8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET5     0x000001E8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET6     0x00000228            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET7     0x00000268            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET8     0x000002A8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET9     0x000002E8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET10    0x00000328            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET11    0x00000368            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSET12    0x000003A8            /*  ADISENSE_CORE Sensor Offset Adjustment */
#define REG_ADISENSE_CORE_SENSOR_OFFSETn(i)  (REG_ADISENSE_CORE_SENSOR_OFFSET0 + ((i) * 64))
#define REG_ADISENSE_CORE_SENSOR_OFFSETn_COUNT 13
#define REG_ADISENSE_CORE_SENSOR_GAINn_RESET 0x3F800000            /*      Reset Value for Sensor_Gain[n]  */
#define REG_ADISENSE_CORE_SENSOR_GAIN0_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN0  */
#define REG_ADISENSE_CORE_SENSOR_GAIN1_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN1  */
#define REG_ADISENSE_CORE_SENSOR_GAIN2_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN2  */
#define REG_ADISENSE_CORE_SENSOR_GAIN3_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN3  */
#define REG_ADISENSE_CORE_SENSOR_GAIN4_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN4  */
#define REG_ADISENSE_CORE_SENSOR_GAIN5_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN5  */
#define REG_ADISENSE_CORE_SENSOR_GAIN6_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN6  */
#define REG_ADISENSE_CORE_SENSOR_GAIN7_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN7  */
#define REG_ADISENSE_CORE_SENSOR_GAIN8_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN8  */
#define REG_ADISENSE_CORE_SENSOR_GAIN9_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN9  */
#define REG_ADISENSE_CORE_SENSOR_GAIN10_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN10  */
#define REG_ADISENSE_CORE_SENSOR_GAIN11_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN11  */
#define REG_ADISENSE_CORE_SENSOR_GAIN12_RESET 0x3F800000            /*      Reset Value for REG_ADISENSE_CORE_SENSOR_GAIN12  */
#define REG_ADISENSE_CORE_SENSOR_GAIN0       0x000000AC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN1       0x000000EC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN2       0x0000012C            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN3       0x0000016C            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN4       0x000001AC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN5       0x000001EC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN6       0x0000022C            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN7       0x0000026C            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN8       0x000002AC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN9       0x000002EC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN10      0x0000032C            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN11      0x0000036C            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAIN12      0x000003AC            /*  ADISENSE_CORE Sensor Gain Adjustment */
#define REG_ADISENSE_CORE_SENSOR_GAINn(i)    (REG_ADISENSE_CORE_SENSOR_GAIN0 + ((i) * 64))
#define REG_ADISENSE_CORE_SENSOR_GAINn_COUNT 13
#define REG_ADISENSE_CORE_ALERT_CODE_CHn_RESET 0x00000000            /*      Reset Value for Alert_Code_Ch[n]  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH0  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH1  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH2  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH3  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH4  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH5  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH6  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH7  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH8  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH9  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH10  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH11_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH11  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH12_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_ALERT_CODE_CH12  */
#define REG_ADISENSE_CORE_ALERT_CODE_CH0     0x000000B0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH1     0x000000F0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH2     0x00000130            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH3     0x00000170            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH4     0x000001B0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH5     0x000001F0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH6     0x00000230            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH7     0x00000270            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH8     0x000002B0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH9     0x000002F0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH10    0x00000330            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH11    0x00000370            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CH12    0x000003B0            /*  ADISENSE_CORE Per-Channel Detailed Alert-Code Information */
#define REG_ADISENSE_CORE_ALERT_CODE_CHn(i)  (REG_ADISENSE_CORE_ALERT_CODE_CH0 + ((i) * 64))
#define REG_ADISENSE_CORE_ALERT_CODE_CHn_COUNT 13
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIGn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Config[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG0  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG1  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG2  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG3  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG4  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG5  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG6  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG7  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG8  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG9  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG10  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG0 0x000000B8            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG1 0x000000F8            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG2 0x00000138            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG3 0x00000178            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG4 0x000001B8            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG5 0x000001F8            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG6 0x00000238            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG7 0x00000278            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG8 0x000002B8            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG9 0x000002F8            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG10 0x00000338            /*  ADISENSE_CORE Digital Sensor Data Coding */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIGn(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG0 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_CONFIGn_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESSn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Address[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS0  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS1  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS2  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS3  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS4  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS5  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS6  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS7  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS8  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS9  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS10  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS0 0x000000BA            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS1 0x000000FA            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS2 0x0000013A            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS3 0x0000017A            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS4 0x000001BA            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS5 0x000001FA            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS6 0x0000023A            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS7 0x0000027A            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS8 0x000002BA            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS9 0x000002FA            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS10 0x0000033A            /*  ADISENSE_CORE Sensor Address */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESSn(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS0 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESSn_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDSn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Num_Cmds[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS0_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS0  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS1_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS1  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS2_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS2  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS3_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS3  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS4_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS4  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS5_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS5  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS6_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS6  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS7_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS7  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS8_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS8  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS9_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS9  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS10  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS0 0x000000BB            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS1 0x000000FB            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS2 0x0000013B            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS3 0x0000017B            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS4 0x000001BB            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS5 0x000001FB            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS6 0x0000023B            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS7 0x0000027B            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS8 0x000002BB            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS9 0x000002FB            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS10 0x0000033B            /*  ADISENSE_CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDSn(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS0 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDSn_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND1n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command1[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND10  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND11_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND11  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND12_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND12  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND13_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND13  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND14_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND14  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND15_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND15  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND16_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND16  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND17_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND17  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND18_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND18  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND19_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND19  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND110_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND110  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND10 0x000000C0            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND11 0x00000100            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND12 0x00000140            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND13 0x00000180            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND14 0x000001C0            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND15 0x00000200            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND16 0x00000240            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND17 0x00000280            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND18 0x000002C0            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND19 0x00000300            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND110 0x00000340            /*  ADISENSE_CORE Sensor Configuration Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND1n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND10 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND1n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND2n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command2[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND20_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND20  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND21_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND21  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND22_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND22  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND23_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND23  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND24_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND24  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND25_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND25  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND26_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND26  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND27_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND27  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND28_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND28  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND29_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND29  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND210_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND210  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND20 0x000000C1            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND21 0x00000101            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND22 0x00000141            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND23 0x00000181            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND24 0x000001C1            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND25 0x00000201            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND26 0x00000241            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND27 0x00000281            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND28 0x000002C1            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND29 0x00000301            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND210 0x00000341            /*  ADISENSE_CORE Sensor Configuration Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND2n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND20 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND2n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND3n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command3[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND30_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND30  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND31_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND31  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND32_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND32  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND33_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND33  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND34_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND34  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND35_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND35  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND36_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND36  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND37_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND37  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND38_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND38  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND39_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND39  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND310_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND310  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND30 0x000000C2            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND31 0x00000102            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND32 0x00000142            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND33 0x00000182            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND34 0x000001C2            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND35 0x00000202            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND36 0x00000242            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND37 0x00000282            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND38 0x000002C2            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND39 0x00000302            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND310 0x00000342            /*  ADISENSE_CORE Sensor Configuration Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND3n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND30 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND3n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND4n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command4[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND40_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND40  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND41_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND41  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND42_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND42  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND43_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND43  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND44_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND44  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND45_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND45  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND46_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND46  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND47_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND47  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND48_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND48  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND49_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND49  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND410_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND410  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND40 0x000000C3            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND41 0x00000103            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND42 0x00000143            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND43 0x00000183            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND44 0x000001C3            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND45 0x00000203            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND46 0x00000243            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND47 0x00000283            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND48 0x000002C3            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND49 0x00000303            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND410 0x00000343            /*  ADISENSE_CORE Sensor Configuration Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND4n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND40 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND4n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND5n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command5[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND50_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND50  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND51_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND51  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND52_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND52  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND53_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND53  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND54_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND54  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND55_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND55  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND56_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND56  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND57_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND57  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND58_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND58  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND59_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND59  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND510_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND510  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND50 0x000000C4            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND51 0x00000104            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND52 0x00000144            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND53 0x00000184            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND54 0x000001C4            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND55 0x00000204            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND56 0x00000244            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND57 0x00000284            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND58 0x000002C4            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND59 0x00000304            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND510 0x00000344            /*  ADISENSE_CORE Sensor Configuration Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND5n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND50 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND5n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND6n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command6[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND60_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND60  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND61_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND61  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND62_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND62  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND63_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND63  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND64_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND64  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND65_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND65  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND66_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND66  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND67_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND67  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND68_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND68  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND69_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND69  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND610_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND610  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND60 0x000000C5            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND61 0x00000105            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND62 0x00000145            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND63 0x00000185            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND64 0x000001C5            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND65 0x00000205            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND66 0x00000245            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND67 0x00000285            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND68 0x000002C5            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND69 0x00000305            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND610 0x00000345            /*  ADISENSE_CORE Sensor Configuration Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND6n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND60 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND6n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND7n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command7[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND70_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND70  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND71_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND71  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND72_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND72  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND73_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND73  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND74_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND74  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND75_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND75  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND76_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND76  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND77_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND77  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND78_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND78  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND79_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND79  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND710_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND710  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND70 0x000000C6            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND71 0x00000106            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND72 0x00000146            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND73 0x00000186            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND74 0x000001C6            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND75 0x00000206            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND76 0x00000246            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND77 0x00000286            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND78 0x000002C6            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND79 0x00000306            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND710 0x00000346            /*  ADISENSE_CORE Sensor Configuration Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND7n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND70 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND7n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD1n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd1[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD10_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD10  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD11_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD11  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD12_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD12  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD13_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD13  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD14_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD14  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD15_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD15  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD16_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD16  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD17_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD17  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD18_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD18  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD19_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD19  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD110_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD110  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD10 0x000000C8            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD11 0x00000108            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD12 0x00000148            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD13 0x00000188            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD14 0x000001C8            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD15 0x00000208            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD16 0x00000248            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD17 0x00000288            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD18 0x000002C8            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD19 0x00000308            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD110 0x00000348            /*  ADISENSE_CORE Sensor Read Command1 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD1n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD10 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD1n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD2n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd2[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD20_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD20  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD21_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD21  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD22_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD22  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD23_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD23  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD24_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD24  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD25_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD25  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD26_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD26  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD27_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD27  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD28_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD28  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD29_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD29  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD210_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD210  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD20 0x000000C9            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD21 0x00000109            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD22 0x00000149            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD23 0x00000189            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD24 0x000001C9            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD25 0x00000209            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD26 0x00000249            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD27 0x00000289            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD28 0x000002C9            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD29 0x00000309            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD210 0x00000349            /*  ADISENSE_CORE Sensor Read Command2 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD2n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD20 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD2n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD3n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd3[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD30_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD30  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD31_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD31  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD32_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD32  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD33_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD33  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD34_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD34  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD35_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD35  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD36_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD36  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD37_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD37  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD38_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD38  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD39_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD39  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD310_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD310  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD30 0x000000CA            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD31 0x0000010A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD32 0x0000014A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD33 0x0000018A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD34 0x000001CA            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD35 0x0000020A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD36 0x0000024A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD37 0x0000028A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD38 0x000002CA            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD39 0x0000030A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD310 0x0000034A            /*  ADISENSE_CORE Sensor Read Command3 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD3n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD30 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD3n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD4n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd4[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD40_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD40  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD41_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD41  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD42_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD42  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD43_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD43  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD44_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD44  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD45_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD45  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD46_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD46  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD47_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD47  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD48_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD48  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD49_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD49  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD410_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD410  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD40 0x000000CB            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD41 0x0000010B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD42 0x0000014B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD43 0x0000018B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD44 0x000001CB            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD45 0x0000020B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD46 0x0000024B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD47 0x0000028B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD48 0x000002CB            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD49 0x0000030B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD410 0x0000034B            /*  ADISENSE_CORE Sensor Read Command4 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD4n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD40 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD4n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD5n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd5[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD50_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD50  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD51_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD51  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD52_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD52  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD53_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD53  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD54_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD54  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD55_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD55  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD56_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD56  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD57_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD57  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD58_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD58  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD59_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD59  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD510_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD510  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD50 0x000000CC            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD51 0x0000010C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD52 0x0000014C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD53 0x0000018C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD54 0x000001CC            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD55 0x0000020C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD56 0x0000024C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD57 0x0000028C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD58 0x000002CC            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD59 0x0000030C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD510 0x0000034C            /*  ADISENSE_CORE Sensor Read Command5 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD5n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD50 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD5n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD6n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd6[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD60_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD60  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD61_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD61  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD62_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD62  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD63_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD63  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD64_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD64  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD65_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD65  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD66_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD66  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD67_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD67  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD68_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD68  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD69_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD69  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD610_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD610  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD60 0x000000CD            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD61 0x0000010D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD62 0x0000014D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD63 0x0000018D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD64 0x000001CD            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD65 0x0000020D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD66 0x0000024D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD67 0x0000028D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD68 0x000002CD            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD69 0x0000030D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD610 0x0000034D            /*  ADISENSE_CORE Sensor Read Command6 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD6n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD60 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD6n_COUNT 11
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD7n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd7[n]  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD70_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD70  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD71_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD71  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD72_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD72  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD73_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD73  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD74_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD74  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD75_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD75  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD76_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD76  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD77_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD77  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD78_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD78  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD79_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD79  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD710_RESET 0x00000000            /*      Reset Value for REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD710  */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD70 0x000000CE            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD71 0x0000010E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD72 0x0000014E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD73 0x0000018E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD74 0x000001CE            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD75 0x0000020E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD76 0x0000024E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD77 0x0000028E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD78 0x000002CE            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD79 0x0000030E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD710 0x0000034E            /*  ADISENSE_CORE Sensor Read Command7 */
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD7n(i) (REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD70 + ((i) * 64))
#define REG_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD7n_COUNT 11

/* ============================================================================================================================
        ADISENSE_CORE Register BitMasks, Positions & Enumerations 
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_COMMAND                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_COMMAND_SPECIAL_COMMAND  0            /*  Special Command */
#define BITM_ADISENSE_CORE_COMMAND_SPECIAL_COMMAND 0x000000FF    /*  Special Command */
#define ENUM_ADISENSE_CORE_COMMAND_NOP       0x00000000            /*  Special_Command: No Command */
#define ENUM_ADISENSE_CORE_COMMAND_CONVERT   0x00000001            /*  Special_Command: Start ADC Conversions */
#define ENUM_ADISENSE_CORE_COMMAND_CONVERT_WITH_RAW 0x00000002            /*  Special_Command: Start Conversions with Added RAW ADC Data */
#define ENUM_ADISENSE_CORE_COMMAND_RUN_DIAGNOSTICS 0x00000003            /*  Special_Command: Initiate a Diagnostics Cycle */
#define ENUM_ADISENSE_CORE_COMMAND_SELF_CALIBRATION 0x00000004            /*  Special_Command: Initiate a Self-Calibration Cycle */
#define ENUM_ADISENSE_CORE_COMMAND_LOAD_CONFIG 0x00000005            /*  Special_Command: Load Registers with Configuration from FLASH */
#define ENUM_ADISENSE_CORE_COMMAND_SAVE_CONFIG 0x00000006            /*  Special_Command: Store Current Register Configuration to FLASH */
#define ENUM_ADISENSE_CORE_COMMAND_LATCH_CONFIG 0x00000007            /*  Special_Command: Latch Configuration. */
#define ENUM_ADISENSE_CORE_COMMAND_LOAD_LUT  0x00000008            /*  Special_Command: Load LUT from FLASH */
#define ENUM_ADISENSE_CORE_COMMAND_SAVE_LUT2 0x00000009            /*  Special_Command: Save LUT to FLASH */
#define ENUM_ADISENSE_CORE_COMMAND_SYSTEM_CHECK 0x0000000A            /*  Special_Command: Full Suite of Measurement Diagnostics */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_MODE                   Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_MODE_DRDY_MODE     2            /*  Indicates Behavior of DRDY with Respect to FIFO State */
#define BITP_ADISENSE_CORE_MODE_CONVERSION_MODE  0            /*  Conversion Mode */
#define BITM_ADISENSE_CORE_MODE_DRDY_MODE    0x0000000C    /*  Indicates Behavior of DRDY with Respect to FIFO State */
#define BITM_ADISENSE_CORE_MODE_CONVERSION_MODE 0x00000003    /*  Conversion Mode */
#define ENUM_ADISENSE_CORE_MODE_DRDY_PER_CONVERSION 0x00000000            /*  Drdy_Mode: Data Ready Per Conversion */
#define ENUM_ADISENSE_CORE_MODE_DRDY_PER_CYCLE 0x00000004            /*  Drdy_Mode: Data Ready Per Cycle */
#define ENUM_ADISENSE_CORE_MODE_DRDY_PER_FIFO_FILL 0x00000008            /*  Drdy_Mode: Data Ready Per FIFO Fill */
#define ENUM_ADISENSE_CORE_MODE_DRDY_MODE3   0x0000000C            /*  Drdy_Mode: Undefined */
#define ENUM_ADISENSE_CORE_MODE_SINGLECYCLE  0x00000000            /*  Conversion_Mode: Single Cycle */
#define ENUM_ADISENSE_CORE_MODE_MULTICYCLE   0x00000001            /*  Conversion_Mode: Multi Cycle */
#define ENUM_ADISENSE_CORE_MODE_CONTINUOUS   0x00000002            /*  Conversion_Mode: Continuous Conversion */
#define ENUM_ADISENSE_CORE_MODE_MODE3        0x00000003            /*  Conversion_Mode: Undefined */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_POWER_CONFIG           Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_POWER_CONFIG_STDBY_EN  4            /*  Standby */
#define BITP_ADISENSE_CORE_POWER_CONFIG_POWER_MODE_MCU  2            /*  MCU Power Mode */
#define BITP_ADISENSE_CORE_POWER_CONFIG_POWER_MODE_ADC  0            /*  ADC Power Mode */
#define BITM_ADISENSE_CORE_POWER_CONFIG_STDBY_EN 0x00000010    /*  Standby */
#define BITM_ADISENSE_CORE_POWER_CONFIG_POWER_MODE_MCU 0x0000000C    /*  MCU Power Mode */
#define BITM_ADISENSE_CORE_POWER_CONFIG_POWER_MODE_ADC 0x00000003    /*  ADC Power Mode */
#define ENUM_ADISENSE_CORE_POWER_CONFIG_ADC_LOW_POWER 0x00000000            /*  Power_Mode_ADC: ADC Low Power Mode */
#define ENUM_ADISENSE_CORE_POWER_CONFIG_ADC_MID_POWER 0x00000001            /*  Power_Mode_ADC: ADC Mid Power Mode */
#define ENUM_ADISENSE_CORE_POWER_CONFIG_ADC_FULL_POWER 0x00000002            /*  Power_Mode_ADC: ADC Full Power Mode */
#define ENUM_ADISENSE_CORE_POWER_CONFIG_ADC_FULL_POWER2 0x00000003            /*  Power_Mode_ADC: ADC Full Power Mode2 */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_CYCLE_CONTROL          Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_CYCLE_CONTROL_CYCLE_TIME_UNITS 14            /*  Units for Cycle Time */
#define BITP_ADISENSE_CORE_CYCLE_CONTROL_CYCLE_TIME  0            /*  Duration of a Full Measurement Cycle */
#define BITM_ADISENSE_CORE_CYCLE_CONTROL_CYCLE_TIME_UNITS 0x0000C000    /*  Units for Cycle Time */
#define BITM_ADISENSE_CORE_CYCLE_CONTROL_CYCLE_TIME 0x00000FFF    /*  Duration of a Full Measurement Cycle */
#define ENUM_ADISENSE_CORE_CYCLE_CONTROL_MICROSECONDS 0x00000000            /*  Cycle_Time_Units: Micro-Seconds */
#define ENUM_ADISENSE_CORE_CYCLE_CONTROL_MILLISECONDS 0x00004000            /*  Cycle_Time_Units: Milli-Seconds */
#define ENUM_ADISENSE_CORE_CYCLE_CONTROL_SECONDS 0x00008000            /*  Cycle_Time_Units: Seconds */
#define ENUM_ADISENSE_CORE_CYCLE_CONTROL_UNDEFINED 0x0000C000            /*  Cycle_Time_Units: Undefined */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_FIFO_NUM_CYCLES        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_FIFO_NUM_CYCLES_FIFO_NUM_CYCLES  0            /*  How Many Cycles to Fill FIFO */
#define BITM_ADISENSE_CORE_FIFO_NUM_CYCLES_FIFO_NUM_CYCLES 0x000000FF    /*  How Many Cycles to Fill FIFO */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_MULTI_CYCLE_REPEAT_INTERVAL Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_MULTI_CYCLE_REPEAT_INTERVAL_MULTI_CYCLE_REPEAT_INTERVAL  0            /*  Defines Time Between Repetitions of Measurement Cycles. */
#define BITM_ADISENSE_CORE_MULTI_CYCLE_REPEAT_INTERVAL_MULTI_CYCLE_REPEAT_INTERVAL 0x00FFFFFF    /*  Defines Time Between Repetitions of Measurement Cycles. */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_STATUS                 Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_STATUS_FIFO_ERROR  5            /*  Indicates Error with FIFO */
#define BITP_ADISENSE_CORE_STATUS_CMD_RUNNING  4            /*  Indicates a Special Command is Active */
#define BITP_ADISENSE_CORE_STATUS_DRDY        3            /*  Indicates a New Sensor Result is Available to Be Read */
#define BITP_ADISENSE_CORE_STATUS_ERROR       2            /*  Indicates an Error */
#define BITP_ADISENSE_CORE_STATUS_ALERT_ACTIVE  1            /*  Indicates One or More Sensors Alerts are Active */
#define BITM_ADISENSE_CORE_STATUS_FIFO_ERROR 0x00000020    /*  Indicates Error with FIFO */
#define BITM_ADISENSE_CORE_STATUS_CMD_RUNNING 0x00000010    /*  Indicates a Special Command is Active */
#define BITM_ADISENSE_CORE_STATUS_DRDY       0x00000008    /*  Indicates a New Sensor Result is Available to Be Read */
#define BITM_ADISENSE_CORE_STATUS_ERROR      0x00000004    /*  Indicates an Error */
#define BITM_ADISENSE_CORE_STATUS_ALERT_ACTIVE 0x00000002    /*  Indicates One or More Sensors Alerts are Active */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIAGNOSTICS_STATUS     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAGNOSTICS_STATUS_SUNDRY 14            /*  Sundry Diagnostics Status */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_CALIBRATION_ERROR 13            /*  Indicates Error During Internal Device Calibrations */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_CONVERSION_ERROR 12            /*  Indicates Error During Internal ADC Conversions */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_OV_ERROR 11            /*  Indicates Over-Voltage Error on Positive Analog Input */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_UV_ERROR 10            /*  Indicates Under-Voltage Error on Positive Analog Input */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_OV_ERROR  9            /*  Indicates Over-Voltage Error on Negative Analog Input */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_UV_ERROR  8            /*  Indicates Under-Voltage Error on Negative Analog Input */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_SUPPLY_CAP_ERROR  3            /*  Indicates Fault on Internal Supply Regulator Capacitor */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_SUPPLY_MONITOR_ERROR  2            /*  Indicates Low Voltage on Internal Supply Voltages */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_COMMS_ERROR  1            /*  Indicates Error on Internal Device Communications */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_CHECKSUM_ERROR  0            /*  Indicates Error on Internal Checksum Calculations */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAGNOSTICS_STATUS_SUNDRY 0x0000C000    /*  Sundry Diagnostics Status */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_CALIBRATION_ERROR 0x00002000    /*  Indicates Error During Internal Device Calibrations */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_CONVERSION_ERROR 0x00001000    /*  Indicates Error During Internal ADC Conversions */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_OV_ERROR 0x00000800    /*  Indicates Over-Voltage Error on Positive Analog Input */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_UV_ERROR 0x00000400    /*  Indicates Under-Voltage Error on Positive Analog Input */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_OV_ERROR 0x00000200    /*  Indicates Over-Voltage Error on Negative Analog Input */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_UV_ERROR 0x00000100    /*  Indicates Under-Voltage Error on Negative Analog Input */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_SUPPLY_CAP_ERROR 0x00000008    /*  Indicates Fault on Internal Supply Regulator Capacitor */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_SUPPLY_MONITOR_ERROR 0x00000004    /*  Indicates Low Voltage on Internal Supply Voltages */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_COMMS_ERROR 0x00000002    /*  Indicates Error on Internal Device Communications */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_STATUS_DIAG_CHECKSUM_ERROR 0x00000001    /*  Indicates Error on Internal Checksum Calculations */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_CHANNEL_ALERT_STATUS   Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH12 12            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH11 11            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH10 10            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH9  9            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH8  8            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH7  7            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH6  6            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH5  5            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH4  4            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH3  3            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH2  2            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH1  1            /*  Indicates Channel Alert is Active */
#define BITP_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH0  0            /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH12 0x00001000    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH11 0x00000800    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH10 0x00000400    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH9 0x00000200    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH8 0x00000100    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH7 0x00000080    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH6 0x00000040    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH5 0x00000020    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH4 0x00000010    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH3 0x00000008    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH2 0x00000004    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH1 0x00000002    /*  Indicates Channel Alert is Active */
#define BITM_ADISENSE_CORE_CHANNEL_ALERT_STATUS_ALERT_CH0 0x00000001    /*  Indicates Channel Alert is Active */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_ALERT_STATUS_2         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_ALERT_STATUS_2_CONFIGURATION_ERROR  2            /*  Indicates Error with Programmed Configuration */
#define BITP_ADISENSE_CORE_ALERT_STATUS_2_LUT_ERROR  1            /*  Indicates Error with One or More Look-Up-Tables */
#define BITM_ADISENSE_CORE_ALERT_STATUS_2_CONFIGURATION_ERROR 0x00000004    /*  Indicates Error with Programmed Configuration */
#define BITM_ADISENSE_CORE_ALERT_STATUS_2_LUT_ERROR 0x00000002    /*  Indicates Error with One or More Look-Up-Tables */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_ALERT_DETAIL_CH[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_COMP_NOT_READY 15            /*  Indicates Compensation Channel Not Ready When Required */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_SENSOR_NOT_READY 14            /*  Indicates Digital Sensor Not Ready When Read */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_CORRECTION_OVERRANGE 13            /*  Indicates Result Larger Than LUT/Equation Range */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_CORRECTION_UNDERRANGE 12            /*  Indicates Result Less Than LUT/Equation Range */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_OVER_VOLTAGE 11            /*  Indicates Channel Over-Voltage */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_UNDER_VOLTAGE 10            /*  Indicates Channel Under-Voltage */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_LUT_ERROR_CH  9            /*  Indicates Error with Channel Look-Up-Table */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_CONFIG_ERR  8            /*  Indicates Configuration Error on Channel */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_REF_DETECT  6            /*  Indicates Whether ADC Reference is Valid */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_SENSOR_OPEN  5            /*  Indicates Sensor Input is Open Circuit */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_HIGH_LIMIT  4            /*  Indicates Sensor Result is Greater Than High Limit */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_LOW_LIMIT  3            /*  Indicates Sensor Result is Less Than Low Limit */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_OVER_RANGE  2            /*  Indicates Channel Over-Range */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_UNDER_RANGE  1            /*  Indicates Channel Under-Range */
#define BITP_ADISENSE_CORE_ALERT_DETAIL_CH_TIME_OUT  0            /*  Indicates Time-Out Error from Digital Sensor */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_COMP_NOT_READY 0x00008000    /*  Indicates Compensation Channel Not Ready When Required */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_SENSOR_NOT_READY 0x00004000    /*  Indicates Digital Sensor Not Ready When Read */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_CORRECTION_OVERRANGE 0x00002000    /*  Indicates Result Larger Than LUT/Equation Range */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_CORRECTION_UNDERRANGE 0x00001000    /*  Indicates Result Less Than LUT/Equation Range */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_OVER_VOLTAGE 0x00000800    /*  Indicates Channel Over-Voltage */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_UNDER_VOLTAGE 0x00000400    /*  Indicates Channel Under-Voltage */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_LUT_ERROR_CH 0x00000200    /*  Indicates Error with Channel Look-Up-Table */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_CONFIG_ERR 0x00000100    /*  Indicates Configuration Error on Channel */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_REF_DETECT 0x00000040    /*  Indicates Whether ADC Reference is Valid */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_SENSOR_OPEN 0x00000020    /*  Indicates Sensor Input is Open Circuit */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_HIGH_LIMIT 0x00000010    /*  Indicates Sensor Result is Greater Than High Limit */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_LOW_LIMIT 0x00000008    /*  Indicates Sensor Result is Less Than Low Limit */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_OVER_RANGE 0x00000004    /*  Indicates Channel Over-Range */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_UNDER_RANGE 0x00000002    /*  Indicates Channel Under-Range */
#define BITM_ADISENSE_CORE_ALERT_DETAIL_CH_TIME_OUT 0x00000001    /*  Indicates Time-Out Error from Digital Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_ERROR_CODE             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_ERROR_CODE_ERROR_CODE  0            /*  Code Indicating Type of Error */
#define BITM_ADISENSE_CORE_ERROR_CODE_ERROR_CODE 0x0000FFFF    /*  Code Indicating Type of Error */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_ALERT_CODE             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_ALERT_CODE_ALERT_CODE  0            /*  Code Indicating Type of Alert */
#define BITM_ADISENSE_CORE_ALERT_CODE_ALERT_CODE 0x0000FFFF    /*  Code Indicating Type of Alert */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_EXTERNAL_REFERENCE1    Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_EXTERNAL_REFERENCE1_EXT_REFIN1_VALUE  0            /*  Refin1 Value */
#define BITM_ADISENSE_CORE_EXTERNAL_REFERENCE1_EXT_REFIN1_VALUE 0xFFFFFFFF    /*  Refin1 Value */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_EXTERNAL_REFERENCE2    Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_EXTERNAL_REFERENCE2_EXT_REFIN2_VALUE  0            /*  Refin2 Value */
#define BITM_ADISENSE_CORE_EXTERNAL_REFERENCE2_EXT_REFIN2_VALUE 0xFFFFFFFF    /*  Refin2 Value */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_AVDD_VOLTAGE           Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_AVDD_VOLTAGE_AVDD_VOLTAGE  0            /*  AVDD Voltage */
#define BITM_ADISENSE_CORE_AVDD_VOLTAGE_AVDD_VOLTAGE 0xFFFFFFFF    /*  AVDD Voltage */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIAGNOSTICS_CONTROL    Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAGNOSTICS_EXTRA  8            /*  Additional Diagnostics Control */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAG_OSD_FREQ  2            /*  Diagnostics Open Sensor Detect Frequency */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAG_MEAS_EN  1            /*  Diagnostics Measure Enable */
#define BITP_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAG_GLOBAL_EN  0            /*  Diagnostics Global Enable */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAGNOSTICS_EXTRA 0x0000FF00    /*  Additional Diagnostics Control */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAG_OSD_FREQ 0x0000000C    /*  Diagnostics Open Sensor Detect Frequency */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAG_MEAS_EN 0x00000002    /*  Diagnostics Measure Enable */
#define BITM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_DIAG_GLOBAL_EN 0x00000001    /*  Diagnostics Global Enable */
#define ENUM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_OFF 0x00000000            /*  Diag_OSD_Freq: No Open-Circuit Detection During Measurement */
#define ENUM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1_CYCLE 0x00000004            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Measurement Cycle */
#define ENUM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_PER_100_CYCLES 0x00000008            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Hundred Measurement Cycles */
#define ENUM_ADISENSE_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1000_CYCLES 0x0000000C            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Thousand Measurement Cycles */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DATA_FIFO              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DATA_FIFO_RAW_SAMPLE 40            /*  ADC Result */
#define BITP_ADISENSE_CORE_DATA_FIFO_CH_VALID 39            /*  Indicates Whether Valid Data Read from FIFO */
#define BITP_ADISENSE_CORE_DATA_FIFO_CH_RAW  38            /*  Indicates If RAW Data is Valid */
#define BITP_ADISENSE_CORE_DATA_FIFO_CH_ALERT 37            /*  Indicates Alert on Channel */
#define BITP_ADISENSE_CORE_DATA_FIFO_CH_ERROR 36            /*  Indicates Error on Channel */
#define BITP_ADISENSE_CORE_DATA_FIFO_CHANNEL_ID 32            /*  Indicates Which Channel This FIFO Data Corresponds to */
#define BITP_ADISENSE_CORE_DATA_FIFO_SENSOR_RESULT  0            /*  Linearized and Compensated Sensor Result */
#define BITM_ADISENSE_CORE_DATA_FIFO_RAW_SAMPLE 0xFFFFFF0000000000    /*  ADC Result */
#define BITM_ADISENSE_CORE_DATA_FIFO_CH_VALID 0x8000000000    /*  Indicates Whether Valid Data Read from FIFO */
#define BITM_ADISENSE_CORE_DATA_FIFO_CH_RAW  0x4000000000    /*  Indicates If RAW Data is Valid */
#define BITM_ADISENSE_CORE_DATA_FIFO_CH_ALERT 0x2000000000    /*  Indicates Alert on Channel */
#define BITM_ADISENSE_CORE_DATA_FIFO_CH_ERROR 0x1000000000    /*  Indicates Error on Channel */
#define BITM_ADISENSE_CORE_DATA_FIFO_CHANNEL_ID 0xF00000000    /*  Indicates Which Channel This FIFO Data Corresponds to */
#define BITM_ADISENSE_CORE_DATA_FIFO_SENSOR_RESULT 0xFFFFFFFF    /*  Linearized and Compensated Sensor Result */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_LUT_SELECT             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_LUT_SELECT_LUT_RW  7            /*  Read or Write LUT Data */
#define BITM_ADISENSE_CORE_LUT_SELECT_LUT_RW 0x00000080    /*  Read or Write LUT Data */
#define ENUM_ADISENSE_CORE_LUT_SELECT_LUT_READ 0x00000000            /*  LUT_RW: Read Addressed LUT Data */
#define ENUM_ADISENSE_CORE_LUT_SELECT_LUT_WRITE 0x00000080            /*  LUT_RW: Write Addressed LUT Data */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_LUT_OFFSET             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_LUT_OFFSET_LUT_OFFSET  0            /*  Offset into Look-Up-Table */
#define BITM_ADISENSE_CORE_LUT_OFFSET_LUT_OFFSET 0x00003FFF    /*  Offset into Look-Up-Table */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_LUT_DATA               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_LUT_DATA_LUT_DATA  0            /*  Data Byte to Write to / Read from Look-Up-Table */
#define BITM_ADISENSE_CORE_LUT_DATA_LUT_DATA 0x000000FF    /*  Data Byte to Write to / Read from Look-Up-Table */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_CAL_OFFSET             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_CAL_OFFSET_CAL_OFFSET  0            /*  Offset into Calibration Data */
#define BITM_ADISENSE_CORE_CAL_OFFSET_CAL_OFFSET 0x00003FFF    /*  Offset into Calibration Data */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_CAL_DATA               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_CAL_DATA_CAL_DATA  0            /*  Data to Write to / Read from Calibration Data */
#define BITM_ADISENSE_CORE_CAL_DATA_CAL_DATA 0x000000FF    /*  Data to Write to / Read from Calibration Data */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_REVISION               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_REVISION_COMMS_PROTOCOL 16            /*  ID Info */
#define BITP_ADISENSE_CORE_REVISION_HARDWARE_REVISION  8            /*  ID Info */
#define BITP_ADISENSE_CORE_REVISION_FIRMWARE_REVISION  0            /*  ID Info */
#define BITM_ADISENSE_CORE_REVISION_COMMS_PROTOCOL 0x00FF0000    /*  ID Info */
#define BITM_ADISENSE_CORE_REVISION_HARDWARE_REVISION 0x0000FF00    /*  ID Info */
#define BITM_ADISENSE_CORE_REVISION_FIRMWARE_REVISION 0x000000FF    /*  ID Info */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_CHANNEL_COUNT[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_CHANNEL_COUNT_CHANNEL_ENABLE  7            /*  Enable Channel in Measurement Cycle */
#define BITP_ADISENSE_CORE_CHANNEL_COUNT_CHANNEL_COUNT  0            /*  How Many Times Channel Should Appear in One Cycle */
#define BITM_ADISENSE_CORE_CHANNEL_COUNT_CHANNEL_ENABLE 0x00000080    /*  Enable Channel in Measurement Cycle */
#define BITM_ADISENSE_CORE_CHANNEL_COUNT_CHANNEL_COUNT 0x0000007F    /*  How Many Times Channel Should Appear in One Cycle */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_SENSOR_TYPE[n]         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_SENSOR_TYPE_SENSOR_TYPE  0            /*  Sensor Type */
#define BITM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_TYPE 0x00000FFF    /*  Sensor Type */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_T_DEF_L1 0x00000000            /*  Sensor_Type: Thermocouple T-Type Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_J_DEF_L1 0x00000001            /*  Sensor_Type: Thermocouple J-Type Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_K_DEF_L1 0x00000002            /*  Sensor_Type: Thermocouple K-Type Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_1_DEF_L2 0x0000000C            /*  Sensor_Type: Thermocouple Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_2_DEF_L2 0x0000000D            /*  Sensor_Type: Thermocouple Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_3_DEF_L2 0x0000000E            /*  Sensor_Type: Thermocouple Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_4_DEF_L2 0x0000000F            /*  Sensor_Type: Thermocouple Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_T_ADV_L1 0x00000010            /*  Sensor_Type: Thermocouple T-Type Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_J_ADV_L1 0x00000011            /*  Sensor_Type: Thermocouple J-Type Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_K_ADV_L1 0x00000012            /*  Sensor_Type: Thermocouple K-Type Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_1_ADV_L2 0x0000001C            /*  Sensor_Type: Thermocouple Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_2_ADV_L2 0x0000001D            /*  Sensor_Type: Thermocouple Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_3_ADV_L2 0x0000001E            /*  Sensor_Type: Thermocouple Sensor 3 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMOCOUPLE_4_ADV_L2 0x0000001F            /*  Sensor_Type: Thermocouple Sensor 4 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT100_DEF_L1 0x00000020            /*  Sensor_Type: RTD 2 Wire PT100 Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT1000_DEF_L1 0x00000021            /*  Sensor_Type: RTD 2 Wire PT1000 Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_1_DEF_L2 0x0000002C            /*  Sensor_Type: RTD 2 Wire Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_2_DEF_L2 0x0000002D            /*  Sensor_Type: RTD 2 Wire Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_3_DEF_L2 0x0000002E            /*  Sensor_Type: RTD 2 Wire Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_4_DEF_L2 0x0000002F            /*  Sensor_Type: RTD 2 Wire Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT100_ADV_L1 0x00000030            /*  Sensor_Type: RTD 2 Wire PT100 Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_PT1000_ADV_L1 0x00000031            /*  Sensor_Type: RTD 2 Wire PT1000 Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_1_ADV_L2 0x0000003C            /*  Sensor_Type: RTD 2 Wire Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_2_ADV_L2 0x0000003D            /*  Sensor_Type: RTD 2 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_3_ADV_L2 0x0000003E            /*  Sensor_Type: RTD 2 Wire Sensor 3 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_2W_4_ADV_L2 0x0000003F            /*  Sensor_Type: RTD 2 Wire Sensor 4 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT100_DEF_L1 0x00000040            /*  Sensor_Type: RTD 3 Wire PT100 Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT1000_DEF_L1 0x00000041            /*  Sensor_Type: RTD 3 Wire PT1000 Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_1_DEF_L2 0x0000004C            /*  Sensor_Type: RTD 3 Wire Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_2_DEF_L2 0x0000004D            /*  Sensor_Type: RTD 3 Wire Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_3_DEF_L2 0x0000004E            /*  Sensor_Type: RTD 3 Wire Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_4_DEF_L2 0x0000004F            /*  Sensor_Type: RTD 3 Wire Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT100_ADV_L1 0x00000050            /*  Sensor_Type: RTD 3 Wire PT100 Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_PT1000_ADV_L1 0x00000051            /*  Sensor_Type: RTD 3 Wire PT1000 Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_1_ADV_L2 0x0000005C            /*  Sensor_Type: RTD 3 Wire Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_2_ADV_L2 0x0000005D            /*  Sensor_Type: RTD 3 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_3_ADV_L2 0x0000005E            /*  Sensor_Type: RTD 3 Wire Sensor 3 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_3W_4_ADV_L2 0x0000005F            /*  Sensor_Type: RTD 3 Wire Sensor 4 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT100_DEF_L1 0x00000060            /*  Sensor_Type: RTD 4 Wire PT100 Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT1000_DEF_L1 0x00000061            /*  Sensor_Type: RTD 4 Wire PT1000 Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_1_DEF_L2 0x0000006C            /*  Sensor_Type: RTD 4 Wire Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_2_DEF_L2 0x0000006D            /*  Sensor_Type: RTD 4 Wire Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_3_DEF_L2 0x0000006E            /*  Sensor_Type: RTD 4 Wire Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_4_DEF_L2 0x0000006F            /*  Sensor_Type: RTD 4 Wire Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT100_ADV_L1 0x00000070            /*  Sensor_Type: RTD 4 Wire PT100 Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_PT1000_ADV_L1 0x00000071            /*  Sensor_Type: RTD 4 Wire PT1000 Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_1_ADV_L2 0x0000007C            /*  Sensor_Type: RTD 4 Wire Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_2_ADV_L2 0x0000007D            /*  Sensor_Type: RTD 4 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_3_ADV_L2 0x0000007E            /*  Sensor_Type: RTD 4 Wire Sensor 3 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_RTD_4W_4_ADV_L2 0x0000007F            /*  Sensor_Type: RTD 4 Wire Sensor 4 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_A_10K_DEF_L1 0x00000080            /*  Sensor_Type: Thermistor Type A 10kOhm Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_B_10K_DEF_L1 0x00000081            /*  Sensor_Type: Thermistor Type B 10kOhm Sensor Defined Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_1_DEF_L2 0x0000008C            /*  Sensor_Type: Thermistor Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_2_DEF_L2 0x0000008D            /*  Sensor_Type: Thermistor Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_3_DEF_L2 0x0000008E            /*  Sensor_Type: Thermistor Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_4_DEF_L2 0x0000008F            /*  Sensor_Type: Thermistor Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_A_10K_ADV_L1 0x00000090            /*  Sensor_Type: Thermistor Type A 10kOhm Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_B_10K_ADV_L1 0x00000091            /*  Sensor_Type: Thermistor Type B 10kOhm Sensor Advanced Level 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_1_ADV_L2 0x0000009C            /*  Sensor_Type: Thermistor Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_2_ADV_L2 0x0000009D            /*  Sensor_Type: Thermistor Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_3_ADV_L2 0x0000009E            /*  Sensor_Type: Thermistor Sensor 3 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_THERMISTOR_4_ADV_L2 0x0000009F            /*  Sensor_Type: Thermistor Sensor 4 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_1_DEF_L2 0x000000A0            /*  Sensor_Type: Bridge 4 Wire Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_2_DEF_L2 0x000000A1            /*  Sensor_Type: Bridge 4 Wire Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_3_DEF_L2 0x000000A2            /*  Sensor_Type: Bridge 4 Wire Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_4_DEF_L2 0x000000A3            /*  Sensor_Type: Bridge 4 Wire Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_1_ADV_L2 0x000000B0            /*  Sensor_Type: Bridge 4 Wire Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_2_ADV_L2 0x000000B1            /*  Sensor_Type: Bridge 4 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_3_ADV_L2 0x000000B2            /*  Sensor_Type: Bridge 4 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_4W_4_ADV_L2 0x000000B3            /*  Sensor_Type: Bridge 4 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_1_DEF_L2 0x000000C0            /*  Sensor_Type: Bridge 6 Wire Sensor 1 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_2_DEF_L2 0x000000C1            /*  Sensor_Type: Bridge 6 Wire Sensor 2 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_3_DEF_L2 0x000000C2            /*  Sensor_Type: Bridge 6 Wire Sensor 3 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_4_DEF_L2 0x000000C3            /*  Sensor_Type: Bridge 6 Wire Sensor 4 Defined Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_1_ADV_L2 0x000000D0            /*  Sensor_Type: Bridge 6 Wire Sensor 1 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_2_ADV_L2 0x000000D1            /*  Sensor_Type: Bridge 6 Wire Sensor 2 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_3_ADV_L2 0x000000D2            /*  Sensor_Type: Bridge 6 Wire Sensor 3 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_BRIDGE_6W_4_ADV_L2 0x000000D3            /*  Sensor_Type: Bridge 6 Wire Sensor 4 Advanced Level 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE 0x00000100            /*  Sensor_Type: Voltage Input */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_HONEYWELL_TRUSTABILITY 0x00000110            /*  Sensor_Type: Voltage Output Pressure Sensor 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_AMPHENOL_NPA300X 0x00000111            /*  Sensor_Type: Voltage Output Pressure Sensor 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_VOLTAGE_PRESSURE_3_DEF 0x00000112            /*  Sensor_Type: Voltage Output Pressure Sensor 3 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT 0x00000180            /*  Sensor_Type: Current Input */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_HONEYWELL_PX2 0x00000181            /*  Sensor_Type: Current Output Pressure Sensor 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_CURRENT_PRESSURE_2 0x00000182            /*  Sensor_Type: Current Output Pressure Sensor 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_CUSTOM1 0x00000200            /*  Sensor_Type: Custom1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_1 0x00000800            /*  Sensor_Type: I2C Pressure Sensor 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_PRESSURE_2 0x00000801            /*  Sensor_Type: I2C Pressure Sensor 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_HONEYWELL_HUMIDICON 0x00000840            /*  Sensor_Type: I2C Humidity Sensor 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_I2C_HUMIDITY_SENSIRION_SHT3X 0x00000841            /*  Sensor_Type: I2C Humidity Sensor 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_PRESSURE_HONEYWELL_TRUSTABILITY 0x00000C00            /*  Sensor_Type: SPI Pressure Sensor 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_PRESSURE_2 0x00000C01            /*  Sensor_Type: SPI Pressure Sensor 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_1 0x00000C40            /*  Sensor_Type: SPI Humidity Sensor Type 1 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_HUMIDITY_2 0x00000C41            /*  Sensor_Type: SPI Humidity Sensor Type 2 */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_1 0x00000C80            /*  Sensor_Type: SPI Accelerometer Sensor Type 1 3-Axis */
#define ENUM_ADISENSE_CORE_SENSOR_TYPE_SENSOR_SPI_ACCELEROMETER_2 0x00000C81            /*  Sensor_Type: SPI Accelerometer Sensor Type 2 3-Axis */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_SENSOR_DETAILS[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_AVERAGING 28            /*  Number of ADC Results to Average */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN 24            /*  PGA Gain */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_REFERENCE_SELECT 20            /*  Reference Selection */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_VBIAS 19            /*  Controls ADC Vbias Output */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_REFERENCE_BUFFER_DISABLE 18            /*  Enable or Disable ADC Reference Buffer */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_DO_NOT_PUBLISH 17            /*  Do Not Publish Channel Result */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL3 12            /*  Indicates Channel for Third Term of Compensation */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL2  8            /*  Indicates Channel for Second Term of Compensation */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL  4            /*  Indicates Which Channel is Used to Compensate Sensor Result */
#define BITP_ADISENSE_CORE_SENSOR_DETAILS_MEASUREMENT_UNITS  0            /*  Units of Sensor Measurement */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_AVERAGING 0x70000000    /*  Number of ADC Results to Average */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN 0x07000000    /*  PGA Gain */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_REFERENCE_SELECT 0x00F00000    /*  Reference Selection */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_VBIAS 0x00080000    /*  Controls ADC Vbias Output */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_REFERENCE_BUFFER_DISABLE 0x00040000    /*  Enable or Disable ADC Reference Buffer */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_DO_NOT_PUBLISH 0x00020000    /*  Do Not Publish Channel Result */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL3 0x0000F000    /*  Indicates Channel for Third Term of Compensation */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL2 0x00000F00    /*  Indicates Channel for Second Term of Compensation */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL 0x000000F0    /*  Indicates Which Channel is Used to Compensate Sensor Result */
#define BITM_ADISENSE_CORE_SENSOR_DETAILS_MEASUREMENT_UNITS 0x0000000F    /*  Units of Sensor Measurement */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_1 0x00000000            /*  PGA_Gain: Gain of 1 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_2 0x01000000            /*  PGA_Gain: Gain of 2 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_4 0x02000000            /*  PGA_Gain: Gain of 4 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_8 0x03000000            /*  PGA_Gain: Gain of 8 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_16 0x04000000            /*  PGA_Gain: Gain of 16 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_32 0x05000000            /*  PGA_Gain: Gain of 32 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_64 0x06000000            /*  PGA_Gain: Gain of 64 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_PGA_GAIN_128 0x07000000            /*  PGA_Gain: Gain of 128 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_INT 0x00000000            /*  Reference_Select: Internal Reference */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_AVDD 0x00100000            /*  Reference_Select: AVDD */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_VEXT1 0x00200000            /*  Reference_Select: External Voltage on Refin1 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_VEXT2 0x00300000            /*  Reference_Select: External Voltage on Refin2 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_RINT1 0x00400000            /*  Reference_Select: Internal Resistor1 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_RINT2 0x00500000            /*  Reference_Select: Internal Resistor2 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_REXT1 0x00600000            /*  Reference_Select: External Resistor on Refin1 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_REXT2 0x00700000            /*  Reference_Select: External Resistor on Refin2 */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_REF_EXC 0x00800000            /*  Reference_Select: Bridge Excitation Voltage */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_UNITS_DEGC 0x00000000            /*  Measurement_Units: Degrees C */
#define ENUM_ADISENSE_CORE_SENSOR_DETAILS_UNITS_DEGF 0x00000001            /*  Measurement_Units: Degrees F */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_CHANNEL_EXCITATION[n]  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_DONT_SWAP_3WIRE  7            /*  Indicates 3-Wire Excitation Currents Should Not Be Swapped */
#define BITP_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_STATIC_SWAP_3WIRE  6            /*  Indicates 3-Wire Excitation Currents Should Be Swapped */
#define BITP_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT1_DISABLE  4            /*  Disable Second Current Source */
#define BITP_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT0_DISABLE  3            /*  Disable First Current Source */
#define BITP_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_EXCITATION_CURRENT  0            /*  Current Source Value */
#define BITM_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_DONT_SWAP_3WIRE 0x00000080    /*  Indicates 3-Wire Excitation Currents Should Not Be Swapped */
#define BITM_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_STATIC_SWAP_3WIRE 0x00000040    /*  Indicates 3-Wire Excitation Currents Should Be Swapped */
#define BITM_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT1_DISABLE 0x00000010    /*  Disable Second Current Source */
#define BITM_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT0_DISABLE 0x00000008    /*  Disable First Current Source */
#define BITM_ADISENSE_CORE_CHANNEL_EXCITATION_IOUT_EXCITATION_CURRENT 0x00000007    /*  Current Source Value */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_OFF 0x00000000            /*  IOUT_Excitation_Current: Disabled */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_50UA 0x00000001            /*  IOUT_Excitation_Current: 50 \mu;A */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_100UA 0x00000002            /*  IOUT_Excitation_Current: 100 \mu;A */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_250UA 0x00000003            /*  IOUT_Excitation_Current: 250 \mu;A */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_500UA 0x00000004            /*  IOUT_Excitation_Current: 500 \mu;A */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_750UA 0x00000005            /*  IOUT_Excitation_Current: 750 \mu;A */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_1000UA 0x00000006            /*  IOUT_Excitation_Current: 1000 \mu;A */
#define ENUM_ADISENSE_CORE_CHANNEL_EXCITATION_IEXC_1000UA_2 0x00000007            /*  IOUT_Excitation_Current: 1000 \mu;A */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_SETTLING_TIME[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_SETTLING_TIME_SETTLING_TIME  0            /*  Settling Time to Allow When Switching to Channel */
#define BITM_ADISENSE_CORE_SETTLING_TIME_SETTLING_TIME 0x0000FFFF    /*  Settling Time to Allow When Switching to Channel */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_FILTER_SELECT[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_FILTER_SELECT_ADC_FILTER_TYPE 11            /*  ADC Digital Filter Type */
#define BITP_ADISENSE_CORE_FILTER_SELECT_ADC_FS  0            /*  ADC Digital Filter Select */
#define BITM_ADISENSE_CORE_FILTER_SELECT_ADC_FILTER_TYPE 0x0000F800    /*  ADC Digital Filter Type */
#define BITM_ADISENSE_CORE_FILTER_SELECT_ADC_FS 0x000007FF    /*  ADC Digital Filter Select */
#define ENUM_ADISENSE_CORE_FILTER_SELECT_FILTER_FIR_25SPS 0x00000000            /*  ADC_Filter_Type: FIR Filter 25 SPS */
#define ENUM_ADISENSE_CORE_FILTER_SELECT_FILTER_FIR_20SPS 0x00000800            /*  ADC_Filter_Type: FIR Filter 20 SPS */
#define ENUM_ADISENSE_CORE_FILTER_SELECT_FILTER_SINC4 0x00001000            /*  ADC_Filter_Type: Sinc4 Filter */
#define ENUM_ADISENSE_CORE_FILTER_SELECT_FILTER_TBD 0x00001800            /*  ADC_Filter_Type: TBD Filter */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_HIGH_THRESHOLD_LIMIT[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT_HIGH_THRESHOLD  0            /*  Upper Limit for Sensor Alert Comparison */
#define BITM_ADISENSE_CORE_HIGH_THRESHOLD_LIMIT_HIGH_THRESHOLD 0xFFFFFFFF    /*  Upper Limit for Sensor Alert Comparison */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_LOW_THRESHOLD_LIMIT[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_LOW_THRESHOLD_LIMIT_LOW_THRESHOLD  0            /*  Lower Limit for Sensor Alert Comparison */
#define BITM_ADISENSE_CORE_LOW_THRESHOLD_LIMIT_LOW_THRESHOLD 0xFFFFFFFF    /*  Lower Limit for Sensor Alert Comparison */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_SENSOR_OFFSET[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_SENSOR_OFFSET_SENSOR_OFFSET  0            /*  Sensor Offset Adjustment */
#define BITM_ADISENSE_CORE_SENSOR_OFFSET_SENSOR_OFFSET 0xFFFFFFFF    /*  Sensor Offset Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_SENSOR_GAIN[n]         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_SENSOR_GAIN_SENSOR_GAIN  0            /*  Sensor Gain Adjustment */
#define BITM_ADISENSE_CORE_SENSOR_GAIN_SENSOR_GAIN 0xFFFFFFFF    /*  Sensor Gain Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_ALERT_CODE_CH[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_ALERT_CODE_CH_ALERT_CODE_CH  0            /*  Per-Channel Code Indicating Type of Alert */
#define BITM_ADISENSE_CORE_ALERT_CODE_CH_ALERT_CODE_CH 0x0000FFFF    /*  Per-Channel Code Indicating Type of Alert */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_CONFIG[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_DATA_BITS   11       /*  Number of Relevant Data Bits */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_READ_BYTES  8        /*  Number of bytes to read from the sensor */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_BIT_OFFSET  4        /*  Data Bit Offset, relative to alignment */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LEFT_ALIGNED  3      /*  Data Alignment within the data frame */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LITTLE_ENDIAN  2     /*  Data Endianness of Sensor Result */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_CODING  0            /*  Data Encoding of Sensor Result */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_DATA_BITS 0x000F800    /*  Number of Relevant Data Bits */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_READ_BYTES 0x0000700    /*  Number of bytes to read from the sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_BIT_OFFSET 0x000000F0   /*  Data Bit Offset, relative to alignment */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LEFTALIGNED 0x00000008    /*  Data Alignment within the data frame */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LITTEENDIAN 0x00000004    /*  Data Endianness of Sensor Result */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_CODING 0x00000003    /*  Data Encoding of Sensor Result */
#define ENUM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_NONE 0x00000000            /*  Digital_Sensor_Coding: None/Invalid */
#define ENUM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_UNIPOLAR 0x00000001            /*  Digital_Sensor_Coding: Unipolar */
#define ENUM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_TWOS_COMPL 0x00000002            /*  Digital_Sensor_Coding: Twos Complement */
#define ENUM_ADISENSE_CORE_DIGITAL_SENSOR_CONFIG_CODING_OFFSET_BINARY 0x00000003            /*  Digital_Sensor_Coding: Offset Binary */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS_DIGITAL_SENSOR_ADDRESS  0            /*  I2C Address or Write Address Command for SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_ADDRESS_DIGITAL_SENSOR_ADDRESS 0x000000FF    /*  I2C Address or Write Address Command for SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_READ_CMDS  4            /*  Number of Read Commands for Digital Sensor */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_CFG_CMDS  0            /*  Number of Configuration Commands for Digital Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_READ_CMDS 0x00000070    /*  Number of Read Commands for Digital Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_CFG_CMDS 0x00000007    /*  Number of Configuration Commands for Digital Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND1[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND1_DIGITAL_SENSOR_COMMAND1  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND1_DIGITAL_SENSOR_COMMAND1 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND2[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND2_DIGITAL_SENSOR_COMMAND2  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND2_DIGITAL_SENSOR_COMMAND2 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND3[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND3_DIGITAL_SENSOR_COMMAND3  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND3_DIGITAL_SENSOR_COMMAND3 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND4[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND4_DIGITAL_SENSOR_COMMAND4  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND4_DIGITAL_SENSOR_COMMAND4 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND5[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND5_DIGITAL_SENSOR_COMMAND5  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND5_DIGITAL_SENSOR_COMMAND5 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND6[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND6_DIGITAL_SENSOR_COMMAND6  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND6_DIGITAL_SENSOR_COMMAND6 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_COMMAND7[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND7_DIGITAL_SENSOR_COMMAND7  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_COMMAND7_DIGITAL_SENSOR_COMMAND7 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD1[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD1_DIGITAL_SENSOR_READ_CMD1  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD1_DIGITAL_SENSOR_READ_CMD1 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD2[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD2_DIGITAL_SENSOR_READ_CMD2  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD2_DIGITAL_SENSOR_READ_CMD2 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD3[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD3_DIGITAL_SENSOR_READ_CMD3  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD3_DIGITAL_SENSOR_READ_CMD3 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD4[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD4_DIGITAL_SENSOR_READ_CMD4  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD4_DIGITAL_SENSOR_READ_CMD4 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD5[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD5_DIGITAL_SENSOR_READ_CMD5  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD5_DIGITAL_SENSOR_READ_CMD5 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD6[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD6_DIGITAL_SENSOR_READ_CMD6  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD6_DIGITAL_SENSOR_READ_CMD6 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD7[n] Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD7_DIGITAL_SENSOR_READ_CMD7  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_ADISENSE_CORE_DIGITAL_SENSOR_READ_CMD7_DIGITAL_SENSOR_READ_CMD7 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */


/* ============================================================================================================================
        Test Registers
   ============================================================================================================================ */

/* ============================================================================================================================
        ADISENSE_TEST
   ============================================================================================================================ */
#define MOD_ADISENSE_TEST_BASE                0x00000400         /*  Test Registers  */
#define MOD_ADISENSE_TEST_MASK                0x00007FFF         /*  Test Registers  */
#define REG_ADISENSE_TEST_TEST_REG_0_RESET    0x00000000         /*      Reset Value for test_reg_0  */
#define REG_ADISENSE_TEST_TEST_REG_0          0x00000400         /*  ADISENSE_TEST Test Register 0 */
#define REG_ADISENSE_TEST_ADC_CAL_TEMP_RESET  0x7fc00000         /*  Reset Value for ADISENSE_TEST_ADC_CAL_TEMP  */
#define REG_ADISENSE_TEST_ADC_CAL_TEMP        0x00000404         /*  ADC-sourced temperature used for calibration (read-only) */
#define REG_ADISENSE_TEST_USER_CAL_TEMP_RESET 0x7fc00000         /*  Reset Value for ADISENSE_TEST_USER_CAL_TEMP  */
#define REG_ADISENSE_TEST_USER_CAL_TEMP       0x00000408         /*  User-specified temperature override for calibration */

/* ============================================================================================================================
        ADISENSE_TEST Register BitMasks, Positions & Enumerations
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          ADISENSE_TEST_TEST_REG_0              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_ADISENSE_TEST_TEST_REG_0_TEST_COMMAND  0            /*  Test_Command */
#define BITM_ADISENSE_TEST_TEST_REG_0_TEST_COMMAND 0x000000FF    /*  Test_Command */


/* ADISENSE_SPI Parameters */

/***** ADISENSE_SPI  */
#define PARAM_ADISENSE_SPI_SPI_STANDARD      "LPT"             /*  A part must declare which SPI Standard it follows, either ADI or LPT  */
#define PARAM_ADISENSE_SPI_CHIP_GRADE_VALUE          0             /*  This is used to indicate speed grades/linearity.  */
#define PARAM_ADISENSE_SPI_CHIP_REVISION_VALUE          0             /*  This is used to indicate the silicon revision  */
#define PARAM_ADISENSE_SPI_HAS_M_S_REGISTERS          0             /*  If a design uses Master-Slave registers this must be set to true to enable relevant control bit fields  */
#define PARAM_ADISENSE_SPI_M_S_TRANSFER_BF_EXISTS          0             /*  Used to set EXISTS the M-S Transfer bit field  */
#define PARAM_ADISENSE_SPI_STREAM_MODE_TRANSFER_BF_EXISTS          0             /*  Used to set EXISTS of the stream mode transfer bit field  */
#define PARAM_ADISENSE_SPI_MSB_AND_LSB_FIRST_SUPPORT          0             /*  Determines if the parts supports MSB and LSB first options  */
#define PARAM_ADISENSE_SPI_WIRE_MODE_SUPPORT  "_4_WIRE"             /*  Configures which hardware SPI modes are supported  */
#define PARAM_ADISENSE_SPI_WIRE_MODE_DEFAULT  "_4_WIRE"             /*  Sets the default hardware SPI mode  */
#define PARAM_ADISENSE_SPI_MULTI_IO_CHANNELS          1             /*  Defines the number of SDIO pins supported by the SPI in Multi-IO Mode. Should be 1,2,4, or 8.  */
#define PARAM_ADISENSE_SPI_LPT_STANDARD_VERSION   "REV1_0"             /*  This is a string from the LPT_STANDARD_VERSION_OPTIONS array for the active LPT SPI Standard version  */
#define PARAM_ADISENSE_SPI_HAS_CSB_PIN          1             /*  Does the part have a csb pin?  */
#define PARAM_ADISENSE_SPI_BUS_MODE_SUPPORT          1             /*  When set to true, Bus mode is supported.  */
#define PARAM_ADISENSE_SPI_ISOLATED_3_WIRE_SUPPORT          0             /*  Does the part support the 3-wire isolate mode of operation  */
#define PARAM_ADISENSE_SPI_DAISY_CHAIN_MODE_SUPPORT          0             /*  When set to true, Daisy chain mode is supported.  */
#define PARAM_ADISENSE_SPI_CHECK_GTE_1_MODE_SUPPORTED          1             /*  This is used to check that at least mode is enabled  */
#define PARAM_ADISENSE_SPI_INTERFACE_MODE_SWITCH     "None"             /*  Valid options are 'None', 'HW' or 'SW'  */
#define PARAM_ADISENSE_SPI_CRC_SUPPORT "CRC_CONFIGURABLE"             /*  Set to true to enable bit fields related to CRC.  */
#define PARAM_ADISENSE_SPI_CRC_SUPPORT_ENABLED          0             /*  Verilog output parameter for 'define  */
#define PARAM_ADISENSE_SPI_CRC_SUPPORT_ENABLE          1             /*  Configures if CRC features are enabled in the module  */
#define PARAM_ADISENSE_SPI_LPT_STANDARD_VERSION_VALUE          2             /*  Index value of the active LPT SPI Standard version  */
#define PARAM_ADISENSE_SPI_ADDRESS_MODE_SUPPORT  "_15_BIT"             /*  Configures which addressing modes are supported  */
#define PARAM_ADISENSE_SPI_ADDRESS_MODE_DEFAULT  "_15_BIT"             /*  Sets the default addressing mode  */
#define PARAM_ADISENSE_SPI_ADDRESS_BUS_WIDTH         15             /*  Verilog output parameter for 'define  */
#define PARAM_ADISENSE_SPI_SLOW_IFACE_CTRL_SUPPORT          0             /*  Does the part support the Slow Interface Control feature  */
#define PARAM_ADISENSE_SPI_SOFT_RESET_0_BF_EXISTS          0             /*  Used to control if the SOFT_RESET_0 bit field exists  */
#define PARAM_ADISENSE_SPI_SOFT_RESET_1_BF_EXISTS          0             /*  Used to control if the SOFT_RESET_1 bit field exists  */
#define PARAM_ADISENSE_SPI_SEND_STATUS_SUPPORT "NO_SEND_STATUS"             /*  Determines if and how the part supports the SEND_STATUS feature  */
#define PARAM_ADISENSE_SPI_SEND_STATUS_SUPPORT_ENABLE          0             /*  This is used to enable various send status features  */
#define PARAM_ADISENSE_SPI_SPI_STANDARD_VERSION_VALUE          2             /*  Value for SPI Standard VERSION bit field  */
#define PARAM_ADISENSE_SPI_ENTITY_ACCESS_SUPPORT "ENTITY_ACCESS_ALWAYS"             /*  Configures which entity access mode(s) are supported  */
#define PARAM_ADISENSE_SPI_ENTITY_ACCESS_SUPPORT_ENABLE          1             /*  This is used to enable/disable Strict Entity Access features  */
#define PARAM_ADISENSE_SPI_ENTITY_ACCESS_DEFAULT          1             /*  Sets the default entity access mode  */
#define PARAM_ADISENSE_SPI_CHIP_INDEX_EXISTS          0             /*  Used to control if the CHIP_INDEX register and related bit field exists  */
#define PARAM_ADISENSE_SPI_OFFSET_DEV_INDEX_EXISTS          0             /*  Used to control if the OFFSET_DEV_INDEX bit field and registers exists  */
#define PARAM_ADISENSE_SPI_DEV_INDEX_EXISTS          0             /*  Used to control if the DEV_INDEX bit field and register exists  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_0_EXISTS          0             /*  Sets EXIST for Status Bit 0  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_1_EXISTS          0             /*  Sets EXIST for Status Bit 1  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_2_EXISTS          0             /*  Sets EXIST for Status Bit 2  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_3_EXISTS          0             /*  Sets EXIST for Status Bit 3  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_0_SWNAME "Status_Bit_0"             /*  Software Name for Status Bit 0  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_1_SWNAME "Status_Bit_1"             /*  Software Name for Status Bit 1  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_2_SWNAME "Status_Bit_2"             /*  Software Name for Status Bit 2  */
#define PARAM_ADISENSE_SPI_STATUS_BIT_3_SWNAME "Status_Bit_3"             /*  Software Name for Status Bit 3  */
#define PARAM_ADISENSE_SPI_CHIP_TYPE    "P_ADC"             /*  This is a string that corresponds to one of the values in the CHIP_TYPE_OPTIONS array and corresponds to the type of chip being developed  */
#define PARAM_ADISENSE_SPI_CHIP_TYPE_VALUE          7             /*  Integer value corresponding to selected CHIP_TYPE, and is used as bit field enum value  */
#define PARAM_ADISENSE_SPI_PRODUCT_ID_VALUE         32             /*  This value is used to identify a specific generic.  */
#define PARAM_ADISENSE_SPI_PRODUCT_ID_TRIM_BITS          4             /*  This defines the number of PRODUCT_ID bits that can be fuse/trimmed.  */

#endif	/* end ifndef _DEF_ADISENSE1000_REGISTERS_H */

