/*
Copyright (c) 2011 Bart Janssens

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/* Defines for the PS3 Buttons 
*/


#define BUTTONSELECT    0
#define BUTTONLANALOG   1
#define BUTTONRANALOG   2
#define BUTTONSTART     3
#define BUTTONUP        4
#define BUTTONRIGHT     5
#define BUTTONDOWN      6
#define BUTTONLEFT      7
#define BUTTONL2        8
#define BUTTONR2        9
#define BUTTONL1        10
#define BUTTONR1        11
#define BUTTONTRIANGEL  12
#define BUTTONCIRCLE    13
#define BUTTONCROSS     14
#define BUTTONSQUARE    15
#define BUTTONPS        16


/* Defines for the PS3 Joysticks 
*/

#define LEFTJOYSTICKX 0
#define LEFTJOYSTICKY 1
#define RIGHTJOYSTICKX 2
#define RIGHTJOYSTICKY 3


/* Defines for the PS3 Accelerometers and Gyro 
*/

#define ACCELOROMETERX 0
#define ACCELOROMETERY 1
#define ACCELOROMETERZ 2
#define GYROMETERZ 3

/* Defines for the PS3 LED and Rumble 
*/
#define PS3LED1 0x01
#define PS3LED2 0x02
#define PS3LED3 0x04
#define PS3LED4 0x08
#define PSRUMBLEHIGH 0x10
#define PSRUMBLELOW 0x20

//Structure which describes the type 01 input report
typedef struct {        
     u8 ReportType;     //Report Type 01
     u8 Reserved1;      // Unknown
     u16 ButtonState;    // Main buttons
     u8 PSButtonState;  // PS button
     u8 Reserved2;      // Unknown
     u8 LeftStickX;     // left Joystick X axis 0 - 255, 128 is mid
     u8 LeftStickY;     // left Joystick Y axis 0 - 255, 128 is mid
     u8 RightStickX;    // right Joystick X axis 0 - 255, 128 is mid
     u8 RightStickY;    // right Joystick Y axis 0 - 255, 128 is mid
     u8 Reserved3[4];   // Unknown
     u8 PressureUp;     // digital Pad Up button Pressure 0 - 255
     u8 PressureRight;  // digital Pad Right button Pressure 0 - 255
     u8 PressureDown;   // digital Pad Down button Pressure 0 - 255
     u8 PressureLeft;   // digital Pad Left button Pressure 0 - 255
     u8 PressureL2;     // digital Pad L2 button Pressure 0 - 255
     u8 PressureR2;     // digital Pad R2 button Pressure 0 - 255
     u8 PressureL1;     // digital Pad L1 button Pressure 0 - 255
     u8 PressureR1;     // digital Pad R1 button Pressure 0 - 255
     u8 PressureTriangle;   // digital Pad Triangle button Pressure 0 - 255
     u8 PressureCircle;     // digital Pad Circle button Pressure 0 - 255
     u8 PressureCross;      // digital Pad Cross button Pressure 0 - 255
     u8 PressureSquare;     // digital Pad Square button Pressure 0 - 255
     u8 Reserved4[3];   // Unknown
     u8 Charge;         // charging status ? 02 = charge, 03 = normal
     u8 Power;          // Battery status ?
     u8 Connection;     // Connection Type ?
     u8 Reserved5[9];   // Unknown
     u16 AccelX;          // X axis accelerometer Big Endian 0 - 1023
     u16 AccelY;          // Y axis accelerometer Big Endian 0 - 1023
     u16 AccelZ;          // Z axis accelerometer Big Endian 0 - 1023
     u16 GyroZ;           // Z axis Gyro Big Endian 0 - 1023
    
} ps3report;

class Ps3USB
{
    
    
    public:
    Ps3USB(int device, int configuration, int interfaceNumber);
    int Enable();
    int SetPair(u8* bdAddr);
    int ShowPair();
    int Led(int i);
    int Rumble(u8 duration_right, u8 power_right, u8 duration_left, u8 power_left);
    int _count;
    
    private:
    int input_ep;
    int output_ep;
    int _device;
    int _configuration;
    int _interfaceNumber;
    
    u8 ledrumble[48] ;
    
};

void PS3EventCallback(int device, int endpoint, int status, u8* data, int len, void* userData);
int ParsePs3Result(const u8* data, int len, int count);


