#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"

#include "mbed.h"

int RSX,RSY,LSX,LSY,BSU,BSL;
int servo2value;

//これより下に関数外に書く要素を記入する
PwmOut servo1(p21);
PwmOut servo2(p22);
PwmOut left1(p23);
PwmOut left2(p24);
PwmOut right1(p25);
PwmOut right2(p26);

void UserLoopSetting()
{
    servo2value = 950;
    
    //一度だけ行いたい初期設定をここに書く
    
    servo1.period_ms(20);
    servo2.period_ms(20);

    servo1.pulsewidth_us(950);
    servo2.pulsewidth_us(servo2value);

    left1 = 0;
    left2 = 0;
    right1 = 0;
    right2 = 0;
}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }

    //○が押されたとき
    if((ButtonState >> BUTTONCIRCLE)&1 == 1) {
        servo1.pulsewidth_us(750);
    } else if((ButtonState >> BUTTONTRIANGEL)&1 == 1) {
        servo1.pulsewidth_us(1200);
    } else if((ButtonState >> BUTTONCROSS)&1 == 1) {
        servo1.pulsewidth_us(1800);
    }

    if((ButtonState >> BUTTONL1)&1 == 1) {
        ++servo2value;
        servo2.pulsewidth_us(servo2value);
    } else if((ButtonState >> BUTTONR1)&1 == 1) {
        --servo2value;
        servo2.pulsewidth_us(servo2value);
    }

    if(LSY > 130) {
        left2 = ((LSY - 128) / 128.0f * 0.8f);
        left1 = 0;
    } else if(LSY < 120) {
        left1= (LSY / 128.0f * 0.8f);
        left2 = 0;
    } else {
        left1 = 0;
        left2 = 0;
    }

    if(RSY>130) {
        right2 = ((RSY - 128)/ 128.0f * 0.8f);
        right1 = 0;
    } else if(LSY < 120) {
        right1 = (RSY / 128.0f * 0.8f);
        right2 = 0;
    } else {
        right1 = 0;
        right2 = 0;
    }

    //led1=LSX/256.0f;
    //led2=LSY/256.0f;
    //led3=ButtonState & 0x0400;  //L1の状態
    //led4=ButtonState & 0x0800;  //R1の状態
    //値の取得はps3.hを参照
    //ここまでプログラム例    実機に乗せるときは消して大丈夫です



}