#include "mbed.h"

DigitalOut Von (P2_13);      // 12 V ON 
DigitalOut LineON (P2_5);    // Line Sensor aktivieren
DigitalIn ISO1 (P1_9);       // ISO1
DigitalIn ISO2 (P0_16);
DigitalIn ISO3 (P0_23);
DigitalIn ISO4 (P0_15);
DigitalIn ISO5 (P1_3);   
 
DigitalOut LedD1 (P1_10);      
DigitalOut LedD2 (P1_11);
DigitalOut LedD4 (P1_12);
DigitalOut LedD5 (P1_13);
DigitalOut LedD6 (P1_14);      
DigitalOut LedD7 (P1_15);
DigitalOut LedD8 (P1_16);
DigitalOut LedD9 (P1_17);
DigitalOut LedD10 (P1_18);     
DigitalOut LedD11 (P2_16);
DigitalOut LedD12 (P1_20);
DigitalOut LedD13 (P1_21);

PwmOut MotorL_EN(P1_19);         
DigitalOut MotorL_FORWARD(P2_15); 
DigitalOut MotorL_REVERSE(P2_14); 

PwmOut MotorR_EN(P2_19);     
DigitalOut MotorR_FORWARD(P2_20);
DigitalOut MotorR_REVERSE(P2_21);

int main() 
{
    MotorL_EN.period_ms(10.0f);
    MotorR_EN.period_ms(10.0f);
    
   do
   {
    MotorR_EN = MotorL_EN = 0.3;
    LineON = 1;
    Von = 1;
   
    MotorR_FORWARD = MotorL_FORWARD = 1;
    
   if(ISO1 == 0)
     {
       MotorR_FORWARD = MotorL_FORWARD = 0;
        MotorL_EN = 0.7;
        MotorL_FORWARD = 1;
        MotorR_FORWARD = 0;
     }
     
    else if(ISO4 == 0)
     {
        MotorR_FORWARD = MotorL_FORWARD = 0;
        MotorL_EN = 0.7;
        MotorL_FORWARD = 0;
        MotorR_FORWARD = 1;
     }
     
     else if(ISO5 == 0)
     {
       MotorR_FORWARD = MotorL_FORWARD = 0;
       MotorR_FORWARD = MotorL_FORWARD = 0.3;
     }
  }while(1); 
}
