#ifndef _H_POWERAWAREI2C_H
#define _H_POWERAWAREI2C_H

#include "mbed.h"
#include "i2c_api.h"

/// This is a variation of I2C class from mbed, which adds power on and off functions to the I2C peripheral. This should save about 1 mA.
class PowerAwareI2C : public I2C
{
public:
    PowerAwareI2C(PinName sda, PinName scl) : I2C(sda, scl) {}

    /// Power on the I2C peripheral
    void powerOn() {
        _i2c.i2c->ENABLE = (TWI_ENABLE_ENABLE_Enabled << TWI_ENABLE_ENABLE_Pos);
    }

    /// Power off the I2C peripheral
    void powerOff() {
        _i2c.i2c->ENABLE = TWI_ENABLE_ENABLE_Disabled << TWI_ENABLE_ENABLE_Pos;
        _i2c.i2c->POWER  = 0;
    }
};

#endif//_H_POWERAWAREI2C_H