#ifndef _H_LOGGER_H
#define _H_LOGGER_H

#define xDEBUG_OUTPUT

#include <cstdio>
#if defined(DEBUG) && defined(DEBUG_OUTPUT)
#define LOG(x, ...)  { printf("\x1b[34m%12.12s: \x1b[39m"x"\x1b[39;49m\r\n", DEBUG, ##__VA_ARGS__); fflush(stdout); }
#define WARN(x, ...) { printf("\x1b[34m%12.12s: \x1b[33m"x"\x1b[39;49m\r\n", DEBUG, ##__VA_ARGS__); fflush(stdout); }
#define ERR(x, ...)  { printf("\x1b[34m%12.12s: \x1b[31m"x"\x1b[39;49m\r\n", DEBUG, ##__VA_ARGS__); fflush(stdout); }
#define INFO(x, ...) { printf("\x1b[34m%12.12s: \x1b[32m"x"\x1b[39;49m\r\n", DEBUG, ##__VA_ARGS__); fflush(stdout); }
#else
#define LOG(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#define INFO(x, ...)
#endif

#if defined(DATA_OUTPUT)
#define DATA(x) { fwrite(&(x), sizeof (x), 1, stdout); fflush(stdout); }
#else
#define DATA(x)
#endif

#endif//_H_LOGGER_H