#ifndef _H_LEDDRIVER_H
#define _H_LEDDRIVER_H

#include "I2CPeripheral.h"

typedef uint32_t Color; // ARGB

namespace Colors
{
// 16 named colours
const Color black = 0x000000;
const Color gray = 0x808080;
const Color silver = 0xC0C0C0;
const Color white = 0xffffff;
const Color maroon = 0x800000;
const Color red = 0xff0000;
const Color olive = 0x808000;
const Color yellow = 0xffff00;
const Color green = 0x008000;
const Color lime = 0x00ff00;
const Color teal = 0x008080;
const Color aqua = 0x00ffff;
const Color navy = 0x000080;
const Color blue = 0x0000ff;
const Color purple = 0x800080;
const Color fuschia = 0xff00ff;

// aliases
const Color deepred = maroon;
const Color darkred = maroon;
const Color cyan = aqua;
const Color magenta = purple;
const Color pink = fuschia;

// other colours
const Color orange = 0xffa500;
const Color slateblue = 0x6a5acd;
};

class LEDDriver : public I2CPeripheral
{
public:
    LEDDriver(I2C &i2c);
    void setOutputCurrent(float mA);
    void setColor(const Color color);
    void setColor(const float r, const float g, const float b);
    void setColor(const uint8_t r, const uint8_t g, const uint8_t b);
    void setWhiteLed(const float w);
    LEDDriver& operator=(const Color& c);
};

#endif//_H_LED_H