#include "LEDDriver.h"
#include "mbed.h"
#define DEBUG "LEDDriver"
#include "Logger.h"

LEDDriver::LEDDriver(I2C &i2c) : I2CPeripheral(i2c, 0x60 /* I2C address of the LED controller */)
{
    // cf. LP5562TME/NOPB datasheet page 14
    // Supply 3.6V to VDD (hardware - done)
    // Supply 1.8V to EN (hardware - done)
    wait_ms(1); // wait 1 ms
    write_reg(0x00, 0xC0); // chip_en to 1, log_en to 1
    wait_us(500); // wait 500 usec
    write_reg(0x08, 0x61); // set PWM freq high, enable power save mode, start internal clock
    write_reg(0x70, 0x00); // configure all LEDs to be controlled from I2C registers

    setColor(Colors::black);

    INFO("LED driver ready");
}

void LEDDriver::setColor(const uint8_t r, const uint8_t g, const uint8_t b)
{
    write_reg(0x04, g);
    write_reg(0x03, r);
    write_reg(0x02, b);
}

void LEDDriver::setColor(const float r, const float g, const float b)
{
    setColor(r * 255, g * 255, b * 255);
}

void LEDDriver::setColor(const Color color)
{
    const uint8_t r = (color >> 16) & 0xff;
    const uint8_t g = (color >> 8) & 0xff;
    const uint8_t b = (color >> 0) & 0xff;
    setColor(r, g, b);
}

void LEDDriver::setWhiteLed(const float w)
{
    uint8_t value = (uint8_t) (w * 255);

    if (value > 255)
        value = 255;

    write_reg(0x0e, value);
}

LEDDriver& LEDDriver::operator=(const Color& c)
{
    setColor(c);
    return *this;
}

void LEDDriver::setOutputCurrent(float mA)
{
    if (mA < 0.1)
        mA = 0.1;
    if (mA > 25.5)
        mA = 25.5;
    write_reg(0x05, mA * 10);
    write_reg(0x06, mA * 10);
    write_reg(0x07, mA * 10);
    write_reg(0x0f, mA * 10);
    INFO("Output current => %0.1f mA", mA);
}
