#ifndef _H_I2CPERIPHERAL_H
#define _H_I2CPERIPHERAL_H

#include "mbed.h"

class I2CPeripheral
{
protected:
    I2C* mBus;
    uint8_t mAddress;

protected:
    void write_reg(const uint8_t reg, const uint8_t val);
    uint8_t read_reg(const uint8_t reg);
    void read_reg(const uint8_t reg, uint8_t* destination, const size_t nBytes = 1);

public:
    I2CPeripheral(I2C &i2c, const uint8_t address);
};

#endif//_H_I2CPERIPHERAL_H