#include "GyroscopeMPU.h"
#define DEBUG "MPU-Gyr"
#include "Logger.h"

#include "Vector3.h"

GyroscopeMPU::GyroscopeMPU(I2C &i2c) : I2CPeripheral(i2c, 0x68 << 1 /* address */), int1(p26)
{
    if (powerOn()) {
        INFO("Invensense MPU9250-Gyro found");
        int1.rise(this, &GyroscopeMPU::handleInterrupt);
        powerOff();
    } else {
        WARN("Invensense MPU9250-Gyro not found");
    }
}

void GyroscopeMPU::powerOff()
{
    LOG("deep sleep");
}

void GyroscopeMPU::handleInterrupt(void)
{
    delegate->sensorUpdate(read());
}

bool GyroscopeMPU::powerOn()
{
    LOG("powered on");
    return read_reg(117) == 0x68; // verify Chip ID
}

void GyroscopeMPU::start()
{
}

void GyroscopeMPU::stop()
{
}

Vector3 GyroscopeMPU::read()
{
    return Vector3(0, 0, 0);
}
